CREATE TABLE CMDOCLAYOUTS
(
  DOCID VARCHAR(32) NOT NULL
, LAYOUTSTYLEID VARCHAR(32) NOT NULL
, LAYOUTDOCID VARCHAR(32)
, LAYOUTDOCVERSIONID INTEGER
, MODIFIED TIMESTAMP NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

)
;
CREATE TABLE CMDOCLINKS
(
  DOCID VARCHAR(32) NOT NULL
, CHILDDOCID VARCHAR(32) NOT NULL
, CHILDVERSIONID INTEGER
, UUID VARCHAR(32) NOT NULL
, EXTNDATA BLOB(2147483646) NOT LOGGED
, MODIFIED TIMESTAMP NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( DOCID, CHILDDOCID )
)
;
CREATE INDEX DLCHILDDOCID_IDX ON CMDOCLINKS (CHILDDOCID);
CREATE TABLE CMDOCCATEGORIES
(
  DOCID VARCHAR(32) NOT NULL
, CATEGORYID VARCHAR(32) NOT NULL
, MODIFIED TIMESTAMP NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( DOCID, CATEGORYID )
)
;
CREATE INDEX DCCATEGORYID_IDX ON CMDOCCATEGORIES (CATEGORYID);
CREATE TABLE CMCATEGORIES
(
  CATEGORYID VARCHAR(32) NOT NULL
, CATEGORYNAME VARCHAR(80) NOT NULL
, DESCRIPTION VARCHAR(255)
, CATEGORYTYPE INTEGER
, PARENTID VARCHAR(32)
, REPID VARCHAR(32)
, MODIFIED TIMESTAMP
, MODIFIER VARCHAR(255)
, ORIGINATOR INTEGER

, PRIMARY KEY ( CATEGORYID )
)
;
CREATE INDEX CPARENTID_IDX ON CMCATEGORIES (PARENTID);
CREATE TABLE CMDOCCONTENTS
(
  DOCID VARCHAR(32) NOT NULL
, UUID VARCHAR(32) NOT NULL
, MIMETYPE VARCHAR(80)
, CONTENTENCODING VARCHAR(80)
, CONTENTDATA BLOB(2147483646) NOT LOGGED
, CONTENTSIZE INTEGER
, VERSIONID INTEGER
, REPID VARCHAR(32)
, MODIFIED TIMESTAMP
, MODIFIER VARCHAR(255)
, ORIGINATOR INTEGER

, PRIMARY KEY ( DOCID )
)
;
CREATE TABLE CMDOCCONTENTSVERSIONS
(
  VERSIONID INTEGER NOT NULL
, UUID VARCHAR(32) NOT NULL
, DOCID VARCHAR(32) NOT NULL
, MIMETYPE VARCHAR(80)
, CONTENTENCODING VARCHAR(80)
, CONTENTDATA BLOB(2147483646) NOT LOGGED
, CONTENTSIZE INTEGER
, MODIFIED TIMESTAMP NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, VERCOMMENT VARCHAR(255)
, ORIGINATOR INTEGER

, PRIMARY KEY ( VERSIONID, DOCID )
)
;
CREATE INDEX DCVDOCID_IDX ON CMDOCCONTENTSVERSIONS (DOCID);
CREATE TABLE CMDOCFIELDVALUES
(
  UUID VARCHAR(32) NOT NULL
, DOCID VARCHAR(32) NOT NULL
, FIELDID VARCHAR(32) NOT NULL
, FIELDVALUE VARCHAR(255)
, MODIFIED TIMESTAMP NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( UUID )
)
;
CREATE INDEX DFVDOCID_IDX ON CMDOCFIELDVALUES (DOCID);
CREATE TABLE CMLAYOUTDOCUMENTS
(
  LAYOUTSTYLEID VARCHAR(32) NOT NULL
, LAYOUTDOCID VARCHAR(32) NOT NULL
, USERAGENT VARCHAR(64) NOT NULL
, MODIFIED TIMESTAMP NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( LAYOUTSTYLEID, LAYOUTDOCID, USERAGENT )
)
;
CREATE TABLE CMDOCUMENTS
(
  DOCID VARCHAR(32) NOT NULL
, DOCNAME VARCHAR(255) NOT NULL
, DOCTYPEID VARCHAR(32) NOT NULL
, FOLDERID VARCHAR(32) NOT NULL
, AUTHOR VARCHAR(255)
, CREATED TIMESTAMP NOT NULL
, TITLE VARCHAR(255)
, SUBTITLE VARCHAR(255)
, DOCABSTRACT CLOB(2147483646) NOT LOGGED
, PUBLISHDATE TIMESTAMP
, EXPIRATIONDATE TIMESTAMP
, LOCKEDBY VARCHAR(80)
, STATUS VARCHAR(80)
, PARENTDOCID VARCHAR(32)
, REPID VARCHAR(32)
, MODIFIED TIMESTAMP NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, PUBLISHSTATUS INTEGER
, ORIGINATOR INTEGER

, PRIMARY KEY ( DOCID )
)
;
CREATE INDEX DDOCTYPEID_IDX ON CMDOCUMENTS (DOCTYPEID);
CREATE INDEX DFOLDERID_IDX ON CMDOCUMENTS (FOLDERID);
CREATE TABLE CMFOLDERS
(
  FOLDERID VARCHAR(32) NOT NULL
, FOLDERNAME VARCHAR(255) NOT NULL
, CREATOR VARCHAR(255)
, CREATED TIMESTAMP NOT NULL
, DESCRIPTION VARCHAR(255)
, FOLDERTYPE INTEGER NOT NULL
, MODIFIED TIMESTAMP
, MODIFIER VARCHAR(255)
, FOLDERSIZE NUM(19) NOT NULL
, PARENTID VARCHAR(32)
, REPID VARCHAR(32)
, ORIGINATOR INTEGER

, PRIMARY KEY ( FOLDERID )
)
;
CREATE INDEX CMFLDRPARNT_IDX ON CMFOLDERS (PARENTID);
CREATE TABLE CMDOCLAYOUTSTYLES
(
  LAYOUTSTYLEID VARCHAR(32) NOT NULL
, DOCTYPEID VARCHAR(32) NOT NULL
, ISDEFAULT VARCHAR(1) NOT NULL
, STYLENAME VARCHAR(255)
, DESCRIPTION VARCHAR(255)
, MODIFIED TIMESTAMP
, MODIFIER VARCHAR(255)
, ORIGINATOR INTEGER

, PRIMARY KEY ( LAYOUTSTYLEID )
)
;
CREATE INDEX DLSDOCTYPEID_IDX ON CMDOCLAYOUTSTYLES (DOCTYPEID);
CREATE TABLE CMDOCFIELDIDS
(
  DOCTYPEID VARCHAR(32) NOT NULL
, FIELDID VARCHAR(32) NOT NULL
, MODIFIED TIMESTAMP NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( DOCTYPEID, FIELDID )
)
;
CREATE INDEX DFIFIELDID_IDX ON CMDOCFIELDIDS (FIELDID);
CREATE TABLE CMDOCFIELDS
(
  FIELDID VARCHAR(32) NOT NULL
, FIELDNAME VARCHAR(80) NOT NULL
, DATATYPE VARCHAR(1) NOT NULL
, EXTNDATA BLOB(2147483646) NOT LOGGED
, MODIFIED TIMESTAMP NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( FIELDID )
)
;
CREATE TABLE CMDOCTYPES
(
  DOCTYPEID VARCHAR(32) NOT NULL
, DOCTYPENAME VARCHAR(80) NOT NULL
, DESCRIPTION VARCHAR(255)
, EXTNDATA BLOB(2147483646) NOT LOGGED
, MODIFIED TIMESTAMP
, MODIFIER VARCHAR(255)
, ORIGINATOR INTEGER

, PRIMARY KEY ( DOCTYPEID )
)
;
CREATE TABLE CMREPOSITORIES
(
  REPID VARCHAR(32) NOT NULL
, REPNAME VARCHAR(80) NOT NULL UNIQUE
, DATASOURCE VARCHAR(80)
, REPTYPE INTEGER
, DESCRIPTION VARCHAR(255)
, UPDATETIME TIMESTAMP NOT NULL
, UPDATEUSER VARCHAR(255)
, ORIGINATOR INTEGER

, PRIMARY KEY ( REPID )
)
;
CREATE TABLE CMDOCFVTIMESTAMPS
(
  UUID VARCHAR(32) NOT NULL
, DOCID VARCHAR(32) NOT NULL
, FIELDID VARCHAR(32) NOT NULL
, FIELDVALUE TIMESTAMP
, MODIFIED TIMESTAMP NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( UUID )
)
;
CREATE INDEX DFVTSDOCID_IDX ON CMDOCFVTIMESTAMPS (DOCID);
CREATE INDEX DFVTSFIELDID_IDX ON CMDOCFVTIMESTAMPS (FIELDID);
CREATE TABLE CMDOCFVNUMERICS
(
  UUID VARCHAR(32) NOT NULL
, DOCID VARCHAR(32) NOT NULL
, FIELDID VARCHAR(32) NOT NULL
, FIELDVALUE NUM(31, 10)
, MODIFIED TIMESTAMP NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( UUID )
)
;
CREATE INDEX DFVNUMDOCID_IDX ON CMDOCFVNUMERICS (DOCID);
CREATE INDEX DFVNUMFIELDID_IDX ON CMDOCFVNUMERICS (FIELDID);
CREATE TABLE CMDOCFVLVCHARS
(
  UUID VARCHAR(32) NOT NULL
, DOCID VARCHAR(32) NOT NULL
, FIELDID VARCHAR(32) NOT NULL
, FIELDVALUE CLOB(2147483646) NOT LOGGED
, MODIFIED TIMESTAMP NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( UUID )
)
;
CREATE INDEX DFVLVCDOCID_IDX ON CMDOCFVLVCHARS (DOCID);
CREATE INDEX DFVLVCFIELDID_IDX ON CMDOCFVLVCHARS (FIELDID);
CREATE TABLE CMDOCFVLVBINARIES
(
  UUID VARCHAR(32) NOT NULL
, DOCID VARCHAR(32) NOT NULL
, FIELDID VARCHAR(32) NOT NULL
, FIELDVALUE BLOB(2147483646) NOT LOGGED
, MODIFIED TIMESTAMP NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( UUID )
)
;
CREATE INDEX DFVLVBDOCID_IDX ON CMDOCFVLVBINARIES (DOCID);
CREATE INDEX DFVLVBFIELDID_IDX ON CMDOCFVLVBINARIES (FIELDID);
ALTER TABLE CMDOCLINKS ADD CONSTRAINT FK_DOCLINKS_DOCID FOREIGN KEY  ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCLINKS ADD CONSTRAINT FK_DOCLNKS_CHDOCID FOREIGN KEY  ( CHILDDOCID)
    REFERENCES CMDOCUMENTS (DOCID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCCATEGORIES ADD CONSTRAINT FK_DCCTGRIS_DCMNTS FOREIGN KEY  ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCCATEGORIES ADD CONSTRAINT FK_DCCTGRIS_CTGRIS FOREIGN KEY  ( CATEGORYID)
    REFERENCES CMCATEGORIES (CATEGORYID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMCATEGORIES ADD CONSTRAINT FK_CTGRIS_PRNTID FOREIGN KEY  ( PARENTID)
    REFERENCES CMCATEGORIES (CATEGORYID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCCONTENTS ADD CONSTRAINT FK_CONTENTS_REPS FOREIGN KEY  ( REPID)
    REFERENCES CMREPOSITORIES (REPID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCCONTENTSVERSIONS ADD CONSTRAINT FK_DCCNTVRS_DCMNTS FOREIGN KEY  ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCFIELDVALUES ADD CONSTRAINT FK_FLDVALUES_FLDS FOREIGN KEY  ( FIELDID)
    REFERENCES CMDOCFIELDS (FIELDID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCFIELDVALUES ADD CONSTRAINT FK_FLDVALS_DCMNTS FOREIGN KEY  ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMLAYOUTDOCUMENTS ADD CONSTRAINT FK_LYDCMNTS_DCLYST FOREIGN KEY  ( LAYOUTSTYLEID)
    REFERENCES CMDOCLAYOUTSTYLES (LAYOUTSTYLEID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCUMENTS ADD CONSTRAINT FK_DCMNTS_DCTYPES FOREIGN KEY  ( DOCTYPEID)
    REFERENCES CMDOCTYPES (DOCTYPEID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCUMENTS ADD CONSTRAINT FK_DCMNTS_FLDRS FOREIGN KEY  ( FOLDERID)
    REFERENCES CMFOLDERS (FOLDERID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCUMENTS ADD CONSTRAINT FK_DCMNTS_REPS FOREIGN KEY  ( REPID)
    REFERENCES CMREPOSITORIES (REPID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMFOLDERS ADD CONSTRAINT FK_FLDRS_PRNTID FOREIGN KEY  ( PARENTID)
    REFERENCES CMFOLDERS (FOLDERID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCLAYOUTSTYLES ADD CONSTRAINT FK_DCLYTST_DCTYPES FOREIGN KEY  ( DOCTYPEID)
    REFERENCES CMDOCTYPES (DOCTYPEID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCFIELDIDS ADD CONSTRAINT FK_DCFLDIDS_DCTYPS FOREIGN KEY  ( DOCTYPEID)
    REFERENCES CMDOCTYPES (DOCTYPEID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCFIELDIDS ADD CONSTRAINT FK_DCFLDIDS_FLDS FOREIGN KEY  ( FIELDID)
    REFERENCES CMDOCFIELDS (FIELDID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCFVTIMESTAMPS ADD CONSTRAINT FK_FVTS_FLDS FOREIGN KEY  ( FIELDID)
    REFERENCES CMDOCFIELDS (FIELDID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCFVTIMESTAMPS ADD CONSTRAINT FK_FVTS_DCMNTS FOREIGN KEY  ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCFVNUMERICS ADD CONSTRAINT FK_FVNUM_FLDS FOREIGN KEY  ( FIELDID)
    REFERENCES CMDOCFIELDS (FIELDID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCFVNUMERICS ADD CONSTRAINT FK_FVNUM_DCMNTS FOREIGN KEY  ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCFVLVCHARS ADD CONSTRAINT FK_FVLVC_FLDS FOREIGN KEY  ( FIELDID)
    REFERENCES CMDOCFIELDS (FIELDID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCFVLVCHARS ADD CONSTRAINT FK_FVLVC_DCMNTS FOREIGN KEY  ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCFVLVBINARIES ADD CONSTRAINT FK_FVLVB_FLDS FOREIGN KEY  ( FIELDID)
    REFERENCES CMDOCFIELDS (FIELDID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE CMDOCFVLVBINARIES ADD CONSTRAINT FK_FVLVB_DCMNTS FOREIGN KEY  ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID ) ON UPDATE RESTRICT ON DELETE RESTRICT;
