CREATE TABLE CMDOCLAYOUTS
(
DOCID VARCHAR(32) NOT NULL
, LAYOUTSTYLEID VARCHAR(32) NOT NULL
, LAYOUTDOCID VARCHAR(32)
, LAYOUTDOCVERSIONID INTEGER
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

) TYPE=InnoDB
;
CREATE TABLE CMDOCLINKS
(
DOCID VARCHAR(32) NOT NULL
, CHILDDOCID VARCHAR(32) NOT NULL
, CHILDVERSIONID INTEGER
, UUID VARCHAR(32) NOT NULL
, EXTNDATA LONGBLOB
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( DOCID, CHILDDOCID )
) TYPE=InnoDB
;
CREATE INDEX DLCHILDDOCID_IDX ON CMDOCLINKS (CHILDDOCID);
CREATE TABLE CMDOCCATEGORIES
(
DOCID VARCHAR(32) NOT NULL
, CATEGORYID VARCHAR(32) NOT NULL
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( DOCID, CATEGORYID )
) TYPE=InnoDB
;
CREATE INDEX DCCATEGORYID_IDX ON CMDOCCATEGORIES (CATEGORYID);
CREATE TABLE CMCATEGORIES
(
CATEGORYID VARCHAR(32) NOT NULL
, CATEGORYNAME VARCHAR(80) NOT NULL
, DESCRIPTION VARCHAR(255)
, CATEGORYTYPE INTEGER
, PARENTID VARCHAR(32)
, REPID VARCHAR(32)
, MODIFIED DATETIME
, MODIFIER VARCHAR(255)
, ORIGINATOR INTEGER

, PRIMARY KEY ( CATEGORYID )
) TYPE=InnoDB
;
CREATE INDEX CPARENTID_IDX ON CMCATEGORIES (PARENTID);
CREATE TABLE CMDOCCONTENTS
(
DOCID VARCHAR(32) NOT NULL
, UUID VARCHAR(32) NOT NULL
, MIMETYPE VARCHAR(80)
, CONTENTENCODING VARCHAR(80)
, CONTENTDATA LONGBLOB
, CONTENTSIZE INTEGER
, VERSIONID INTEGER
, REPID VARCHAR(32)
, MODIFIED DATETIME
, MODIFIER VARCHAR(255)
, ORIGINATOR INTEGER

, PRIMARY KEY ( DOCID )
) TYPE=InnoDB
;
CREATE TABLE CMDOCCONTENTSVERSIONS
(
VERSIONID INTEGER NOT NULL
, UUID VARCHAR(32) NOT NULL
, DOCID VARCHAR(32) NOT NULL
, MIMETYPE VARCHAR(80)
, CONTENTENCODING VARCHAR(80)
, CONTENTDATA LONGBLOB
, CONTENTSIZE INTEGER
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, VERCOMMENT VARCHAR(255)
, ORIGINATOR INTEGER

, PRIMARY KEY ( VERSIONID, DOCID )
) TYPE=InnoDB
;
CREATE INDEX DCVDOCID_IDX ON CMDOCCONTENTSVERSIONS (DOCID);
CREATE TABLE CMDOCFIELDVALUES
(
UUID VARCHAR(32) NOT NULL
, DOCID VARCHAR(32) NOT NULL
, FIELDID VARCHAR(32) NOT NULL
, FIELDVALUE VARCHAR(255)
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( UUID )
) TYPE=InnoDB
;
CREATE INDEX DFVDOCID_IDX ON CMDOCFIELDVALUES (DOCID);
CREATE INDEX DFVFIELDID_IDX ON CMDOCFIELDVALUES (FIELDID);
CREATE TABLE CMLAYOUTDOCUMENTS
(
LAYOUTSTYLEID VARCHAR(32) NOT NULL
, LAYOUTDOCID VARCHAR(32) NOT NULL
, USERAGENT VARCHAR(64) NOT NULL
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( LAYOUTSTYLEID, LAYOUTDOCID, USERAGENT )
) TYPE=InnoDB
;
CREATE TABLE CMDOCUMENTS
(
DOCID VARCHAR(32) NOT NULL
, DOCNAME VARCHAR(255) NOT NULL
, DOCTYPEID VARCHAR(32) NOT NULL
, FOLDERID VARCHAR(32) NOT NULL
, AUTHOR VARCHAR(255)
, CREATED DATETIME NOT NULL
, TITLE VARCHAR(255)
, SUBTITLE VARCHAR(255)
, DOCABSTRACT LONGTEXT
, PUBLISHDATE DATETIME
, EXPIRATIONDATE DATETIME
, LOCKEDBY VARCHAR(80)
, STATUS VARCHAR(80)
, PARENTDOCID VARCHAR(32)
, REPID VARCHAR(32)
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, PUBLISHSTATUS INTEGER
, ORIGINATOR INTEGER

, PRIMARY KEY ( DOCID )
) TYPE=InnoDB
;
CREATE INDEX DDOCTYPEID_IDX ON CMDOCUMENTS (DOCTYPEID);
CREATE INDEX DFOLDERID_IDX ON CMDOCUMENTS (FOLDERID);
CREATE TABLE CMFOLDERS
(
FOLDERID VARCHAR(32) NOT NULL
, FOLDERNAME VARCHAR(255) NOT NULL
, CREATOR VARCHAR(255)
, CREATED DATETIME NOT NULL
, DESCRIPTION VARCHAR(255)
, FOLDERTYPE INTEGER NOT NULL
, MODIFIED DATETIME
, MODIFIER VARCHAR(255)
, FOLDERSIZE NUMERIC(19, 0) NOT NULL
, PARENTID VARCHAR(32)
, REPID VARCHAR(32)
, ORIGINATOR INTEGER

, PRIMARY KEY ( FOLDERID )
) TYPE=InnoDB
;
CREATE INDEX CMFLDRPARNT_IDX ON CMFOLDERS (PARENTID);
CREATE TABLE CMDOCLAYOUTSTYLES
(
LAYOUTSTYLEID VARCHAR(32) NOT NULL
, DOCTYPEID VARCHAR(32) NOT NULL
, ISDEFAULT VARCHAR(1) NOT NULL
, STYLENAME VARCHAR(255)
, DESCRIPTION VARCHAR(255)
, MODIFIED DATETIME
, MODIFIER VARCHAR(255)
, ORIGINATOR INTEGER

, PRIMARY KEY ( LAYOUTSTYLEID )
) TYPE=InnoDB
;
CREATE INDEX DLSDOCTYPEID_IDX ON CMDOCLAYOUTSTYLES (DOCTYPEID);
CREATE TABLE CMDOCFIELDIDS
(
DOCTYPEID VARCHAR(32) NOT NULL
, FIELDID VARCHAR(32) NOT NULL
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( DOCTYPEID, FIELDID )
) TYPE=InnoDB
;
CREATE INDEX DFIFIELDID_IDX ON CMDOCFIELDIDS (FIELDID);
CREATE TABLE CMDOCFIELDS
(
FIELDID VARCHAR(32) NOT NULL
, FIELDNAME VARCHAR(80) NOT NULL
, DATATYPE VARCHAR(1) NOT NULL
, EXTNDATA LONGBLOB
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( FIELDID )
) TYPE=InnoDB
;
CREATE TABLE CMDOCTYPES
(
DOCTYPEID VARCHAR(32) NOT NULL
, DOCTYPENAME VARCHAR(80) NOT NULL
, DESCRIPTION VARCHAR(255)
, EXTNDATA LONGBLOB
, MODIFIED DATETIME
, MODIFIER VARCHAR(255)
, ORIGINATOR INTEGER

, PRIMARY KEY ( DOCTYPEID )
) TYPE=InnoDB
;
CREATE TABLE CMREPOSITORIES
(
REPID VARCHAR(32) NOT NULL
, REPNAME VARCHAR(80) NOT NULL
, DATASOURCE VARCHAR(80)
, REPTYPE INTEGER
, DESCRIPTION VARCHAR(255)
, UPDATETIME DATETIME NOT NULL
, UPDATEUSER VARCHAR(255)
, ORIGINATOR INTEGER

, PRIMARY KEY ( REPID )
) TYPE=InnoDB
;
CREATE TABLE CMDOCFVTIMESTAMPS
(
UUID VARCHAR(32) NOT NULL
, DOCID VARCHAR(32) NOT NULL
, FIELDID VARCHAR(32) NOT NULL
, FIELDVALUE DATETIME
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( UUID )
) TYPE=InnoDB
;
CREATE INDEX DFVTSDOCID_IDX ON CMDOCFVTIMESTAMPS (DOCID);
CREATE INDEX DFVTSFIELDID_IDX ON CMDOCFVTIMESTAMPS (FIELDID);
CREATE TABLE CMDOCFVNUMERICS
(
UUID VARCHAR(32) NOT NULL
, DOCID VARCHAR(32) NOT NULL
, FIELDID VARCHAR(32) NOT NULL
, FIELDVALUE NUMERIC(31, 10)
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( UUID )
) TYPE=InnoDB
;
CREATE INDEX DFVNUMDOCID_IDX ON CMDOCFVNUMERICS (DOCID);
CREATE INDEX DFVNUMFIELDID_IDX ON CMDOCFVNUMERICS (FIELDID);
CREATE TABLE CMDOCFVLVCHARS
(
UUID VARCHAR(32) NOT NULL
, DOCID VARCHAR(32) NOT NULL
, FIELDID VARCHAR(32) NOT NULL
, FIELDVALUE LONGTEXT
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( UUID )
) TYPE=InnoDB
;
CREATE INDEX DFVLVCDOCID_IDX ON CMDOCFVLVCHARS (DOCID);
CREATE INDEX DFVLVCFIELDID_IDX ON CMDOCFVLVCHARS (FIELDID);
CREATE TABLE CMDOCFVLVBINARIES
(
UUID VARCHAR(32) NOT NULL
, DOCID VARCHAR(32) NOT NULL
, FIELDID VARCHAR(32) NOT NULL
, FIELDVALUE LONGBLOB
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( UUID )
) TYPE=InnoDB
;
CREATE INDEX DFVLVBDOCID_IDX ON CMDOCFVLVBINARIES (DOCID);
CREATE INDEX DFVLVBFIELDID_IDX ON CMDOCFVLVBINARIES (FIELDID);
ALTER TABLE CMDOCLINKS ADD  FOREIGN KEY FK_DOCLINKS_DOCID ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID );
ALTER TABLE CMDOCLINKS ADD  FOREIGN KEY FK_DOCLNKS_CHDOCID ( CHILDDOCID)
    REFERENCES CMDOCUMENTS (DOCID );
ALTER TABLE CMDOCCATEGORIES ADD  FOREIGN KEY FK_DCCTGRIS_DCMNTS ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID );
ALTER TABLE CMDOCCATEGORIES ADD  FOREIGN KEY FK_DCCTGRIS_CTGRIS ( CATEGORYID)
    REFERENCES CMCATEGORIES (CATEGORYID );
ALTER TABLE CMCATEGORIES ADD  FOREIGN KEY FK_CTGRIS_PRNTID ( PARENTID)
    REFERENCES CMCATEGORIES (CATEGORYID );
ALTER TABLE CMDOCCONTENTSVERSIONS ADD  FOREIGN KEY FK_DCCNTVRS_DCMNTS ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID );
ALTER TABLE CMDOCFIELDVALUES ADD  FOREIGN KEY FK_FLDVALUES_FLDS ( FIELDID)
    REFERENCES CMDOCFIELDS (FIELDID );
ALTER TABLE CMDOCFIELDVALUES ADD  FOREIGN KEY FK_FLDVALS_DCMNTS ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID );
ALTER TABLE CMLAYOUTDOCUMENTS ADD  FOREIGN KEY FK_LYDCMNTS_DCLYST ( LAYOUTSTYLEID)
    REFERENCES CMDOCLAYOUTSTYLES (LAYOUTSTYLEID );
ALTER TABLE CMDOCUMENTS ADD  FOREIGN KEY FK_DCMNTS_DCTYPES ( DOCTYPEID)
    REFERENCES CMDOCTYPES (DOCTYPEID );
ALTER TABLE CMDOCUMENTS ADD  FOREIGN KEY FK_DCMNTS_FLDRS ( FOLDERID)
    REFERENCES CMFOLDERS (FOLDERID );
ALTER TABLE CMFOLDERS ADD  FOREIGN KEY FK_FLDRS_PRNTID ( PARENTID)
    REFERENCES CMFOLDERS (FOLDERID );
ALTER TABLE CMDOCLAYOUTSTYLES ADD  FOREIGN KEY FK_DCLYTST_DCTYPES ( DOCTYPEID)
    REFERENCES CMDOCTYPES (DOCTYPEID );
ALTER TABLE CMDOCFIELDIDS ADD  FOREIGN KEY FK_DCFLDIDS_DCTYPS ( DOCTYPEID)
    REFERENCES CMDOCTYPES (DOCTYPEID );
ALTER TABLE CMDOCFIELDIDS ADD  FOREIGN KEY FK_DCFLDIDS_FLDS ( FIELDID)
    REFERENCES CMDOCFIELDS (FIELDID );
ALTER TABLE CMDOCFVTIMESTAMPS ADD  FOREIGN KEY FK_FVTS_FLDS ( FIELDID)
    REFERENCES CMDOCFIELDS (FIELDID );
ALTER TABLE CMDOCFVTIMESTAMPS ADD  FOREIGN KEY FK_FVTS_DCMNTS ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID );
ALTER TABLE CMDOCFVNUMERICS ADD  FOREIGN KEY FK_FVNUM_FLDS ( FIELDID)
    REFERENCES CMDOCFIELDS (FIELDID );
ALTER TABLE CMDOCFVNUMERICS ADD  FOREIGN KEY FK_FVNUM_DCMNTS ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID );
ALTER TABLE CMDOCFVLVCHARS ADD  FOREIGN KEY FK_FVLVC_FLDS ( FIELDID)
    REFERENCES CMDOCFIELDS (FIELDID );
ALTER TABLE CMDOCFVLVCHARS ADD  FOREIGN KEY FK_FVLVC_DCMNTS ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID );
ALTER TABLE CMDOCFVLVBINARIES ADD  FOREIGN KEY FK_FVLVB_FLDS ( FIELDID)
    REFERENCES CMDOCFIELDS (FIELDID );
ALTER TABLE CMDOCFVLVBINARIES ADD  FOREIGN KEY FK_FVLVB_DCMNTS ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID );
