CREATE TABLE "CMDOCLAYOUTS"
(
  "DOCID" VARCHAR(32) NOT NULL
, "LAYOUTSTYLEID" VARCHAR(32) NOT NULL
, "LAYOUTDOCID" VARCHAR(32) NULL
, "LAYOUTDOCVERSIONID" INTEGER NULL
, "MODIFIED" TIMESTAMP NOT NULL
, "MODIFIER" VARCHAR(255) NOT NULL
, "ORIGINATOR" INTEGER NULL

)
;
CREATE TABLE "CMDOCLINKS"
(
  "DOCID" VARCHAR(32) NOT NULL
, "CHILDDOCID" VARCHAR(32) NOT NULL
, "CHILDVERSIONID" INTEGER NULL
, "UUID" VARCHAR(32) NOT NULL
, "EXTNDATA" LONG BINARY NULL
, "MODIFIED" TIMESTAMP NOT NULL
, "MODIFIER" VARCHAR(255) NOT NULL
, "ORIGINATOR" INTEGER NULL

, PRIMARY KEY ( "DOCID", "CHILDDOCID" )
)
;
CREATE INDEX "DLCHILDDOCID_IDX" ON "CMDOCLINKS" ("CHILDDOCID");
CREATE TABLE "CMDOCCATEGORIES"
(
  "DOCID" VARCHAR(32) NOT NULL
, "CATEGORYID" VARCHAR(32) NOT NULL
, "MODIFIED" TIMESTAMP NOT NULL
, "MODIFIER" VARCHAR(255) NOT NULL
, "ORIGINATOR" INTEGER NULL

, PRIMARY KEY ( "DOCID", "CATEGORYID" )
)
;
CREATE INDEX "DCCATEGORYID_IDX" ON "CMDOCCATEGORIES" ("CATEGORYID");
CREATE TABLE "CMCATEGORIES"
(
  "CATEGORYID" VARCHAR(32) NOT NULL
, "CATEGORYNAME" VARCHAR(80) NOT NULL
, "DESCRIPTION" VARCHAR(255) NULL
, "CATEGORYTYPE" INTEGER NULL
, "PARENTID" VARCHAR(32) NULL
, "REPID" VARCHAR(32) NULL
, "MODIFIED" TIMESTAMP NULL
, "MODIFIER" VARCHAR(255) NULL
, "ORIGINATOR" INTEGER NULL

, PRIMARY KEY ( "CATEGORYID" )
)
;
CREATE INDEX "CPARENTID_IDX" ON "CMCATEGORIES" ("PARENTID");
CREATE TABLE "CMDOCCONTENTS"
(
  "DOCID" VARCHAR(32) NOT NULL
, "UUID" VARCHAR(32) NOT NULL
, "MIMETYPE" VARCHAR(80) NULL
, "CONTENTENCODING" VARCHAR(80) NULL
, "CONTENTDATA" LONG BINARY NULL
, "CONTENTSIZE" INTEGER NULL
, "VERSIONID" INTEGER NULL
, "REPID" VARCHAR(32) NULL
, "MODIFIED" TIMESTAMP NULL
, "MODIFIER" VARCHAR(255) NULL
, "ORIGINATOR" INTEGER NULL

, PRIMARY KEY ( "DOCID" )
)
;
CREATE TABLE "CMDOCCONTENTSVERSIONS"
(
  "VERSIONID" INTEGER NOT NULL
, "UUID" VARCHAR(32) NOT NULL
, "DOCID" VARCHAR(32) NOT NULL
, "MIMETYPE" VARCHAR(80) NULL
, "CONTENTENCODING" VARCHAR(80) NULL
, "CONTENTDATA" LONG BINARY NULL
, "CONTENTSIZE" INTEGER NULL
, "MODIFIED" TIMESTAMP NOT NULL
, "MODIFIER" VARCHAR(255) NOT NULL
, "VERCOMMENT" VARCHAR(255) NULL
, "ORIGINATOR" INTEGER NULL

, PRIMARY KEY ( "VERSIONID", "DOCID" )
)
;
CREATE INDEX "DCVDOCID_IDX" ON "CMDOCCONTENTSVERSIONS" ("DOCID");
CREATE TABLE "CMDOCFIELDVALUES"
(
  "UUID" VARCHAR(32) NOT NULL
, "DOCID" VARCHAR(32) NOT NULL
, "FIELDID" VARCHAR(32) NOT NULL
, "FIELDVALUE" VARCHAR(255) NULL
, "MODIFIED" TIMESTAMP NOT NULL
, "MODIFIER" VARCHAR(255) NOT NULL
, "ORIGINATOR" INTEGER NULL

, PRIMARY KEY ( "UUID" )
)
;
CREATE INDEX "DFVDOCID_IDX" ON "CMDOCFIELDVALUES" ("DOCID");
CREATE TABLE "CMLAYOUTDOCUMENTS"
(
  "LAYOUTSTYLEID" VARCHAR(32) NOT NULL
, "LAYOUTDOCID" VARCHAR(32) NOT NULL
, "USERAGENT" VARCHAR(64) NULL
, "MODIFIED" TIMESTAMP NOT NULL
, "MODIFIER" VARCHAR(255) NOT NULL
, "ORIGINATOR" INTEGER NULL

, PRIMARY KEY ( "LAYOUTSTYLEID", "LAYOUTDOCID", "USERAGENT" )
)
;
CREATE TABLE "CMDOCUMENTS"
(
  "DOCID" VARCHAR(32) NOT NULL
, "DOCNAME" VARCHAR(255) NOT NULL
, "DOCTYPEID" VARCHAR(32) NOT NULL
, "FOLDERID" VARCHAR(32) NOT NULL
, "AUTHOR" VARCHAR(255) NULL
, "CREATED" TIMESTAMP NOT NULL
, "TITLE" VARCHAR(255) NULL
, "SUBTITLE" VARCHAR(255) NULL
, "DOCABSTRACT" LONG VARCHAR NULL
, "PUBLISHDATE" TIMESTAMP NULL
, "EXPIRATIONDATE" TIMESTAMP NULL
, "LOCKEDBY" VARCHAR(80) NULL
, "STATUS" VARCHAR(80) NULL
, "PARENTDOCID" VARCHAR(32) NULL
, "REPID" VARCHAR(32) NULL
, "MODIFIED" TIMESTAMP NOT NULL
, "MODIFIER" VARCHAR(255) NOT NULL
, "PUBLISHSTATUS" INTEGER NULL
, "ORIGINATOR" INTEGER NULL

, PRIMARY KEY ( "DOCID" )
)
;
CREATE INDEX "DDOCTYPEID_IDX" ON "CMDOCUMENTS" ("DOCTYPEID");
CREATE INDEX "DFOLDERID_IDX" ON "CMDOCUMENTS" ("FOLDERID");
CREATE TABLE "CMFOLDERS"
(
  "FOLDERID" VARCHAR(32) NOT NULL
, "FOLDERNAME" VARCHAR(255) NOT NULL
, "CREATOR" VARCHAR(255) NULL
, "CREATED" TIMESTAMP NOT NULL
, "DESCRIPTION" VARCHAR(255) NULL
, "FOLDERTYPE" INTEGER NOT NULL
, "MODIFIED" TIMESTAMP NULL
, "MODIFIER" VARCHAR(255) NULL
, "FOLDERSIZE" NUMERIC(19, 0) NOT NULL
, "PARENTID" VARCHAR(32) NULL
, "REPID" VARCHAR(32) NULL
, "ORIGINATOR" INTEGER NULL

, PRIMARY KEY ( "FOLDERID" )
)
;
CREATE INDEX "CMFLDRPARNT_IDX" ON "CMFOLDERS" ("PARENTID");
CREATE TABLE "CMDOCLAYOUTSTYLES"
(
  "LAYOUTSTYLEID" VARCHAR(32) NOT NULL
, "DOCTYPEID" VARCHAR(32) NOT NULL
, "ISDEFAULT" VARCHAR(1) NOT NULL
, "STYLENAME" VARCHAR(255) NULL
, "DESCRIPTION" VARCHAR(255) NULL
, "MODIFIED" TIMESTAMP NULL
, "MODIFIER" VARCHAR(255) NULL
, "ORIGINATOR" INTEGER NULL

, PRIMARY KEY ( "LAYOUTSTYLEID" )
)
;
CREATE INDEX "DLSDOCTYPEID_IDX" ON "CMDOCLAYOUTSTYLES" ("DOCTYPEID");
CREATE TABLE "CMDOCFIELDIDS"
(
  "DOCTYPEID" VARCHAR(32) NOT NULL
, "FIELDID" VARCHAR(32) NOT NULL
, "MODIFIED" TIMESTAMP NOT NULL
, "MODIFIER" VARCHAR(255) NOT NULL
, "ORIGINATOR" INTEGER NULL

, PRIMARY KEY ( "DOCTYPEID", "FIELDID" )
)
;
CREATE INDEX "DFIFIELDID_IDX" ON "CMDOCFIELDIDS" ("FIELDID");
CREATE TABLE "CMDOCFIELDS"
(
  "FIELDID" VARCHAR(32) NOT NULL
, "FIELDNAME" VARCHAR(80) NOT NULL
, "DATATYPE" VARCHAR(1) NOT NULL
, "EXTNDATA" LONG BINARY NULL
, "MODIFIED" TIMESTAMP NOT NULL
, "MODIFIER" VARCHAR(255) NOT NULL
, "ORIGINATOR" INTEGER NULL

, PRIMARY KEY ( "FIELDID" )
)
;
CREATE TABLE "CMDOCTYPES"
(
  "DOCTYPEID" VARCHAR(32) NOT NULL
, "DOCTYPENAME" VARCHAR(80) NOT NULL
, "DESCRIPTION" VARCHAR(255) NULL
, "EXTNDATA" LONG BINARY NULL
, "MODIFIED" TIMESTAMP NULL
, "MODIFIER" VARCHAR(255) NULL
, "ORIGINATOR" INTEGER NULL

, PRIMARY KEY ( "DOCTYPEID" )
)
;
CREATE TABLE "CMREPOSITORIES"
(
  "REPID" VARCHAR(32) NOT NULL
, "REPNAME" VARCHAR(80) NOT NULL UNIQUE
, "DATASOURCE" VARCHAR(80) NULL
, "REPTYPE" INTEGER NULL
, "DESCRIPTION" VARCHAR(255) NULL
, "UPDATETIME" TIMESTAMP NOT NULL
, "UPDATEUSER" VARCHAR(255) NULL
, "ORIGINATOR" INTEGER NULL

, PRIMARY KEY ( "REPID" )
)
;
CREATE TABLE "CMDOCFVTIMESTAMPS"
(
  "UUID" VARCHAR(32) NOT NULL
, "DOCID" VARCHAR(32) NOT NULL
, "FIELDID" VARCHAR(32) NOT NULL
, "FIELDVALUE" TIMESTAMP NULL
, "MODIFIED" TIMESTAMP NOT NULL
, "MODIFIER" VARCHAR(255) NOT NULL
, "ORIGINATOR" INTEGER NULL

, PRIMARY KEY ( "UUID" )
)
;
CREATE INDEX "DFVTSDOCID_IDX" ON "CMDOCFVTIMESTAMPS" ("DOCID");
CREATE INDEX "DFVTSFIELDID_IDX" ON "CMDOCFVTIMESTAMPS" ("FIELDID");
CREATE TABLE "CMDOCFVNUMERICS"
(
  "UUID" VARCHAR(32) NOT NULL
, "DOCID" VARCHAR(32) NOT NULL
, "FIELDID" VARCHAR(32) NOT NULL
, "FIELDVALUE" NUMERIC(31, 10) NULL
, "MODIFIED" TIMESTAMP NOT NULL
, "MODIFIER" VARCHAR(255) NOT NULL
, "ORIGINATOR" INTEGER NULL

, PRIMARY KEY ( "UUID" )
)
;
CREATE INDEX "DFVNUMDOCID_IDX" ON "CMDOCFVNUMERICS" ("DOCID");
CREATE INDEX "DFVNUMFIELDID_IDX" ON "CMDOCFVNUMERICS" ("FIELDID");
CREATE TABLE "CMDOCFVLVCHARS"
(
  "UUID" VARCHAR(32) NOT NULL
, "DOCID" VARCHAR(32) NOT NULL
, "FIELDID" VARCHAR(32) NOT NULL
, "FIELDVALUE" LONG VARCHAR NULL
, "MODIFIED" TIMESTAMP NOT NULL
, "MODIFIER" VARCHAR(255) NOT NULL
, "ORIGINATOR" INTEGER NULL

, PRIMARY KEY ( "UUID" )
)
;
CREATE INDEX "DFVLVCDOCID_IDX" ON "CMDOCFVLVCHARS" ("DOCID");
CREATE INDEX "DFVLVCFIELDID_IDX" ON "CMDOCFVLVCHARS" ("FIELDID");
CREATE TABLE "CMDOCFVLVBINARIES"
(
  "UUID" VARCHAR(32) NOT NULL
, "DOCID" VARCHAR(32) NOT NULL
, "FIELDID" VARCHAR(32) NOT NULL
, "FIELDVALUE" LONG BINARY NULL
, "MODIFIED" TIMESTAMP NOT NULL
, "MODIFIER" VARCHAR(255) NOT NULL
, "ORIGINATOR" INTEGER NULL

, PRIMARY KEY ( "UUID" )
)
;
CREATE INDEX "DFVLVBDOCID_IDX" ON "CMDOCFVLVBINARIES" ("DOCID");
CREATE INDEX "DFVLVBFIELDID_IDX" ON "CMDOCFVLVBINARIES" ("FIELDID");
ALTER TABLE "CMDOCLINKS" ADD FOREIGN KEY "FK_DOCLINKS_DOCID" ( "DOCID")
    REFERENCES "CMDOCUMENTS" ("DOCID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCLINKS" ADD FOREIGN KEY "FK_DOCLNKS_CHDOCID" ( "CHILDDOCID")
    REFERENCES "CMDOCUMENTS" ("DOCID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCCATEGORIES" ADD FOREIGN KEY "FK_DCCTGRIS_DCMNTS" ( "DOCID")
    REFERENCES "CMDOCUMENTS" ("DOCID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCCATEGORIES" ADD FOREIGN KEY "FK_DCCTGRIS_CTGRIS" ( "CATEGORYID")
    REFERENCES "CMCATEGORIES" ("CATEGORYID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMCATEGORIES" ADD FOREIGN KEY "FK_CTGRIS_PRNTID" ( "PARENTID")
    REFERENCES "CMCATEGORIES" ("CATEGORYID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCCONTENTS" ADD FOREIGN KEY "FK_CONTENTS_REPS" ( "REPID")
    REFERENCES "CMREPOSITORIES" ("REPID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCCONTENTSVERSIONS" ADD FOREIGN KEY "FK_DCCNTVRS_DCMNTS" ( "DOCID")
    REFERENCES "CMDOCUMENTS" ("DOCID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCFIELDVALUES" ADD FOREIGN KEY "FK_FLDVALUES_FLDS" ( "FIELDID")
    REFERENCES "CMDOCFIELDS" ("FIELDID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCFIELDVALUES" ADD FOREIGN KEY "FK_FLDVALS_DCMNTS" ( "DOCID")
    REFERENCES "CMDOCUMENTS" ("DOCID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMLAYOUTDOCUMENTS" ADD FOREIGN KEY "FK_LYDCMNTS_DCLYST" ( "LAYOUTSTYLEID")
    REFERENCES "CMDOCLAYOUTSTYLES" ("LAYOUTSTYLEID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCUMENTS" ADD FOREIGN KEY "FK_DCMNTS_DCTYPES" ( "DOCTYPEID")
    REFERENCES "CMDOCTYPES" ("DOCTYPEID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCUMENTS" ADD FOREIGN KEY "FK_DCMNTS_FLDRS" ( "FOLDERID")
    REFERENCES "CMFOLDERS" ("FOLDERID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCUMENTS" ADD FOREIGN KEY "FK_DCMNTS_REPS" ( "REPID")
    REFERENCES "CMREPOSITORIES" ("REPID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMFOLDERS" ADD FOREIGN KEY "FK_FLDRS_PRNTID" ( "PARENTID")
    REFERENCES "CMFOLDERS" ("FOLDERID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCLAYOUTSTYLES" ADD FOREIGN KEY "FK_DCLYTST_DCTYPES" ( "DOCTYPEID")
    REFERENCES "CMDOCTYPES" ("DOCTYPEID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCFIELDIDS" ADD FOREIGN KEY "FK_DCFLDIDS_DCTYPS" ( "DOCTYPEID")
    REFERENCES "CMDOCTYPES" ("DOCTYPEID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCFIELDIDS" ADD FOREIGN KEY "FK_DCFLDIDS_FLDS" ( "FIELDID")
    REFERENCES "CMDOCFIELDS" ("FIELDID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCFVTIMESTAMPS" ADD FOREIGN KEY "FK_FVTS_FLDS" ( "FIELDID")
    REFERENCES "CMDOCFIELDS" ("FIELDID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCFVTIMESTAMPS" ADD FOREIGN KEY "FK_FVTS_DCMNTS" ( "DOCID")
    REFERENCES "CMDOCUMENTS" ("DOCID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCFVNUMERICS" ADD FOREIGN KEY "FK_FVNUM_FLDS" ( "FIELDID")
    REFERENCES "CMDOCFIELDS" ("FIELDID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCFVNUMERICS" ADD FOREIGN KEY "FK_FVNUM_DCMNTS" ( "DOCID")
    REFERENCES "CMDOCUMENTS" ("DOCID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCFVLVCHARS" ADD FOREIGN KEY "FK_FVLVC_FLDS" ( "FIELDID")
    REFERENCES "CMDOCFIELDS" ("FIELDID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCFVLVCHARS" ADD FOREIGN KEY "FK_FVLVC_DCMNTS" ( "DOCID")
    REFERENCES "CMDOCUMENTS" ("DOCID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCFVLVBINARIES" ADD FOREIGN KEY "FK_FVLVB_FLDS" ( "FIELDID")
    REFERENCES "CMDOCFIELDS" ("FIELDID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "CMDOCFVLVBINARIES" ADD FOREIGN KEY "FK_FVLVB_DCMNTS" ( "DOCID")
    REFERENCES "CMDOCUMENTS" ("DOCID" ) ON UPDATE RESTRICT ON DELETE RESTRICT;
