CREATE TABLE PROFILEUSERFIELDVALUES
(
USERIID VARCHAR(32) NOT NULL
, FIELDIID VARCHAR(32) NOT NULL
, FIELDVALUE VARCHAR(255)
, UPDATETIME DATETIME NOT NULL
, UPDATEUSER VARCHAR(255)
, ORIGINATOR INTEGER

, PRIMARY KEY ( USERIID, FIELDIID )
) TYPE=InnoDB
;
CREATE TABLE PROFILEUSERCONTENTS
(
USERIID VARCHAR(32) NOT NULL
, FIELDIID VARCHAR(32) NOT NULL
, FIELDCONTENT LONGBLOB
, UPDATETIME DATETIME NOT NULL
, UPDATEUSER VARCHAR(255)
, ORIGINATOR INTEGER

, PRIMARY KEY ( USERIID, FIELDIID )
) TYPE=InnoDB
;
CREATE TABLE PROFILEUSERS
(
IID VARCHAR(32) NOT NULL
, USERID VARCHAR(255) NOT NULL
, FIRSTNAME VARCHAR(255)
, LASTNAME VARCHAR(255)
, EMAILADDRESS VARCHAR(255)
, REALMNAME VARCHAR(50) NOT NULL
, KEY1 VARCHAR(255)
, KEY2 VARCHAR(255)
, KEY3 VARCHAR(255)
, KEY4 VARCHAR(255)
, KEY5 VARCHAR(255)
, UPDATETIME DATETIME NOT NULL
, UPDATEUSER VARCHAR(255)
, ORIGINATOR INTEGER

, PRIMARY KEY ( IID )
) TYPE=InnoDB
;
CREATE UNIQUE INDEX FWUSERSIDX ON PROFILEUSERS (USERID, REALMNAME);
CREATE TABLE PROFILEUSERMETA
(
USERMETAKEY VARCHAR(64) NOT NULL
, USERMETA LONGTEXT
, UPDATETIME DATETIME NOT NULL
, UPDATEUSER VARCHAR(255)
, ORIGINATOR INTEGER

, PRIMARY KEY ( USERMETAKEY )
) TYPE=InnoDB
;
CREATE TABLE PROFILEUSERPREFERENCES
(
IID VARCHAR(32) NOT NULL
, USERIID VARCHAR(32) NOT NULL
, ELEMENTTYPE VARCHAR(64) NOT NULL
, ELEMENTID VARCHAR(128) NOT NULL
, PREFDATA LONGTEXT
, UPDATETIME DATETIME NOT NULL
, UPDATEUSER VARCHAR(255)
, ORIGINATOR INTEGER

, PRIMARY KEY ( IID )
) TYPE=InnoDB
;
CREATE UNIQUE INDEX FWUSERPREFIDX ON PROFILEUSERPREFERENCES (USERIID, ELEMENTTYPE, ELEMENTID);
CREATE TABLE PROFILEGROUPPREFERENCES
(
IID VARCHAR(32) NOT NULL
, ELEMENTTYPE VARCHAR(64) NOT NULL
, ELEMENTID VARCHAR(128) NOT NULL
, PREFDATA LONGTEXT
, UPDATETIME DATETIME NOT NULL
, UPDATEUSER VARCHAR(255)
, ORIGINATOR INTEGER

, PRIMARY KEY ( IID )
) TYPE=InnoDB
;
CREATE UNIQUE INDEX FWGROUPPREFIDX ON PROFILEGROUPPREFERENCES (ELEMENTTYPE, ELEMENTID);
ALTER TABLE PROFILEUSERFIELDVALUES ADD  FOREIGN KEY FK_USRFLDVLUS_USRS ( USERIID)
    REFERENCES PROFILEUSERS (IID );
ALTER TABLE PROFILEUSERCONTENTS ADD  FOREIGN KEY FK_USRCONTENT_USRS ( USERIID)
    REFERENCES PROFILEUSERS (IID );
