CREATE TABLE WFPROCESS
(
  RUN VARCHAR(32) NOT NULL
, PROCESS VARCHAR(32) NOT NULL
, NAME VARCHAR(128) NULL
, DEFINITION TEXT NOT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( RUN )
)
;
CREATE TABLE WFPROCESSSTATE
(
  RUN VARCHAR(32) NOT NULL
, PROCESS VARCHAR(32) NOT NULL
, ENGINE VARCHAR(32) NOT NULL
, STARTTIME DATETIME NOT NULL
, STATUS VARCHAR(32) NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( RUN )
)
;
CREATE TABLE WFACTIVITYSTATE
(
  ACTIVITY VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, NAME VARCHAR(32) NOT NULL
, STATUS VARCHAR(32) NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( ACTIVITY, RUN )
)
;
CREATE TABLE WFUSERSTATE
(
  ACTIVITY VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, ADDRESSEE VARCHAR(32) NULL
, ADDRESSEETYPE VARCHAR(32) NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( ACTIVITY, RUN )
)
;
CREATE TABLE WFSYNCMERGESTATE
(
  ACTIVITY VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, RUNNINGCOUNT INTEGER NULL
, FINALCOUNT INTEGER NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( ACTIVITY, RUN )
)
;
CREATE TABLE WFWORKINPROGRESS
(
  ACTIVITY VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, WORKITEM VARCHAR(32) NOT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( ACTIVITY, RUN )
)
;
CREATE TABLE WFWORKITEMSPLIT
(
  WORKITEM VARCHAR(32) NOT NULL
, ORIGINAL VARCHAR(32) NOT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( WORKITEM )
)
;
CREATE TABLE WFWORKITEM
(
  ID VARCHAR(32) NOT NULL
, NAME VARCHAR(32) NOT NULL
, WORKID VARCHAR(32) NOT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFWORK
(
  ID VARCHAR(32) NOT NULL
, UPDATETIME DATETIME NULL
, XML TEXT NULL
, LOCKEDBY VARCHAR(128) NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFDOCUMENT
(
  ID VARCHAR(32) NOT NULL
, CREATETIME DATETIME NOT NULL
, UPDATETIME DATETIME NULL
, XML TEXT NOT NULL
, LOCKEDBY VARCHAR(128) NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFAUDIT
(
  ID VARCHAR(32) NOT NULL
, CREATETIME DATETIME NOT NULL
, PROCESS VARCHAR(32) NULL
, RUN VARCHAR(32) NULL
, ACTIVITY VARCHAR(32) NULL
, XML TEXT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFQUEUE
(
  ID VARCHAR(32) NOT NULL
, QUEUETIME DATETIME NULL
, EXPIRATIONTIME DATETIME NULL
, MESSAGEID VARCHAR(32) NOT NULL
, WORKITEMID VARCHAR(32) NOT NULL
, ADDRESSEE VARCHAR(128) NOT NULL
, ADDRESSEETYPE VARCHAR(128) NOT NULL
, CLAIMED VARCHAR(8) NULL
, TRUSTED VARCHAR(1) NOT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFDISPATCH
(
  ID VARCHAR(32) NOT NULL
, MESSAGEOBJ IMAGE NOT NULL
, EXPIRATION DATETIME NULL
, CREATION DATETIME NOT NULL
, QUEUE VARCHAR(32) NOT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFFINISHEDPROCESS
(
  ID VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, ENGINE VARCHAR(32) NOT NULL
, STATE TEXT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( ID, RUN )
)
;
CREATE TABLE WFENGINESTATE
(
  ID VARCHAR(32) NOT NULL
, CREATETIME DATETIME NOT NULL
, UPDATETIME DATETIME NULL
, STATUS VARCHAR(32) NULL
, STATE TEXT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFSUSPENDEDACTIVITIES
(
  ID VARCHAR(32) NOT NULL
, PROCESS VARCHAR(32) NULL
, RUN VARCHAR(32) NULL
, ACTIVITY VARCHAR(32) NOT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFAUDITLOG
(
  ID VARCHAR(32) NOT NULL
, LVL VARCHAR(32) NOT NULL
, TEXT VARCHAR(255) NOT NULL
, CREATETIME DATETIME NOT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( ID )
)
;
