CREATE TABLE CMDOCLAYOUTS
(
  DOCID VARCHAR(32) NOT NULL
, LAYOUTSTYLEID VARCHAR(32) NOT NULL
, LAYOUTDOCID VARCHAR(32) NULL
, LAYOUTDOCVERSIONID INTEGER NULL
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER NULL

)
;
CREATE TABLE CMDOCLINKS
(
  DOCID VARCHAR(32) NOT NULL
, CHILDDOCID VARCHAR(32) NOT NULL
, CHILDVERSIONID INTEGER NULL
, UUID VARCHAR(32) NOT NULL
, EXTNDATA IMAGE NULL
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( DOCID, CHILDDOCID )
)
;
CREATE INDEX DLCHILDDOCID_IDX ON CMDOCLINKS (CHILDDOCID);
CREATE TABLE CMDOCCATEGORIES
(
  DOCID VARCHAR(32) NOT NULL
, CATEGORYID VARCHAR(32) NOT NULL
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( DOCID, CATEGORYID )
)
;
CREATE INDEX DCCATEGORYID_IDX ON CMDOCCATEGORIES (CATEGORYID);
CREATE TABLE CMCATEGORIES
(
  CATEGORYID VARCHAR(32) NOT NULL
, CATEGORYNAME VARCHAR(80) NOT NULL
, DESCRIPTION VARCHAR(255) NULL
, CATEGORYTYPE INTEGER NULL
, PARENTID VARCHAR(32) NULL
, REPID VARCHAR(32) NULL
, MODIFIED DATETIME NULL
, MODIFIER VARCHAR(255) NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( CATEGORYID )
)
;
CREATE INDEX CPARENTID_IDX ON CMCATEGORIES (PARENTID);
CREATE TABLE CMDOCCONTENTS
(
  DOCID VARCHAR(32) NOT NULL
, UUID VARCHAR(32) NOT NULL
, MIMETYPE VARCHAR(80) NULL
, CONTENTENCODING VARCHAR(80) NULL
, CONTENTDATA IMAGE NULL
, CONTENTSIZE INTEGER NULL
, VERSIONID INTEGER NULL
, REPID VARCHAR(32) NULL
, MODIFIED DATETIME NULL
, MODIFIER VARCHAR(255) NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( DOCID )
)
;
CREATE TABLE CMDOCCONTENTSVERSIONS
(
  VERSIONID INTEGER NOT NULL
, UUID VARCHAR(32) NOT NULL
, DOCID VARCHAR(32) NOT NULL
, MIMETYPE VARCHAR(80) NULL
, CONTENTENCODING VARCHAR(80) NULL
, CONTENTDATA IMAGE NULL
, CONTENTSIZE INTEGER NULL
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, VERCOMMENT VARCHAR(255) NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( VERSIONID, DOCID )
)
;
CREATE INDEX DCVDOCID_IDX ON CMDOCCONTENTSVERSIONS (DOCID);
CREATE TABLE CMDOCFIELDVALUES
(
  UUID VARCHAR(32) NOT NULL
, DOCID VARCHAR(32) NOT NULL
, FIELDID VARCHAR(32) NOT NULL
, FIELDVALUE VARCHAR(255) NULL
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( UUID )
)
;
CREATE INDEX DFVDOCID_IDX ON CMDOCFIELDVALUES (DOCID);
CREATE TABLE CMLAYOUTDOCUMENTS
(
  LAYOUTSTYLEID VARCHAR(32) NOT NULL
, LAYOUTDOCID VARCHAR(32) NOT NULL
, USERAGENT VARCHAR(64) NOT NULL
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( LAYOUTSTYLEID, LAYOUTDOCID, USERAGENT )
)
;
CREATE TABLE CMDOCUMENTS
(
  DOCID VARCHAR(32) NOT NULL
, DOCNAME VARCHAR(255) NOT NULL
, DOCTYPEID VARCHAR(32) NOT NULL
, FOLDERID VARCHAR(32) NOT NULL
, AUTHOR VARCHAR(255) NULL
, CREATED DATETIME NOT NULL
, TITLE VARCHAR(255) NULL
, SUBTITLE VARCHAR(255) NULL
, DOCABSTRACT TEXT NULL
, PUBLISHDATE DATETIME NULL
, EXPIRATIONDATE DATETIME NULL
, LOCKEDBY VARCHAR(80) NULL
, STATUS VARCHAR(80) NULL
, PARENTDOCID VARCHAR(32) NULL
, REPID VARCHAR(32) NULL
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, PUBLISHSTATUS INTEGER NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( DOCID )
)
;
CREATE INDEX DDOCTYPEID_IDX ON CMDOCUMENTS (DOCTYPEID);
CREATE INDEX DFOLDERID_IDX ON CMDOCUMENTS (FOLDERID);
CREATE TABLE CMFOLDERS
(
  FOLDERID VARCHAR(32) NOT NULL
, FOLDERNAME VARCHAR(255) NOT NULL
, CREATOR VARCHAR(255) NULL
, CREATED DATETIME NOT NULL
, DESCRIPTION VARCHAR(255) NULL
, FOLDERTYPE INTEGER NOT NULL
, MODIFIED DATETIME NULL
, MODIFIER VARCHAR(255) NULL
, FOLDERSIZE NUMERIC(19) NOT NULL
, PARENTID VARCHAR(32) NULL
, REPID VARCHAR(32) NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( FOLDERID )
)
;
CREATE INDEX CMFLDRPARNT_IDX ON CMFOLDERS (PARENTID);
CREATE TABLE CMDOCLAYOUTSTYLES
(
  LAYOUTSTYLEID VARCHAR(32) NOT NULL
, DOCTYPEID VARCHAR(32) NOT NULL
, ISDEFAULT VARCHAR(1) NOT NULL
, STYLENAME VARCHAR(255) NULL
, DESCRIPTION VARCHAR(255) NULL
, MODIFIED DATETIME NULL
, MODIFIER VARCHAR(255) NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( LAYOUTSTYLEID )
)
;
CREATE INDEX DLSDOCTYPEID_IDX ON CMDOCLAYOUTSTYLES (DOCTYPEID);
CREATE TABLE CMDOCFIELDIDS
(
  DOCTYPEID VARCHAR(32) NOT NULL
, FIELDID VARCHAR(32) NOT NULL
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( DOCTYPEID, FIELDID )
)
;
CREATE INDEX DFIFIELDID_IDX ON CMDOCFIELDIDS (FIELDID);
CREATE TABLE CMDOCFIELDS
(
  FIELDID VARCHAR(32) NOT NULL
, FIELDNAME VARCHAR(80) NOT NULL
, DATATYPE VARCHAR(1) NOT NULL
, EXTNDATA IMAGE NULL
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( FIELDID )
)
;
CREATE TABLE CMDOCTYPES
(
  DOCTYPEID VARCHAR(32) NOT NULL
, DOCTYPENAME VARCHAR(80) NOT NULL
, DESCRIPTION VARCHAR(255) NULL
, EXTNDATA IMAGE NULL
, MODIFIED DATETIME NULL
, MODIFIER VARCHAR(255) NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( DOCTYPEID )
)
;
CREATE TABLE CMREPOSITORIES
(
  REPID VARCHAR(32) NOT NULL
, REPNAME VARCHAR(80) NOT NULL UNIQUE
, DATASOURCE VARCHAR(80) NULL
, REPTYPE INTEGER NULL
, DESCRIPTION VARCHAR(255) NULL
, UPDATETIME DATETIME NOT NULL
, UPDATEUSER VARCHAR(255) NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( REPID )
)
;
CREATE TABLE CMDOCFVTIMESTAMPS
(
  UUID VARCHAR(32) NOT NULL
, DOCID VARCHAR(32) NOT NULL
, FIELDID VARCHAR(32) NOT NULL
, FIELDVALUE DATETIME NULL
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( UUID )
)
;
CREATE INDEX DFVTSDOCID_IDX ON CMDOCFVTIMESTAMPS (DOCID);
CREATE INDEX DFVTSFIELDID_IDX ON CMDOCFVTIMESTAMPS (FIELDID);
CREATE TABLE CMDOCFVNUMERICS
(
  UUID VARCHAR(32) NOT NULL
, DOCID VARCHAR(32) NOT NULL
, FIELDID VARCHAR(32) NOT NULL
, FIELDVALUE NUMERIC(31, 10) NULL
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( UUID )
)
;
CREATE INDEX DFVNUMDOCID_IDX ON CMDOCFVNUMERICS (DOCID);
CREATE INDEX DFVNUMFIELDID_IDX ON CMDOCFVNUMERICS (FIELDID);
CREATE TABLE CMDOCFVLVCHARS
(
  UUID VARCHAR(32) NOT NULL
, DOCID VARCHAR(32) NOT NULL
, FIELDID VARCHAR(32) NOT NULL
, FIELDVALUE TEXT NULL
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( UUID )
)
;
CREATE INDEX DFVLVCDOCID_IDX ON CMDOCFVLVCHARS (DOCID);
CREATE INDEX DFVLVCFIELDID_IDX ON CMDOCFVLVCHARS (FIELDID);
CREATE TABLE CMDOCFVLVBINARIES
(
  UUID VARCHAR(32) NOT NULL
, DOCID VARCHAR(32) NOT NULL
, FIELDID VARCHAR(32) NOT NULL
, FIELDVALUE IMAGE NULL
, MODIFIED DATETIME NOT NULL
, MODIFIER VARCHAR(255) NOT NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( UUID )
)
;
CREATE INDEX DFVLVBDOCID_IDX ON CMDOCFVLVBINARIES (DOCID);
CREATE INDEX DFVLVBFIELDID_IDX ON CMDOCFVLVBINARIES (FIELDID);
ALTER TABLE CMDOCLINKS ADD CONSTRAINT FK_DOCLINKS_DOCID FOREIGN KEY  ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID );
ALTER TABLE CMDOCLINKS ADD CONSTRAINT FK_DOCLNKS_CHDOCID FOREIGN KEY  ( CHILDDOCID)
    REFERENCES CMDOCUMENTS (DOCID );
ALTER TABLE CMDOCCATEGORIES ADD CONSTRAINT FK_DCCTGRIS_DCMNTS FOREIGN KEY  ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID );
ALTER TABLE CMDOCCATEGORIES ADD CONSTRAINT FK_DCCTGRIS_CTGRIS FOREIGN KEY  ( CATEGORYID)
    REFERENCES CMCATEGORIES (CATEGORYID );
ALTER TABLE CMCATEGORIES ADD CONSTRAINT FK_CTGRIS_PRNTID FOREIGN KEY  ( PARENTID)
    REFERENCES CMCATEGORIES (CATEGORYID );
ALTER TABLE CMDOCCONTENTS ADD CONSTRAINT FK_CONTENTS_REPS FOREIGN KEY  ( REPID)
    REFERENCES CMREPOSITORIES (REPID );
ALTER TABLE CMDOCCONTENTSVERSIONS ADD CONSTRAINT FK_DCCNTVRS_DCMNTS FOREIGN KEY  ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID );
ALTER TABLE CMDOCFIELDVALUES ADD CONSTRAINT FK_FLDVALUES_FLDS FOREIGN KEY  ( FIELDID)
    REFERENCES CMDOCFIELDS (FIELDID );
ALTER TABLE CMDOCFIELDVALUES ADD CONSTRAINT FK_FLDVALS_DCMNTS FOREIGN KEY  ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID );
ALTER TABLE CMLAYOUTDOCUMENTS ADD CONSTRAINT FK_LYDCMNTS_DCLYST FOREIGN KEY  ( LAYOUTSTYLEID)
    REFERENCES CMDOCLAYOUTSTYLES (LAYOUTSTYLEID );
ALTER TABLE CMDOCUMENTS ADD CONSTRAINT FK_DCMNTS_DCTYPES FOREIGN KEY  ( DOCTYPEID)
    REFERENCES CMDOCTYPES (DOCTYPEID );
ALTER TABLE CMDOCUMENTS ADD CONSTRAINT FK_DCMNTS_FLDRS FOREIGN KEY  ( FOLDERID)
    REFERENCES CMFOLDERS (FOLDERID );
ALTER TABLE CMDOCUMENTS ADD CONSTRAINT FK_DCMNTS_REPS FOREIGN KEY  ( REPID)
    REFERENCES CMREPOSITORIES (REPID );
ALTER TABLE CMFOLDERS ADD CONSTRAINT FK_FLDRS_PRNTID FOREIGN KEY  ( PARENTID)
    REFERENCES CMFOLDERS (FOLDERID );
ALTER TABLE CMDOCLAYOUTSTYLES ADD CONSTRAINT FK_DCLYTST_DCTYPES FOREIGN KEY  ( DOCTYPEID)
    REFERENCES CMDOCTYPES (DOCTYPEID );
ALTER TABLE CMDOCFIELDIDS ADD CONSTRAINT FK_DCFLDIDS_DCTYPS FOREIGN KEY  ( DOCTYPEID)
    REFERENCES CMDOCTYPES (DOCTYPEID );
ALTER TABLE CMDOCFIELDIDS ADD CONSTRAINT FK_DCFLDIDS_FLDS FOREIGN KEY  ( FIELDID)
    REFERENCES CMDOCFIELDS (FIELDID );
ALTER TABLE CMDOCFVTIMESTAMPS ADD CONSTRAINT FK_FVTS_FLDS FOREIGN KEY  ( FIELDID)
    REFERENCES CMDOCFIELDS (FIELDID );
ALTER TABLE CMDOCFVTIMESTAMPS ADD CONSTRAINT FK_FVTS_DCMNTS FOREIGN KEY  ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID );
ALTER TABLE CMDOCFVNUMERICS ADD CONSTRAINT FK_FVNUM_FLDS FOREIGN KEY  ( FIELDID)
    REFERENCES CMDOCFIELDS (FIELDID );
ALTER TABLE CMDOCFVNUMERICS ADD CONSTRAINT FK_FVNUM_DCMNTS FOREIGN KEY  ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID );
ALTER TABLE CMDOCFVLVCHARS ADD CONSTRAINT FK_FVLVC_FLDS FOREIGN KEY  ( FIELDID)
    REFERENCES CMDOCFIELDS (FIELDID );
ALTER TABLE CMDOCFVLVCHARS ADD CONSTRAINT FK_FVLVC_DCMNTS FOREIGN KEY  ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID );
ALTER TABLE CMDOCFVLVBINARIES ADD CONSTRAINT FK_FVLVB_FLDS FOREIGN KEY  ( FIELDID)
    REFERENCES CMDOCFIELDS (FIELDID );
ALTER TABLE CMDOCFVLVBINARIES ADD CONSTRAINT FK_FVLVB_DCMNTS FOREIGN KEY  ( DOCID)
    REFERENCES CMDOCUMENTS (DOCID );
