CREATE TABLE PROFILEUSERFIELDVALUES
(
  USERIID VARCHAR(32) NOT NULL
, FIELDIID VARCHAR(32) NOT NULL
, FIELDVALUE VARCHAR(255) NULL
, UPDATETIME DATETIME NOT NULL
, UPDATEUSER VARCHAR(255) NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( USERIID, FIELDIID )
)
;
CREATE TABLE PROFILEUSERCONTENTS
(
  USERIID VARCHAR(32) NOT NULL
, FIELDIID VARCHAR(32) NOT NULL
, FIELDCONTENT IMAGE NULL
, UPDATETIME DATETIME NOT NULL
, UPDATEUSER VARCHAR(255) NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( USERIID, FIELDIID )
)
;
CREATE TABLE PROFILEUSERS
(
  IID VARCHAR(32) NOT NULL
, USERID VARCHAR(255) NOT NULL
, FIRSTNAME VARCHAR(255) NULL
, LASTNAME VARCHAR(255) NULL
, EMAILADDRESS VARCHAR(255) NULL
, REALMNAME VARCHAR(50) NOT NULL
, KEY1 VARCHAR(255) NULL
, KEY2 VARCHAR(255) NULL
, KEY3 VARCHAR(255) NULL
, KEY4 VARCHAR(255) NULL
, KEY5 VARCHAR(255) NULL
, UPDATETIME DATETIME NOT NULL
, UPDATEUSER VARCHAR(255) NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( IID )
)
;
CREATE UNIQUE INDEX FWUSERSIDX ON PROFILEUSERS (USERID, REALMNAME);
CREATE TABLE PROFILEUSERMETA
(
  USERMETAKEY VARCHAR(64) NOT NULL
, USERMETA TEXT NULL
, UPDATETIME DATETIME NOT NULL
, UPDATEUSER VARCHAR(255) NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( USERMETAKEY )
)
;
CREATE TABLE PROFILEUSERPREFERENCES
(
  IID VARCHAR(32) NOT NULL
, USERIID VARCHAR(32) NOT NULL
, ELEMENTTYPE VARCHAR(64) NOT NULL
, ELEMENTID VARCHAR(128) NOT NULL
, PREFDATA TEXT NULL
, UPDATETIME DATETIME NOT NULL
, UPDATEUSER VARCHAR(255) NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( IID )
)
;
CREATE UNIQUE INDEX FWUSERPREFIDX ON PROFILEUSERPREFERENCES (USERIID, ELEMENTTYPE, ELEMENTID);
CREATE TABLE PROFILEGROUPPREFERENCES
(
  IID VARCHAR(32) NOT NULL
, ELEMENTTYPE VARCHAR(64) NOT NULL
, ELEMENTID VARCHAR(128) NOT NULL
, PREFDATA TEXT NULL
, UPDATETIME DATETIME NOT NULL
, UPDATEUSER VARCHAR(255) NULL
, ORIGINATOR INTEGER NULL

, PRIMARY KEY ( IID )
)
;
CREATE UNIQUE INDEX FWGROUPPREFIDX ON PROFILEGROUPPREFERENCES (ELEMENTTYPE, ELEMENTID);
ALTER TABLE PROFILEUSERFIELDVALUES ADD CONSTRAINT FK_USRFLDVLUS_USRS FOREIGN KEY  ( USERIID)
    REFERENCES PROFILEUSERS (IID );
ALTER TABLE PROFILEUSERCONTENTS ADD CONSTRAINT FK_USRCONTENT_USRS FOREIGN KEY  ( USERIID)
    REFERENCES PROFILEUSERS (IID );
