CREATE TABLE WFPROCESS
(
  RUN VARCHAR(32) NOT NULL
, PROCESS VARCHAR(32) NOT NULL
, NAME VARCHAR(128)
, DEFINITION CLOB(2147483646) NOT LOGGED NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( RUN )
)
;
CREATE TABLE WFPROCESSSTATE
(
  RUN VARCHAR(32) NOT NULL
, PROCESS VARCHAR(32) NOT NULL
, ENGINE VARCHAR(32) NOT NULL
, STARTTIME TIMESTAMP NOT NULL
, STATUS VARCHAR(32)
, ORIGINATOR INTEGER

, PRIMARY KEY ( RUN )
)
;
CREATE TABLE WFACTIVITYSTATE
(
  ACTIVITY VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, NAME VARCHAR(32) NOT NULL
, STATUS VARCHAR(32)
, ORIGINATOR INTEGER

, PRIMARY KEY ( ACTIVITY, RUN )
)
;
CREATE TABLE WFUSERSTATE
(
  ACTIVITY VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, ADDRESSEE VARCHAR(32)
, ADDRESSEETYPE VARCHAR(32)
, ORIGINATOR INTEGER

, PRIMARY KEY ( ACTIVITY, RUN )
)
;
CREATE TABLE WFSYNCMERGESTATE
(
  ACTIVITY VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, RUNNINGCOUNT INTEGER
, FINALCOUNT INTEGER
, ORIGINATOR INTEGER

, PRIMARY KEY ( ACTIVITY, RUN )
)
;
CREATE TABLE WFWORKINPROGRESS
(
  ACTIVITY VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, WORKITEM VARCHAR(32) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( ACTIVITY, RUN )
)
;
CREATE TABLE WFWORKITEMSPLIT
(
  WORKITEM VARCHAR(32) NOT NULL
, ORIGINAL VARCHAR(32) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( WORKITEM )
)
;
CREATE TABLE WFWORKITEM
(
  ID VARCHAR(32) NOT NULL
, NAME VARCHAR(32) NOT NULL
, WORKID VARCHAR(32) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFWORK
(
  ID VARCHAR(32) NOT NULL
, UPDATETIME TIMESTAMP
, XML CLOB(2147483646) NOT LOGGED
, LOCKEDBY VARCHAR(128)
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFDOCUMENT
(
  ID VARCHAR(32) NOT NULL
, CREATETIME TIMESTAMP NOT NULL
, UPDATETIME TIMESTAMP
, XML CLOB(2147483646) NOT LOGGED NOT NULL
, LOCKEDBY VARCHAR(128)
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFAUDIT
(
  ID VARCHAR(32) NOT NULL
, CREATETIME TIMESTAMP NOT NULL
, PROCESS VARCHAR(32)
, RUN VARCHAR(32)
, ACTIVITY VARCHAR(32)
, XML CLOB(2147483646) NOT LOGGED
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFQUEUE
(
  ID VARCHAR(32) NOT NULL
, QUEUETIME TIMESTAMP
, EXPIRATIONTIME TIMESTAMP
, MESSAGEID VARCHAR(32) NOT NULL
, WORKITEMID VARCHAR(32) NOT NULL
, ADDRESSEE VARCHAR(128) NOT NULL
, ADDRESSEETYPE VARCHAR(128) NOT NULL
, CLAIMED VARCHAR(8)
, TRUSTED VARCHAR(1) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFDISPATCH
(
  ID VARCHAR(32) NOT NULL
, MESSAGEOBJ BLOB(2147483646) NOT LOGGED NOT NULL
, EXPIRATION TIMESTAMP
, CREATION TIMESTAMP NOT NULL
, QUEUE VARCHAR(32) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFFINISHEDPROCESS
(
  ID VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, ENGINE VARCHAR(32) NOT NULL
, STATE CLOB(2147483646) NOT LOGGED
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID, RUN )
)
;
CREATE TABLE WFENGINESTATE
(
  ID VARCHAR(32) NOT NULL
, CREATETIME TIMESTAMP NOT NULL
, UPDATETIME TIMESTAMP
, STATUS VARCHAR(32)
, STATE CLOB(2147483646) NOT LOGGED
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFSUSPENDEDACTIVITIES
(
  ID VARCHAR(32) NOT NULL
, PROCESS VARCHAR(32)
, RUN VARCHAR(32)
, ACTIVITY VARCHAR(32) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFAUDITLOG
(
  ID VARCHAR(32) NOT NULL
, LVL VARCHAR(32) NOT NULL
, TEXT VARCHAR(255) NOT NULL
, CREATETIME TIMESTAMP NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID )
)
;
