CREATE TABLE WFPROCESS
(
RUN VARCHAR(32) NOT NULL
, PROCESS VARCHAR(32) NOT NULL
, NAME VARCHAR(128)
, DEFINITION LONGTEXT NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( RUN )
) TYPE=InnoDB
;
CREATE TABLE WFPROCESSSTATE
(
RUN VARCHAR(32) NOT NULL
, PROCESS VARCHAR(32) NOT NULL
, ENGINE VARCHAR(32) NOT NULL
, STARTTIME DATETIME NOT NULL
, STATUS VARCHAR(32)
, ORIGINATOR INTEGER

, PRIMARY KEY ( RUN )
) TYPE=InnoDB
;
CREATE TABLE WFACTIVITYSTATE
(
ACTIVITY VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, NAME VARCHAR(32) NOT NULL
, STATUS VARCHAR(32)
, ORIGINATOR INTEGER

, PRIMARY KEY ( ACTIVITY, RUN )
) TYPE=InnoDB
;
CREATE TABLE WFUSERSTATE
(
ACTIVITY VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, ADDRESSEE VARCHAR(32)
, ADDRESSEETYPE VARCHAR(32)
, ORIGINATOR INTEGER

, PRIMARY KEY ( ACTIVITY, RUN )
) TYPE=InnoDB
;
CREATE TABLE WFSYNCMERGESTATE
(
ACTIVITY VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, RUNNINGCOUNT INTEGER
, FINALCOUNT INTEGER
, ORIGINATOR INTEGER

, PRIMARY KEY ( ACTIVITY, RUN )
) TYPE=InnoDB
;
CREATE TABLE WFWORKINPROGRESS
(
ACTIVITY VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, WORKITEM VARCHAR(32) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( ACTIVITY, RUN )
) TYPE=InnoDB
;
CREATE TABLE WFWORKITEMSPLIT
(
WORKITEM VARCHAR(32) NOT NULL
, ORIGINAL VARCHAR(32) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( WORKITEM )
) TYPE=InnoDB
;
CREATE TABLE WFWORKITEM
(
ID VARCHAR(32) NOT NULL
, NAME VARCHAR(32) NOT NULL
, WORKID VARCHAR(32) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID )
) TYPE=InnoDB
;
CREATE TABLE WFWORK
(
ID VARCHAR(32) NOT NULL
, UPDATETIME DATETIME
, XML LONGTEXT
, LOCKEDBY VARCHAR(128)
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID )
) TYPE=InnoDB
;
CREATE TABLE WFDOCUMENT
(
ID VARCHAR(32) NOT NULL
, CREATETIME DATETIME NOT NULL
, UPDATETIME DATETIME
, XML LONGTEXT NOT NULL
, LOCKEDBY VARCHAR(128)
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID )
) TYPE=InnoDB
;
CREATE TABLE WFAUDIT
(
ID VARCHAR(32) NOT NULL
, CREATETIME DATETIME NOT NULL
, PROCESS VARCHAR(32)
, RUN VARCHAR(32)
, ACTIVITY VARCHAR(32)
, XML LONGTEXT
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID )
) TYPE=InnoDB
;
CREATE TABLE WFQUEUE
(
ID VARCHAR(32) NOT NULL
, QUEUETIME DATETIME
, EXPIRATIONTIME DATETIME
, MESSAGEID VARCHAR(32) NOT NULL
, WORKITEMID VARCHAR(32) NOT NULL
, ADDRESSEE VARCHAR(128) NOT NULL
, ADDRESSEETYPE VARCHAR(128) NOT NULL
, CLAIMED VARCHAR(8)
, TRUSTED VARCHAR(1) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID )
) TYPE=InnoDB
;
CREATE TABLE WFDISPATCH
(
ID VARCHAR(32) NOT NULL
, MESSAGEOBJ LONGBLOB NOT NULL
, EXPIRATION DATETIME
, CREATION DATETIME NOT NULL
, QUEUE VARCHAR(32) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID )
) TYPE=InnoDB
;
CREATE TABLE WFFINISHEDPROCESS
(
ID VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, ENGINE VARCHAR(32) NOT NULL
, STATE LONGTEXT
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID, RUN )
) TYPE=InnoDB
;
CREATE TABLE WFENGINESTATE
(
ID VARCHAR(32) NOT NULL
, CREATETIME DATETIME NOT NULL
, UPDATETIME DATETIME
, STATUS VARCHAR(32)
, STATE LONGTEXT
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID )
) TYPE=InnoDB
;
CREATE TABLE WFSUSPENDEDACTIVITIES
(
ID VARCHAR(32) NOT NULL
, PROCESS VARCHAR(32)
, RUN VARCHAR(32)
, ACTIVITY VARCHAR(32) NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID )
) TYPE=InnoDB
;
CREATE TABLE WFAUDITLOG
(
ID VARCHAR(32) NOT NULL
, LVL VARCHAR(32) NOT NULL
, TEXT VARCHAR(255) NOT NULL
, CREATETIME DATETIME NOT NULL
, ORIGINATOR INTEGER

, PRIMARY KEY ( ID )
) TYPE=InnoDB
;
