CREATE TABLE WFPROCESS
(
  RUN VARCHAR(32) NOT NULL
, PROCESS VARCHAR(32) NOT NULL
, NAME VARCHAR(128)
, DEFINITION CLOB NOT NULL
, ORIGINATOR NUMBER(9)
, PRIMARY KEY ( RUN )
)
;
CREATE TABLE WFPROCESSSTATE
(
  RUN VARCHAR(32) NOT NULL
, PROCESS VARCHAR(32) NOT NULL
, ENGINE VARCHAR(32) NOT NULL
, STARTTIME DATE NOT NULL
, STATUS VARCHAR(32)
, ORIGINATOR NUMBER(9)
, PRIMARY KEY ( RUN )
)
;
CREATE TABLE WFACTIVITYSTATE
(
  ACTIVITY VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, NAME VARCHAR(32) NOT NULL
, STATUS VARCHAR(32)
, ORIGINATOR NUMBER(9)
, PRIMARY KEY ( ACTIVITY, RUN )
)
;
CREATE TABLE WFUSERSTATE
(
  ACTIVITY VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, ADDRESSEE VARCHAR(32)
, ADDRESSEETYPE VARCHAR(32)
, ORIGINATOR NUMBER(9)
, PRIMARY KEY ( ACTIVITY, RUN )
)
;
CREATE TABLE WFSYNCMERGESTATE
(
  ACTIVITY VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, RUNNINGCOUNT NUMBER(9)
, FINALCOUNT NUMBER(9)
, ORIGINATOR NUMBER(9)
, PRIMARY KEY ( ACTIVITY, RUN )
)
;
CREATE TABLE WFWORKINPROGRESS
(
  ACTIVITY VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, WORKITEM VARCHAR(32) NOT NULL
, ORIGINATOR NUMBER(9)
, PRIMARY KEY ( ACTIVITY, RUN )
)
;
CREATE TABLE WFWORKITEMSPLIT
(
  WORKITEM VARCHAR(32) NOT NULL
, ORIGINAL VARCHAR(32) NOT NULL
, ORIGINATOR NUMBER(9)
, PRIMARY KEY ( WORKITEM )
)
;
CREATE TABLE WFWORKITEM
(
  ID VARCHAR(32) NOT NULL
, NAME VARCHAR(32) NOT NULL
, WORKID VARCHAR(32) NOT NULL
, ORIGINATOR NUMBER(9)
, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFWORK
(
  ID VARCHAR(32) NOT NULL
, UPDATETIME DATE
, XML CLOB
, LOCKEDBY VARCHAR(128)
, ORIGINATOR NUMBER(9)
, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFDOCUMENT
(
  ID VARCHAR(32) NOT NULL
, CREATETIME DATE NOT NULL
, UPDATETIME DATE
, XML CLOB NOT NULL
, LOCKEDBY VARCHAR(128)
, ORIGINATOR NUMBER(9)
, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFAUDIT
(
  ID VARCHAR(32) NOT NULL
, CREATETIME DATE NOT NULL
, PROCESS VARCHAR(32)
, RUN VARCHAR(32)
, ACTIVITY VARCHAR(32)
, XML CLOB
, ORIGINATOR NUMBER(9)
, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFQUEUE
(
  ID VARCHAR(32) NOT NULL
, QUEUETIME DATE
, EXPIRATIONTIME DATE
, MESSAGEID VARCHAR(32) NOT NULL
, WORKITEMID VARCHAR(32) NOT NULL
, ADDRESSEE VARCHAR(128) NOT NULL
, ADDRESSEETYPE VARCHAR(128) NOT NULL
, CLAIMED VARCHAR(8)
, TRUSTED VARCHAR(1) NOT NULL
, ORIGINATOR NUMBER(9)
, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFDISPATCH
(
  ID VARCHAR(32) NOT NULL
, MESSAGEOBJ BLOB NOT NULL
, EXPIRATION DATE
, CREATION DATE NOT NULL
, QUEUE VARCHAR(32) NOT NULL
, ORIGINATOR NUMBER(9)
, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFFINISHEDPROCESS
(
  ID VARCHAR(32) NOT NULL
, RUN VARCHAR(32) NOT NULL
, ENGINE VARCHAR(32) NOT NULL
, STATE CLOB
, ORIGINATOR NUMBER(9)
, PRIMARY KEY ( ID, RUN )
)
;
CREATE TABLE WFENGINESTATE
(
  ID VARCHAR(32) NOT NULL
, CREATETIME DATE NOT NULL
, UPDATETIME DATE
, STATUS VARCHAR(32)
, STATE CLOB
, ORIGINATOR NUMBER(9)
, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFSUSPENDEDACTIVITIES
(
  ID VARCHAR(32) NOT NULL
, PROCESS VARCHAR(32)
, RUN VARCHAR(32)
, ACTIVITY VARCHAR(32) NOT NULL
, ORIGINATOR NUMBER(9)
, PRIMARY KEY ( ID )
)
;
CREATE TABLE WFAUDITLOG
(
  ID VARCHAR(32) NOT NULL
, LVL VARCHAR(32) NOT NULL
, TEXT VARCHAR(255) NOT NULL
, CREATETIME DATE NOT NULL
, ORIGINATOR NUMBER(9)
, PRIMARY KEY ( ID )
)
;
