/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk;

import com.netiq.sentinel.sdk.SDKConstants;
import com.netiq.sentinel.sdk.SentinelActionProjectNature;
import com.netiq.sentinel.sdk.SentinelCollectorProjectNature;
import com.netiq.sentinel.sdk.SentinelRDDProjectNature;
import com.netiq.sentinel.sdk.SentinelReportProjectNature;
import com.netiq.sentinel.sdk.SentinelSDKNature;
import com.netiq.sentinel.sdk.SentinelSolutionProjectNature;
import com.netiq.sentinel.sdk.model.PluginType;
import com.netiq.sentinel.sdk.util.Arg;
import com.netiq.sentinel.sdk.wizards.CommonPropertiesWizard;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Shell;

public class SDKUtil {
    private static IProject m_sdkProject = null;
    public static String DEV_PROP_COMMENT = "Personal preferences file.\nYou can define personal preferences here, including:\n'author': defines the name of the author that is injected into each plug-in's package.xml built from this SDK\n'buildroot': provides an alternative location where builds are placed\n'sdklocalroot': provides an alternative SDK local extension\n'skipupdate': if connected to SVN, this prevents the automatic SVN update of the SDK and content so that local edits won't conflict";

    public static PluginType getPluginType(IProject project) {
        PluginType pluginType = null;
        try {
            IProjectNature actionNature = project.getNature("com.netiq.sentinel.sdk.SentinelActionProjectNature");
            if (actionNature != null && actionNature instanceof SentinelActionProjectNature) {
                pluginType = PluginType.ACTION;
            } else {
                IProjectNature reportNature = project.getNature("com.netiq.sentinel.sdk.SentinelReportProjectNature");
                if (reportNature != null && reportNature instanceof SentinelReportProjectNature) {
                    pluginType = PluginType.REPORT;
                } else {
                    IProjectNature collectorNature = project.getNature("com.netiq.sentinel.sdk.SentinelCollectorProjectNature");
                    if (collectorNature != null && collectorNature instanceof SentinelCollectorProjectNature) {
                        pluginType = PluginType.COLLECTOR;
                    } else {
                        IProjectNature solutionNature = project.getNature("com.netiq.sentinel.sdk.SentinelSolutionProjectNature");
                        if (solutionNature != null && solutionNature instanceof SentinelSolutionProjectNature) {
                            pluginType = PluginType.SOLUTION;
                        } else {
                            IProjectNature rddNature = project.getNature("com.netiq.sentinel.sdk.SentinelRDDProjectNature");
                            if (rddNature != null && rddNature instanceof SentinelRDDProjectNature) {
                                pluginType = PluginType.RDD;
                            }
                        }
                    }
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return pluginType;
    }

    public static void setSDKProject(IProject project) {
        m_sdkProject = project;
    }

    public static IProject getSDKProject() {
        if (m_sdkProject != null) {
            return m_sdkProject;
        }
        ResourcesPlugin.getWorkspace().getNatureDescriptors();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        for (int i = 0; i < projects.length; ++i) {
            try {
                IProjectNature sdkNature;
                if (!projects[i].isOpen() || !((sdkNature = projects[i].getNature("com.netiq.sentinel.sdk.SentinelSDKNature")) instanceof SentinelSDKNature)) continue;
                SDKUtil.setSDKProject(projects[i]);
                continue;
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
        return m_sdkProject;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").startsWith("Linux");
    }

    public static boolean isMac() {
        return System.getProperty("os.name").startsWith("Mac OS X");
    }

    public static List<String> calcWrapLines(GC gc, List<String> lines, String text, int width) {
        if (!Arg.checkWithinBounds(width, 1, -1)) {
            return null;
        }
        if (lines == null) {
            lines = new ArrayList<String>();
        } else {
            lines.clear();
        }
        if (text != null) {
            if (Locale.getDefault().getLanguage().equals("ja") || Locale.getDefault().getLanguage().equals("zh")) {
                char[] chars = text.toCharArray();
                StringBuilder builder = new StringBuilder();
                StringBuilder lastGoodText = new StringBuilder();
                String fullText = "";
                for (char c : chars) {
                    builder.append(c);
                    if (gc.stringExtent((String)builder.toString()).x > width) {
                        if (fullText.length() > 0) {
                            fullText = fullText + " ";
                        }
                        fullText = fullText + lastGoodText.toString();
                        lastGoodText = new StringBuilder();
                        builder = new StringBuilder();
                    }
                    lastGoodText.append(c);
                }
                text = fullText + " " + lastGoodText.toString();
            }
            StringTokenizer tokenizer = new StringTokenizer(text);
            String line = "";
            while (tokenizer.hasMoreTokens()) {
                String lineBefore = line;
                String token = tokenizer.nextToken();
                if (line.length() > 0) {
                    line = line + " ";
                }
                line = line + token;
                if (gc.stringExtent((String)line).x <= width) continue;
                if (lineBefore.length() > 0) {
                    lines.add(lineBefore);
                }
                line = token;
            }
            if (line.length() > 0) {
                lines.add(line);
            }
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String propFileName) {
        Properties props = new Properties();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(propFileName);
            props.load(inStream);
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {}
        }
        return props;
    }

    public static void saveProperties(String propFileName, Properties propsToSave) {
        SDKUtil.saveProperties(propFileName, propsToSave, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(String propFileName, Properties propsToSave, String comments) {
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(propFileName);
            propsToSave.store(outStream, comments);
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (outStream == null) {
                    File parentDir;
                    String parentName = new File(propFileName).getParent();
                    if (parentName != null && !(parentDir = new File(parentName)).exists() && parentDir.mkdirs()) {
                        outStream = new FileOutputStream(propFileName);
                    }
                    SDKUtil.saveProperties(propFileName, propsToSave, comments);
                } else if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static boolean checkCommonProperties(Shell shell, boolean author, boolean openOffice, boolean iReport) {
        boolean showWizard = author || openOffice || iReport;
        boolean showAuthor = author;
        boolean showIRport = iReport;
        boolean showOpenOffice = openOffice;
        String DEV_PROP_FILE = File.separator + ".netiq" + File.separator + "pluginsdk" + File.separator + "dev.properties";
        String IREPORT_PROP_FILE = File.separator + ".netiq" + File.separator + "pluginsdk" + File.separator + "iReport.properties";
        String OPENOFFICE_PROP_FILE = File.separator + ".netiq" + File.separator + "pluginsdk" + File.separator + "oo.properties";
        if (showWizard) {
            String devPropFileName;
            if (showAuthor) {
                devPropFileName = String.format("%s%s", System.getProperty(SDKConstants.USER_HOME), DEV_PROP_FILE);
                Properties authorProperties = SDKUtil.loadProperties(devPropFileName);
                String authorString = authorProperties.getProperty(SDKConstants.PREF_PLUGIN_AUTHOR, "");
                showAuthor = authorString.isEmpty();
            }
            if (showIRport) {
                devPropFileName = String.format("%s%s", System.getProperty(SDKConstants.USER_HOME), IREPORT_PROP_FILE);
                Properties iReportProperties = SDKUtil.loadProperties(devPropFileName);
                String iReportString = iReportProperties.getProperty(SDKConstants.PREF_IREPORT_PATH, "");
                showIRport = iReportString.isEmpty();
            }
            if (showOpenOffice) {
                devPropFileName = String.format("%s%s", System.getProperty(SDKConstants.USER_HOME), OPENOFFICE_PROP_FILE);
                Properties openOfficeProperties = SDKUtil.loadProperties(devPropFileName);
                String openOfficeString = openOfficeProperties.getProperty(SDKConstants.PREF_OPENOFFICE_PATH, "");
                showOpenOffice = openOfficeString.isEmpty();
            }
            boolean bl = showWizard = showAuthor || showOpenOffice || showIRport;
            if (showWizard) {
                CommonPropertiesWizard wizard = new CommonPropertiesWizard(showAuthor, showIRport, showOpenOffice);
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.setHelpAvailable(false);
                dialog.create();
                int dialogRc = dialog.open();
                if (dialogRc != 0) {
                    return false;
                }
            }
        }
        return true;
    }
}

