/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.actions;

import com.netiq.sentinel.sdk.Messages;
import com.netiq.sentinel.sdk.SDKUtil;
import com.netiq.sentinel.sdk.actions.BuildType;
import com.netiq.sentinel.sdk.actions.CreateLuceneConnectionAction;
import com.netiq.sentinel.sdk.actions.IActionCompleteListener;
import com.netiq.sentinel.sdk.model.PluginType;
import com.netiq.sentinel.sdk.model.SentinelPlugin;
import com.netiq.sentinel.sdk.model.SentinelProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public abstract class BuildAction
implements IObjectActionDelegate {
    protected Shell shell;
    protected ISelection m_selection;
    protected IStreamListener m_outputListener = null;
    protected IActionCompleteListener m_completeListener = null;
    private BuildType m_buildType;
    private static final String ATTR_LOCATION = "org.eclipse.ui.externaltools.ATTR_LOCATION";
    private static final String ATTR_TOOL_ARGUMENTS = "org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS";

    public BuildAction(BuildType buildType) {
        this.m_buildType = buildType;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.m_selection = selection;
    }

    protected void runBuild(IFile buildFile, String argument) {
        if (this.m_buildType.getTarget().isEmpty()) {
            int index;
            boolean notFound = true;
            if (this.m_buildType.getValue() == 0 && (index = argument.indexOf("\"\"")) != 0) {
                notFound = false;
            }
            if (notFound) {
                MessageDialog.openWarning((Shell)this.shell, (String)this.m_buildType.getTitle(), (String)Messages.Ant_Target_Not_Defined);
                return;
            }
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IProject selectProject = null;
        SentinelPlugin selectedPlugin = null;
        if (this.m_selection != null && ((IStructuredSelection)this.m_selection).getFirstElement() instanceof SentinelProject) {
            SentinelProject sentinelObject = (SentinelProject)((IStructuredSelection)this.m_selection).getFirstElement();
            selectProject = sentinelObject.getProject();
        } else if (this.m_selection != null && ((IStructuredSelection)this.m_selection).getFirstElement() instanceof SentinelPlugin) {
            selectedPlugin = (SentinelPlugin)((IStructuredSelection)this.m_selection).getFirstElement();
        }
        final IProject curSelectProject = selectProject;
        final SentinelPlugin curSelectedPlugin = selectedPlugin;
        try {
            activePage.showView("org.eclipse.ui.console.ConsoleView");
            final ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
            final ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, "Sentinel SDK Build");
            workingCopy.setAttribute("org.eclipse.debug.ui.private", true);
            workingCopy.setAttribute(ATTR_LOCATION, buildFile.getLocation().toOSString());
            if (!argument.isEmpty()) {
                workingCopy.setAttribute(ATTR_TOOL_ARGUMENTS, argument);
            }
            final ILaunch launch = workingCopy.launch("run", null);
            final boolean[] buildSucceeded = new boolean[]{true};
            final StringBuffer buildError = new StringBuffer();
            launch.getProcesses()[0].getStreamsProxy().getErrorStreamMonitor().addListener(new IStreamListener(){
                boolean grabError = false;

                public void streamAppended(String text, IStreamMonitor monitor) {
                    if (text.indexOf("BUILD FAILED") > -1) {
                        buildSucceeded[0] = false;
                        this.grabError = true;
                    } else if (this.grabError) {
                        buildError.append(text);
                    }
                }
            });
            if (this.m_outputListener != null) {
                launch.getProcesses()[0].getStreamsProxy().getOutputStreamMonitor().addListener(this.m_outputListener);
            }
            manager.addLaunchListener((ILaunchesListener)new ILaunchesListener2(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void launchesTerminated(ILaunch[] launches) {
                    String error = null;
                    try {
                        if (!buildSucceeded[0]) {
                            throw new Exception(buildError.toString());
                        }
                        for (int i = 0; i < launches.length; ++i) {
                            if (!launches[i].equals(launch) || !buildSucceeded[0] || ((IProgressMonitor)launches[i].getProcesses()[0]).isCanceled()) continue;
                            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (BuildAction.this instanceof CreateLuceneConnectionAction) {
                                        return;
                                    }
                                    try {
                                        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                                        for (int i = 0; i < projects.length; ++i) {
                                            PluginType pluginType;
                                            if (curSelectProject != null && projects[i].getProject().equals(curSelectProject)) {
                                                projects[i].getProject().refreshLocal(2, null);
                                                continue;
                                            }
                                            if (curSelectedPlugin == null || (pluginType = SDKUtil.getPluginType(projects[i].getProject())) == null || !pluginType.equals((Object)curSelectedPlugin.getPluginType())) continue;
                                            projects[i].getProject().refreshLocal(2, null);
                                        }
                                    }
                                    catch (CoreException e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                            break;
                        }
                    }
                    catch (Exception e) {
                        error = e.getLocalizedMessage();
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (BuildAction.this instanceof CreateLuceneConnectionAction) {
                                    return;
                                }
                                String msg = NLS.bind((String)Messages.Build_Failed, (Object)e.toString());
                                MessageDialog.openWarning((Shell)BuildAction.this.shell, (String)BuildAction.this.m_buildType.getTitle(), (String)msg);
                            }
                        });
                    }
                    finally {
                        manager.removeLaunchListener((ILaunchesListener)this);
                        if (BuildAction.this.m_completeListener != null) {
                            BuildAction.this.m_completeListener.completed(error);
                        }
                        try {
                            workingCopy.delete();
                        }
                        catch (Exception exception) {}
                    }
                }

                public void launchesAdded(ILaunch[] launches) {
                }

                public void launchesChanged(ILaunch[] launches) {
                }

                public void launchesRemoved(ILaunch[] launches) {
                }
            });
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void setOutputStreamListener(IStreamListener listener) {
        this.m_outputListener = listener;
    }

    public void setCompletionListener(IActionCompleteListener listener) {
        this.m_completeListener = listener;
    }
}

