/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.actions;

import com.netiq.sentinel.sdk.Messages;
import com.netiq.sentinel.sdk.actions.BuildAction;
import com.netiq.sentinel.sdk.actions.BuildType;
import com.netiq.sentinel.sdk.model.SentinelPlugin;
import com.netiq.sentinel.sdk.sdkscriptsproperties.ScriptProperties;
import java.util.Map;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class BuildReleaseAction
extends BuildAction {
    public BuildReleaseAction() {
        super(BuildType.RELEASE);
    }

    public void run(IAction action) {
        String[] labels;
        if (!DebugUITools.saveBeforeLaunch()) {
            return;
        }
        if (this.m_selection == null || !(((IStructuredSelection)this.m_selection).getFirstElement() instanceof SentinelPlugin)) {
            MessageDialog.openError((Shell)this.shell, (String)Messages.Title_Build_Plugin, (String)Messages.Build_InvalidObject);
            return;
        }
        SentinelPlugin plugin = (SentinelPlugin)((IStructuredSelection)this.m_selection).getFirstElement();
        String msg = NLS.bind((String)Messages.BuildRelease_UpdateVersion, (Object)plugin.getBuildNumber(), (Object)plugin.getVersionString());
        MessageDialog dialog = new MessageDialog(this.shell, Messages.Title_Build_Plugin, null, msg, 6, labels = new String[]{Messages.Yes, Messages.No, Messages.Cancel}, 0);
        int result = dialog.open();
        if (result == -1 || result == 2) {
            return;
        }
        Map<String, String> Parameters = ScriptProperties.getParameters("build", "buildRelease");
        String response = "n";
        if (result == 0) {
            response = "y";
        }
        String arguments = String.format("\"" + BuildType.RELEASE.getTarget() + "\" -D" + Parameters.get("updateVersion") + "=\"%s\"", response);
        SentinelPlugin sentinelPlugin = (SentinelPlugin)((IStructuredSelection)this.m_selection).getFirstElement();
        this.runBuild(sentinelPlugin.getBuildFile(), arguments);
    }
}

