/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.actions;

import com.netiq.sentinel.sdk.Messages;
import com.netiq.sentinel.sdk.sdkscriptsproperties.ScriptProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public enum BuildType {
    NEW_PLUGIN(0, ""),
    RELEASE(1, "buildRelease"),
    TEST(2, "buildTest"),
    EDIT_REPORT(3, "editReport"),
    CREATE_CONNECTION(4, "createLuceneConnection"),
    CONVERT_2011(5, "convertTo2011.1"),
    EDIT_COLLECTOR_PACK(6, "editCollectorPack"),
    CREATE_SOLUTION_PACK_STUB(7, "createSolutionPackStub"),
    EXTRACT_JASPER_PARAMETERS(8, "extractJasperParameters"),
    SOLUTION_PACK_PLACEHOLDER(9, "solutionPackPlaceholder"),
    EDIT_SOLUTION_PACK(10, "editSolutionPack"),
    SUBMIT_FOR_CERT(11, "submitForCertification"),
    CONVERT_SOLUTION_PACK(12, "convertSolutionPack");

    protected static final int NEW_PLUGIN_TYPE = 0;
    protected static final int TEST_BUILD_TYPE = 1;
    protected static final int REL_BUILD_TYPE = 2;
    protected static final int EDIT_REPORT_TYPE = 3;
    protected static final int CREATE_CONNECTION_TYPE = 4;
    protected static final int CONVERT_2011_TYPE = 5;
    protected static final int EDIT_COLLECTOR_PACK_TYPE = 6;
    protected static final int CREATE_SOLUTION_PACK_STUB_TYPE = 7;
    protected static final int EXTRACT_JASPER_PARAMETERS_TYPE = 8;
    protected static final int SOLUTION_PACK_PLACEHOLDER_TYPE = 9;
    protected static final int EDIT_SOLUTION_PACK_TYPE = 10;
    protected static final int SUBMIT_FOR_CERT_TYPE = 11;
    protected static final int CONVERT_SOLUTION_PACK_TYPE = 12;
    private static final BuildType[] VALUES_ARRAY;
    public static final List<BuildType> VALUES;
    private final int value;
    private final String target;

    public static BuildType getByTarget(String target) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            BuildType result = VALUES_ARRAY[i];
            if (!result.getTarget().equals(target)) continue;
            return result;
        }
        return null;
    }

    public static BuildType get(int value) {
        switch (value) {
            case 0: {
                return NEW_PLUGIN;
            }
            case 2: {
                return RELEASE;
            }
            case 1: {
                return TEST;
            }
            case 3: {
                return EDIT_REPORT;
            }
            case 4: {
                return CREATE_CONNECTION;
            }
            case 5: {
                return CONVERT_2011;
            }
            case 6: {
                return EDIT_COLLECTOR_PACK;
            }
            case 9: {
                return SOLUTION_PACK_PLACEHOLDER;
            }
            case 10: {
                return EDIT_SOLUTION_PACK;
            }
            case 7: {
                return CREATE_SOLUTION_PACK_STUB;
            }
            case 8: {
                return EXTRACT_JASPER_PARAMETERS;
            }
            case 11: {
                return SUBMIT_FOR_CERT;
            }
            case 12: {
                return CONVERT_SOLUTION_PACK;
            }
        }
        return null;
    }

    private BuildType(int value, String target) {
        this.value = value;
        this.target = target;
    }

    public int getValue() {
        return this.value;
    }

    public String getTarget() {
        return ScriptProperties.getTarget("build", this.target);
    }

    public String getTitle() {
        switch (this.value) {
            case 0: {
                return Messages.Title_NewPlugin;
            }
            case 2: {
                return Messages.Title_Build_Plugin;
            }
            case 1: {
                return Messages.Title_Build_Plugin;
            }
            case 3: {
                return Messages.Title_EditReport;
            }
            case 4: {
                return Messages.CreateLuceneConnection_Title;
            }
            case 5: {
                return Messages.Title_Convert2011;
            }
            case 6: {
                return Messages.Title_EditCollectorPack;
            }
            case 9: {
                return Messages.Title_SolutionPackPlaceholder;
            }
            case 7: {
                return Messages.Title_CreateSolutionPackStub;
            }
            case 8: {
                return Messages.Title_ExtractJasperParameters;
            }
            case 10: {
                return Messages.Title_EditSolutionPack;
            }
            case 11: {
                return Messages.Title_SubmitForCertification;
            }
            case 12: {
                return Messages.Title_ConvertSolutionPack;
            }
        }
        return "";
    }

    public Map<String, String> getParameters() {
        return ScriptProperties.getParameters("build", this.target);
    }

    static {
        VALUES_ARRAY = new BuildType[]{NEW_PLUGIN, RELEASE, TEST, EDIT_REPORT, CREATE_CONNECTION, CONVERT_2011, EDIT_COLLECTOR_PACK, CREATE_SOLUTION_PACK_STUB, EXTRACT_JASPER_PARAMETERS, SOLUTION_PACK_PLACEHOLDER, EDIT_SOLUTION_PACK, SUBMIT_FOR_CERT, CONVERT_SOLUTION_PACK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

