/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.actions;

import com.netiq.sentinel.sdk.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class ImportContentProjectAction
extends Action {
    private TreeViewer m_viewer;
    private String m_projectPath;

    public ImportContentProjectAction(TreeViewer viewer) {
        this.m_viewer = viewer;
        this.setText(Messages.ImportProject_ClickToImportContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean importedProject = false;
        boolean failed = false;
        IProject project = null;
        DirectoryDialog dialog = new DirectoryDialog(this.m_viewer.getControl().getShell(), 8192);
        dialog.setText(Messages.ImportProject_BrowseForContentProject);
        dialog.setMessage(Messages.ImportProject_SelectContentProjectDirectory);
        this.m_projectPath = dialog.open();
        if (this.m_projectPath == null) {
            return;
        }
        try {
            IProjectNature rddNature;
            IProjectNature solutionNature;
            IProjectNature reportNature;
            IProjectNature actionNature;
            IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(this.m_projectPath + "/.project"));
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
            if (project.exists()) {
                MessageDialog.openWarning((Shell)this.m_viewer.getControl().getShell(), (String)Messages.SentinelProject, (String)Messages.ImportProject_ProjectAlreadyExists);
                project = null;
                return;
            }
            project.create(description, null);
            project.open(null);
            importedProject = true;
            IProjectNature collectorNature = project.getNature("com.netiq.sentinel.sdk.SentinelCollectorProjectNature");
            if (collectorNature == null && (actionNature = project.getNature("com.netiq.sentinel.sdk.SentinelActionProjectNature")) == null && (reportNature = project.getNature("com.netiq.sentinel.sdk.SentinelReportProjectNature")) == null && (solutionNature = project.getNature("com.netiq.sentinel.sdk.SentinelSolutionProjectNature")) == null && (rddNature = project.getNature("com.netiq.sentinel.sdk.SentinelRDDProjectNature")) == null) {
                MessageDialog.openError((Shell)this.m_viewer.getControl().getShell(), (String)Messages.SentinelProject, (String)Messages.ImportProject_NotContentProject);
                failed = true;
                return;
            }
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.m_viewer.getControl().getShell(), (String)Messages.SentinelProject, (String)Messages.ImportProject_NotContentProject);
            failed = true;
        }
        finally {
            if (failed && project != null && importedProject) {
                try {
                    project.delete(false, true, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

