/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.actions;

import com.netiq.sentinel.sdk.Messages;
import com.netiq.sentinel.sdk.SDKUtil;
import com.netiq.sentinel.sdk.XMLFileReader;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.NodeList;

public class ImportSDKProjectAction
extends Action {
    private TreeViewer m_viewer;
    private XMLFileReader m_projectImports;
    private String m_sdkPath;

    public ImportSDKProjectAction(TreeViewer viewer) {
        this.m_viewer = viewer;
        this.setText(Messages.ImportProject_ClickToImport);
    }

    public void run() {
        DirectoryDialog dialog = new DirectoryDialog(this.m_viewer.getControl().getShell(), 8192);
        dialog.setText(Messages.ImportProject_BrowseForSDK);
        dialog.setMessage(Messages.ImportProject_SelectSDKDirectory);
        this.m_sdkPath = dialog.open();
        if (this.m_sdkPath == null) {
            return;
        }
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.m_viewer.getControl().getShell());
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    ImportSDKProjectAction.this.performImport(monitor);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        };
        try {
            pmd.run(false, false, operation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performImport(IProgressMonitor monitor) {
        IProject project = null;
        boolean importedProject = false;
        boolean failed = false;
        try {
            IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(this.m_sdkPath + "/.project"));
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
            if (project.exists()) {
                MessageDialog.openWarning((Shell)this.m_viewer.getControl().getShell(), (String)Messages.SentinelSDK, (String)Messages.ImportProject_ProjectAlreadyExists);
                project = null;
                return;
            }
            project.create(description, monitor);
            project.open(monitor);
            importedProject = true;
            IProjectNature sdkNature = project.getNature("com.netiq.sentinel.sdk.SentinelSDKNature");
            if (sdkNature == null) {
                MessageDialog.openError((Shell)this.m_viewer.getControl().getShell(), (String)Messages.SentinelSDK, (String)Messages.ImportProject_NotSDKProject);
                failed = true;
                return;
            }
            SDKUtil.setSDKProject(project);
            this.importPluginProjects(monitor);
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.m_viewer.getControl().getShell(), (String)Messages.SentinelSDK, (String)Messages.ImportProject_NotSDKProject);
            failed = true;
        }
        finally {
            if (failed && project != null && importedProject) {
                try {
                    project.delete(false, true, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void importPluginProjects(IProgressMonitor monitor) {
        this.m_projectImports = new XMLFileReader("ProjectImports.xml");
        if (this.m_projectImports == null || this.m_projectImports.getDocment() == null) {
            return;
        }
        NodeList NameNodes = this.m_projectImports.getDocment().getElementsByTagName("project");
        for (int i = 0; i < NameNodes.getLength(); ++i) {
            String relativePath = NameNodes.item(i).getTextContent();
            this.importPluginProject(this.m_sdkPath + File.separator + relativePath, monitor);
        }
    }

    private void importPluginProject(String filePath, IProgressMonitor monitor) {
        try {
            IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(filePath));
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
            if (project.exists()) {
                return;
            }
            project.create(description, monitor);
            project.open(monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

