/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.actions;

import com.netiq.sentinel.sdk.Messages;
import com.netiq.sentinel.sdk.SDKUtil;
import com.netiq.sentinel.sdk.actions.BuildAction;
import com.netiq.sentinel.sdk.actions.BuildType;
import com.netiq.sentinel.sdk.model.PluginType;
import com.netiq.sentinel.sdk.model.SentinelProject;
import com.netiq.sentinel.sdk.sdkscriptsproperties.ScriptProperties;
import com.netiq.sentinel.sdk.wizards.NewSentinelPluginWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class NewPluginAction
extends BuildAction {
    public NewPluginAction() {
        super(BuildType.NEW_PLUGIN);
    }

    public void run(IAction action) {
        String arguments = "";
        NewSentinelPluginWizard wizard = new NewSentinelPluginWizard(this.m_selection);
        WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
        dialog.setHelpAvailable(false);
        dialog.create();
        wizard.sizeAndCenter(dialog);
        int dialogRc = dialog.open();
        if (dialogRc != 0) {
            return;
        }
        arguments = wizard.getArguments();
        if (this.m_selection == null || !(((IStructuredSelection)this.m_selection).getFirstElement() instanceof SentinelProject)) {
            MessageDialog.openError((Shell)this.shell, (String)Messages.Title_NewPlugin, (String)Messages.NewPlugin_InvalidSelectedObject);
            return;
        }
        SentinelProject sentinelProject = (SentinelProject)((IStructuredSelection)this.m_selection).getFirstElement();
        String filePath = null;
        if (!(sentinelProject.getPluginType().equals((Object)PluginType.ACTION) || sentinelProject.getPluginType().equals((Object)PluginType.COLLECTOR) || sentinelProject.getPluginType().equals((Object)PluginType.REPORT) || sentinelProject.getPluginType().equals((Object)PluginType.RDD) || sentinelProject.getPluginType().equals((Object)PluginType.SOLUTION))) {
            MessageDialog.openError((Shell)this.shell, (String)Messages.Title_NewPlugin, (String)Messages.NewPlugin_InvalidPluginType);
            return;
        }
        filePath = "/build/" + ScriptProperties.getScriptName("buildnew");
        IProject sdkProject = SDKUtil.getSDKProject();
        if (sdkProject != null) {
            IFile buildFile = sdkProject.getProject().getFile(filePath);
            if (buildFile != null && buildFile.exists()) {
                this.runBuild(buildFile, arguments);
            } else {
                MessageDialog.openError((Shell)this.shell, (String)Messages.Title_NewPlugin, (String)Messages.NewPlugin_NoBuildFile);
            }
        } else {
            MessageDialog.openError((Shell)this.shell, (String)Messages.Title_NewPlugin, (String)Messages.NewPlugin_MissingSDKProject);
        }
    }
}

