/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.connectionmethods;

import com.netiq.sentinel.sdk.connectionmethods.ConnectionMethodEditor;
import com.netiq.sentinel.sdk.editors.xml.ConnectionsRawXMLEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.MultiPageEditorPart;

public class ConnectionMethodMultiPageEditorPart
extends MultiPageEditorPart
implements IResourceChangeListener {
    public static final String ID = "com.netiq.sentinel.sdk.connectionmethods.ConnectionMethodMultiPageEditorPart";
    private ConnectionMethodEditor CM;
    private ConnectionsRawXMLEditor XME;
    private boolean editorCompatible;
    private boolean loaded = false;

    public ConnectionMethodMultiPageEditorPart() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected void createPages() {
        this.createEditorPage();
        super.setTitle(this.getFileName());
        this.firePropertyChange(1);
        this.createXMLPage();
    }

    String getPath() {
        IEditorInput input = this.CM.getEditorInput();
        IFile file = ResourceUtil.getFile((IEditorInput)input);
        IPath path = file.getLocation();
        return path.toOSString();
    }

    String getFileName() {
        IEditorInput input = this.CM.getEditorInput();
        IFile file = ResourceUtil.getFile((IEditorInput)input);
        return file.getName();
    }

    void createEditorPage() {
        try {
            this.CM = new ConnectionMethodEditor();
            int index = this.addPage((IEditorPart)this.CM, this.getEditorInput());
            this.setPageText(index, "Design");
            this.CM.openConnectionMethodsReader(this.getPath());
            this.editorCompatible = this.CM.isCompatible();
            this.loaded = true;
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    void createXMLPage() {
        try {
            this.XME = new ConnectionsRawXMLEditor();
            int index = this.addPage((IEditorPart)this.XME, this.getEditorInput());
            this.setPageText(index, "Source");
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    protected void pageChange(int newPageIndex) {
        if (!this.editorCompatible && newPageIndex == 0) {
            super.setActivePage(1);
        } else {
            super.pageChange(newPageIndex);
            if (newPageIndex == 1 && this.CM.isDirty()) {
                this.CM.designSave();
                this.XME.getDocumentProvider().getDocument((Object)this.XME.getEditorInput()).set(this.CM.getXMLDocString());
            }
            if (newPageIndex == 0 && !this.loaded) {
                this.CM.updateEditor(this.XME.getDocumentProvider().getDocument((Object)this.XME.getEditorInput()).get());
            }
            this.loaded = false;
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        if (super.getActivePage() == 1) {
            this.CM.updateEditor(this.XME.getDocumentProvider().getDocument((Object)this.XME.getEditorInput()).get());
        } else if (super.getActivePage() == 0) {
            this.CM.designSave();
            this.XME.getDocumentProvider().getDocument((Object)this.XME.getEditorInput()).set(this.CM.getXMLDocString());
        }
        this.XME.doSave(monitor);
    }

    public void doSaveAs() {
    }

    public void resourceChanged(IResourceChangeEvent arg0) {
    }
}

