/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.connectionmethods;

import com.netiq.sentinel.sdk.XMLFileReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConnectionMethodsReader {
    public Document Template;
    public Document Plugin;
    String outFile;

    public ConnectionMethodsReader(String Path2) {
        XMLFileReader plug = null;
        XMLFileReader templ = new XMLFileReader("2011.1/Collector/var/", "connectionMethods.xml", false);
        this.Template = templ.getDocment();
        plug = new XMLFileReader(Path2, "connectionMethods.xml", true);
        this.Plugin = plug.getDocment();
        this.outFile = plug.getFullPath();
    }

    public String getXMLDocString() {
        try {
            DOMSource domSource = new DOMSource(this.Plugin);
            StringWriter strWriter = new StringWriter();
            StreamResult strmResult = new StreamResult(strWriter);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, strmResult);
            strWriter.flush();
            return strWriter.toString();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void updatePluginFromDocument(String XML) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.Plugin = document = builder.parse(new InputSource(new StringReader(XML)));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void saveFile() {
        try {
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(new DOMSource(this.Plugin), new StreamResult(new File(this.outFile)));
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public ArrayList<String> getListofConnections(Document srcDoc) {
        if (srcDoc == null) {
            srcDoc = this.Plugin;
        }
        ArrayList<String> Connectors = new ArrayList<String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList Temp = null;
        try {
            Temp = (NodeList)xpath.evaluate("//ConnectionMethod/ConnectorName", srcDoc, XPathConstants.NODESET);
            for (int i = 0; i < Temp.getLength(); ++i) {
                Connectors.add(Temp.item(i).getTextContent());
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return Connectors;
    }

    private ArrayList<String> getConnectorProperties(Document srcDoc, String Connector) {
        ArrayList<String> ConnectionModeProperties = new ArrayList<String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList Temp = null;
        try {
            Temp = (NodeList)xpath.evaluate("//ConnectionMethod[ConnectorName='" + Connector + "']//Property/Name", srcDoc, XPathConstants.NODESET);
            for (int i = 0; i < Temp.getLength(); ++i) {
                ConnectionModeProperties.add(Temp.item(i).getTextContent());
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return ConnectionModeProperties;
    }

    private boolean extraInternalNames() {
        ArrayList<String> PlugProperties = new ArrayList<String>();
        ArrayList<String> TemplateProperties = new ArrayList<String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList Temp = null;
        NodeList Temp2 = null;
        try {
            int i;
            Temp = (NodeList)xpath.evaluate("//ConnectionMethod//ConnectionMode/InternalName", this.Plugin, XPathConstants.NODESET);
            Temp2 = (NodeList)xpath.evaluate("//ConnectionMethod//ConnectionMode/InternalName", this.Template, XPathConstants.NODESET);
            if (Temp.getLength() > Temp2.getLength()) {
                return true;
            }
            for (i = 0; i < Temp.getLength(); ++i) {
                PlugProperties.add(Temp.item(i).getTextContent());
            }
            for (i = 0; i < Temp2.getLength(); ++i) {
                TemplateProperties.add(Temp2.item(i).getTextContent());
            }
            if (TemplateProperties.containsAll(PlugProperties)) {
                return false;
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean isEditorCompatible() {
        ArrayList<Object> templateConnectors = new ArrayList();
        ArrayList<Object> pluginConnectors = new ArrayList();
        ArrayList<Object> pluginConnectorProperties = new ArrayList();
        ArrayList<Object> templateConnectorProperties = new ArrayList();
        boolean isCompatible = true;
        templateConnectors = this.getListofConnections(this.Template);
        pluginConnectors = this.getListofConnections(this.Plugin);
        if (templateConnectors.size() < pluginConnectors.size()) {
            return false;
        }
        if (templateConnectors.containsAll(pluginConnectors)) {
            isCompatible = true;
        }
        if (this.extraInternalNames()) {
            return false;
        }
        for (int i = 0; i < pluginConnectors.size(); ++i) {
            pluginConnectorProperties = this.getConnectorProperties(this.Plugin, (String)pluginConnectors.get(i));
            templateConnectorProperties = this.getConnectorProperties(this.Plugin, (String)pluginConnectors.get(i));
            if (templateConnectorProperties.containsAll(pluginConnectorProperties)) continue;
            return false;
        }
        return isCompatible;
    }

    private String getDisplayNamebyProperty(String Connector, String Property, Document Doc) {
        if (Doc == null) {
            Doc = this.Plugin;
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            return (String)xpath.evaluate("//ConnectionMethod[ConnectorName='" + Connector + "']//Property[Name='" + Property + "']/../../DisplayName", Doc, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return "";
        }
    }

    private String getDisplayName(String Connector, String UniqueInternalName, Document Doc) {
        if (Doc == null) {
            Doc = this.Plugin;
        }
        String Path2 = Connector.equalsIgnoreCase("SYSLOG") ? "//ConnectionMethods/ConnectionMethod[ConnectorName='" + Connector + "']//ConnectionMode[InternalName='line']/DisplayName" : (Connector.equalsIgnoreCase("Windows Event (WMI)") ? "//ConnectionMethods/ConnectionMethod[ConnectorName='" + Connector + "']//ConnectionMode[InternalName='" + UniqueInternalName + "']/DisplayName" : "//ConnectionMethod[ConnectorName='" + Connector + "']//DisplayName");
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            return (String)xpath.evaluate(Path2, Doc, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return "";
        }
    }

    public ArrayList<String> getConnectionModeInfobyProperty(String Connector, String Property) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        ArrayList<String> Temp = new ArrayList<String>();
        String DName = this.getDisplayNamebyProperty(Connector, Property, null);
        String BasePath = "//ConnectionMethod//ConnectionMode[DisplayName='" + DName + "']";
        try {
            Temp.add((String)xpath.evaluate(BasePath + "/InternalName", this.Plugin, XPathConstants.STRING));
            Temp.add((String)xpath.evaluate(BasePath + "/IsDefault", this.Plugin, XPathConstants.STRING));
            Temp.add((String)xpath.evaluate(BasePath + "//Property[Name='" + Property + "']/Value", this.Plugin, XPathConstants.STRING));
            return Temp;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return Temp;
        }
    }

    public String getConnectionModeInfo(String Connector, String InternalName) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String Temp = "";
        String BasePath = "//ConnectionMethod[ConnectorName='" + Connector + "']//ConnectionMode[InternalName='" + InternalName + "']";
        try {
            Temp = (String)xpath.evaluate(BasePath + "/IsDefault", this.Plugin, XPathConstants.STRING);
            return Temp;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return Temp;
        }
    }

    public ArrayList<String> getListofSyslogConnectionModes(String Connector) {
        ArrayList<String> ConnectionModes = new ArrayList<String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList Temp = null;
        try {
            Temp = (NodeList)xpath.evaluate("//ConnectionMethod[ConnectorName='SYSLOG']//Property[Name!='DataFormat']/Name", this.Plugin, XPathConstants.NODESET);
            for (int i = 0; i < Temp.getLength(); ++i) {
                ConnectionModes.add(Temp.item(i).getTextContent());
            }
            String Temp2 = (String)xpath.evaluate("//ConnectionMethod[ConnectorName='SYSLOG']//ConnectionMode[InternalName='line']/InternalName", this.Plugin, XPathConstants.STRING);
            if (Temp2 != "" || Temp2 != null) {
                ConnectionModes.add(Temp2);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return ConnectionModes;
    }

    public ArrayList<String> getListofConnectionModes(String Connector) {
        ArrayList<String> ConnectionModes = new ArrayList<String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList Temp = null;
        try {
            Temp = (NodeList)xpath.evaluate("//ConnectionMethod[ConnectorName='" + Connector + "']//ConnectionMode/InternalName", this.Plugin, XPathConstants.NODESET);
            for (int i = 0; i < Temp.getLength(); ++i) {
                ConnectionModes.add(Temp.item(i).getTextContent());
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return ConnectionModes;
    }

    public boolean isDefaultConnector(String Connector) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            if (((Boolean)xpath.evaluate("//ConnectionMethod[ConnectorName='" + Connector + "']/IsDefault=1", this.Plugin, XPathConstants.BOOLEAN)).booleanValue()) {
                return true;
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void writeConnection(String Connector, Boolean CDefault, String InternalName, Boolean CMDefault, Boolean CMEnabled, String PropertyName, String PropertyValue) {
        String DisplayName = "";
        DisplayName = PropertyName != "" ? this.getDisplayNamebyProperty(Connector, PropertyName, this.Template) : this.getDisplayName(Connector, InternalName, this.Template);
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            if (((Boolean)xpath.evaluate("//ConnectorName='" + Connector + "'", this.Plugin, XPathConstants.BOOLEAN)).booleanValue()) {
                this.updateConnection(Connector, CDefault, DisplayName, CMDefault, CMEnabled, PropertyName, PropertyValue);
            } else if (CMEnabled.booleanValue()) {
                this.addNewConnectionMethod(Connector);
                this.updateConnection(Connector, CDefault, DisplayName, CMDefault, CMEnabled, PropertyName, PropertyValue);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private void updateConnection(String Connector, Boolean CDefault, String DisplayName, Boolean CMDefault, Boolean CMEnabled, String PropertyName, String PropertyValue) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String BasePath = "//ConnectionMethod[ConnectorName='" + Connector + "']";
        Node CDefaultNode = (Node)xpath.evaluate(BasePath + "/IsDefault", this.Plugin, XPathConstants.NODE);
        if (CDefault.booleanValue()) {
            CDefaultNode.setTextContent("1");
        } else {
            CDefaultNode.setTextContent("0");
        }
        String ConnectionModePath = "//ConnectionMode[DisplayName='" + DisplayName + "']";
        if (((Boolean)xpath.evaluate(BasePath + "//DisplayName='" + DisplayName + "'", this.Plugin, XPathConstants.BOOLEAN)).booleanValue() && CMEnabled.booleanValue()) {
            Node CMDefaultNode = (Node)xpath.evaluate(BasePath + ConnectionModePath + "/IsDefault", this.Plugin, XPathConstants.NODE);
            if (CMDefault.booleanValue()) {
                CMDefaultNode.setTextContent("1");
            } else {
                CMDefaultNode.setTextContent("0");
            }
            if (!PropertyName.equalsIgnoreCase("") && !PropertyName.equalsIgnoreCase("")) {
                Node PropertyValueNode = (Node)xpath.evaluate(BasePath + ConnectionModePath + "//Property[Name='" + PropertyName + "']/Value", this.Plugin, XPathConstants.NODE);
                PropertyValueNode.setTextContent(PropertyValue);
            }
        } else if (CMEnabled.booleanValue()) {
            this.addNewConnectionMode(Connector, DisplayName, PropertyName);
            this.updateConnection(Connector, CDefault, DisplayName, CMDefault, CMEnabled, PropertyName, PropertyValue);
        } else if (((Boolean)xpath.evaluate(BasePath + "//DisplayName='" + DisplayName + "'", this.Plugin, XPathConstants.BOOLEAN)).booleanValue() && !CMEnabled.booleanValue()) {
            this.removeConnectionMode(Connector, DisplayName);
        }
    }

    private void removeConnectionMode(String Connector, String DisplayName) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node node = (Node)xpath.evaluate("//ConnectionMethods/ConnectionMethod[ConnectorName='" + Connector + "']//ConnectionMode[DisplayName='" + DisplayName + "']", this.Plugin, XPathConstants.NODE);
            node.getParentNode().removeChild(node);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private void addNewConnectionMode(String Connector, String DisplayName, String PropertyName) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String BasePath = "//ConnectionMethod[ConnectorName='" + Connector + "']";
        String ConnectionModePath = "//ConnectionModes/ConnectionMode[DisplayName='" + DisplayName + "']";
        String FullPath = BasePath.concat(ConnectionModePath);
        Node ConnectionMode = (Node)xpath.evaluate(FullPath, this.Template, XPathConstants.NODE);
        NodeList ConnectionMethods = (NodeList)xpath.evaluate(BasePath + "/ConnectionModes", this.Plugin, XPathConstants.NODESET);
        ConnectionMethods.item(0).appendChild(ConnectionMethods.item(0).getOwnerDocument().importNode(ConnectionMode, true));
    }

    private void addNewConnectionMethod(String Connector) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node ConnectionMethod = (Node)xpath.evaluate("//ConnectionMethods/ConnectionMethod[ConnectorName='" + Connector + "']", this.Template, XPathConstants.NODE);
        NodeList ConnectionMethods = (NodeList)xpath.evaluate("//ConnectionMethods", this.Plugin, XPathConstants.NODESET);
        ConnectionMethods.item(0).appendChild(ConnectionMethods.item(0).getOwnerDocument().importNode(ConnectionMethod, true));
        NodeList connectionModes = (NodeList)xpath.evaluate("//ConnectionMethods/ConnectionMethod[ConnectorName='" + Connector + "']//ConnectionMode", this.Plugin, XPathConstants.NODESET);
        for (int i = 0; i < connectionModes.getLength(); ++i) {
            connectionModes.item(i).getParentNode().removeChild(connectionModes.item(i));
        }
    }

    void removeConnections(ArrayList<String> Connectors) {
        ArrayList<Object> currentConnectors = new ArrayList();
        currentConnectors = this.getListofConnections(null);
        if (currentConnectors.size() != 0) {
            String XPathCondtionals = "";
            boolean deleteFile = false;
            if (Connectors.indexOf("FILE") != -1) {
                deleteFile = true;
                Connectors.remove("FILE");
            }
            for (int i = 0; i < Connectors.size(); ++i) {
                XPathCondtionals = XPathCondtionals.concat("ConnectorName='" + Connectors.get(i) + "'");
                if (i == Connectors.size() - 1) continue;
                XPathCondtionals = XPathCondtionals.concat(" or ");
            }
            try {
                Node lineMode;
                XPath xpath = XPathFactory.newInstance().newXPath();
                NodeList nodes = (NodeList)xpath.evaluate("//ConnectionMethods/ConnectionMethod[" + XPathCondtionals + "]", this.Plugin, XPathConstants.NODESET);
                for (int i = 0; i < nodes.getLength(); ++i) {
                    nodes.item(i).getParentNode().removeChild(nodes.item(i));
                }
                if (deleteFile && (lineMode = (Node)xpath.evaluate("//ConnectionMethods/ConnectionMethod[ConnectorName='FILE']//ConnectionMode[InternalName='line']", this.Plugin, XPathConstants.NODE)) != null) {
                    lineMode.getParentNode().removeChild(lineMode);
                }
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
        }
    }
}

