/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.editors;

import com.netiq.sentinel.sdk.SDKUtil;
import com.netiq.sentinel.sdk.TextFileReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class TableTextMultiPageEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    private TextEditor editor;
    private boolean isDirty;
    private Table table;
    private TableWidgetListener tableWidgetListener;
    private int columnCount;
    private int maxRowHeight;
    private SelectionListener selectionListener;
    private ArrayList<Integer> readOnlyColumns;
    private boolean readOnlyTable = false;
    private Map<Integer, String> columnValueList;

    public TableTextMultiPageEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.isDirty = false;
        this.maxRowHeight = 20;
        this.readOnlyColumns = new ArrayList();
        this.columnValueList = new LinkedHashMap<Integer, String>();
    }

    void createPage0() {
        try {
            this.editor = new TextEditor();
            int index = this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(index, "Text");
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    void createPage1() {
        Composite composite = new Composite(this.getContainer(), 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        layout.numColumns = 1;
        if (this.table == null) {
            this.table = this.getTableControl(composite);
            GridData gd = new GridData(768);
            gd.verticalAlignment = 4;
            gd.horizontalSpan = 1;
            gd.grabExcessHorizontalSpace = true;
            this.table.setLayoutData((Object)gd);
            gd.grabExcessVerticalSpace = true;
            this.table.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    TableTextMultiPageEditor.this.setColumnWidth();
                }
            });
        }
        int index = this.addPage((Control)composite);
        this.setPageText(index, "Table");
    }

    protected void createPages() {
        this.createPage0();
        this.createPage1();
        this.setActivePage(1);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
        if (this.tableWidgetListener != null) {
            this.tableWidgetListener.dispose();
        }
        if (this.table != null) {
            this.table.dispose();
        }
        this.tableWidgetListener = null;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.isDirty) {
            this.doSaveTable();
        }
        this.getEditor(0).doSave(monitor);
    }

    public void doSaveAs() {
        if (this.isDirty) {
            this.doSaveTable();
        }
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setPageText(0, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
        super.setPartName(editorInput.getName());
    }

    public boolean isSaveAsAllowed() {
        if (this.isDirty) {
            this.doSaveTable();
        }
        return true;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex == 1) {
            this.doLoad();
        } else if (this.isDirty) {
            this.doSaveTable();
        }
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] pages = TableTextMultiPageEditor.this.getSite().getWorkbenchWindow().getPages();
                    for (int i = 0; i < pages.length; ++i) {
                        if (!((FileEditorInput)TableTextMultiPageEditor.this.editor.getEditorInput()).getFile().getProject().equals(event.getResource())) continue;
                        IEditorPart editorPart = pages[i].findEditor(TableTextMultiPageEditor.this.editor.getEditorInput());
                        pages[i].closeEditor(editorPart, true);
                    }
                }
            });
        }
    }

    private void doLoad() {
        this.table.clearAll();
        this.table.removeAll();
        String editorText = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get();
        StringTokenizer tokenizer = new StringTokenizer(editorText, "\n\r");
        int index = 0;
        int columnCount = this.table.getColumnCount();
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            if (!line.startsWith("~")) {
                TableItem item = new TableItem(this.table, 0, index++);
                String[] lineArray = line.split(",");
                if (columnCount < 1 && columnCount != lineArray.length) {
                    this.setTableColumns(line);
                    columnCount = this.table.getColumnCount();
                }
                item.setText(lineArray);
                continue;
            }
            this.setTableColumns(line);
            columnCount = this.table.getColumnCount();
            this.setReadOnlyColumn(line);
        }
        if (columnCount < 1) {
            this.setDefaultTableColumns();
        }
    }

    private void doSaveTable() {
        if (this.table != null) {
            String line;
            String editorText = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get();
            StringTokenizer tokenizer = new StringTokenizer(editorText, "\n\r");
            String newEditorText = "";
            while (tokenizer.hasMoreTokens() && (line = tokenizer.nextToken()).startsWith("~")) {
                if (newEditorText.isEmpty()) {
                    newEditorText = line;
                    continue;
                }
                newEditorText = newEditorText + "\r\n";
                newEditorText = newEditorText + line;
            }
            TableItem[] items = this.table.getItems();
            for (int i = 0; i < items.length; ++i) {
                String newLine = "";
                for (int j = 0; j < this.columnCount; ++j) {
                    if (newLine.isEmpty()) {
                        newLine = items[i].getText(j);
                        continue;
                    }
                    newLine = newLine + ",";
                    newLine = newLine + items[i].getText(j);
                }
                newEditorText = newEditorText + "\r\n";
                newEditorText = newEditorText + newLine;
            }
            this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).set(newEditorText);
            this.isDirty = false;
        }
    }

    private Table getTableControl(Composite parent) {
        if (this.table == null) {
            this.table = new Table(parent, 2820);
            this.table.setFont(parent.getFont());
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            this.table.addSelectionListener(this.getSelectionListener());
            this.table.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TableTextMultiPageEditor.this.table = null;
                }
            });
            this.tableWidgetListener = new TableWidgetListener();
            this.table.addMouseListener((MouseListener)this.tableWidgetListener);
            Listener paintListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 41: {
                            if (event.height >= TableTextMultiPageEditor.this.maxRowHeight) break;
                            event.height += 5;
                        }
                    }
                }
            };
            this.table.addListener(41, paintListener);
        }
        return this.table;
    }

    private void setDefaultTableColumns() {
        TableColumn column = new TableColumn(this.table, 0);
        column.setText("Parameter Name");
        this.table.getColumn(0).pack();
        column = new TableColumn(this.table, 0);
        column.setText("Parameter value");
        this.table.getColumn(1).pack();
        this.columnCount = 2;
    }

    private void setTableColumns(String line) {
        if (this.table.getColumnCount() < 1) {
            String lineWihtout = line.replaceAll("~", "");
            String[] titles = lineWihtout.split(",");
            int j = 0;
            this.columnCount = titles.length;
            for (int i = 0; i < this.columnCount; ++i) {
                String columnName = titles[i].trim();
                if (columnName.length() <= 0) continue;
                TableColumn column = new TableColumn(this.table, 0);
                column.setText(titles[i]);
                this.table.getColumn(j).pack();
                ++j;
            }
        }
    }

    private void setReadOnlyColumn(String line) {
        block24: {
            block25: {
                block27: {
                    block26: {
                        block23: {
                            if (!line.matches(".*[Dd]o not modify lines below here.*")) break block23;
                            this.readOnlyTable = true;
                            break block24;
                        }
                        if (!line.matches(".*[Dd]o not modify.*") && !line.matches(".*[Rr]ead-only column-number.*")) break block25;
                        if (!line.matches(".*first.*") && !line.matches(".*1.*")) break block26;
                        this.readOnlyColumns.add(0);
                        break block24;
                    }
                    if (!line.matches(".*second.*") && !line.matches(".*2.*")) break block27;
                    this.readOnlyColumns.add(1);
                    break block24;
                }
                if (!line.matches(".*third.*") && !line.matches(".*3.*")) break block24;
                this.readOnlyColumns.add(2);
                break block24;
            }
            if (line.matches(".*[Rr]ead-only column-name.*")) {
                int fromIndex = 0;
                int endIndex = -1;
                int startIndex = line.indexOf(34, fromIndex);
                TableColumn[] columns = this.table.getColumns();
                while (startIndex > 0) {
                    if ((endIndex = line.indexOf(34, ++startIndex)) > 0) {
                        String columnName = line.substring(startIndex, endIndex);
                        for (int i = 0; i < columns.length; ++i) {
                            String curColumnName = columns[i].getText();
                            if (!curColumnName.equalsIgnoreCase(columnName)) continue;
                            this.readOnlyColumns.add(i);
                        }
                        startIndex = line.indexOf(34, endIndex + 1);
                        continue;
                    }
                    startIndex = -1;
                }
            } else if (line.matches(".*[Cc]olumn-value-file.*")) {
                int startIndex1;
                Integer columnIndex = -1;
                int fromIndex = 0;
                int endIndex = -1;
                int startIndex = line.indexOf(34, fromIndex);
                if (startIndex > (startIndex1 = line.indexOf(44, fromIndex))) {
                    int startIndex0 = line.indexOf(61, fromIndex);
                    String columnNumber = line.substring(startIndex0 + 1, startIndex1);
                    if ((columnNumber = columnNumber.trim()).equals("1")) {
                        columnIndex = 0;
                    } else if (columnNumber.equals("2")) {
                        columnIndex = 1;
                    } else if (columnNumber.equals("3")) {
                        columnIndex = 2;
                    }
                }
                TableColumn[] columns = this.table.getColumns();
                while (startIndex > 0) {
                    if ((endIndex = line.indexOf(34, ++startIndex)) > 0) {
                        if (columnIndex < 0) {
                            String columnName = line.substring(startIndex, endIndex);
                            for (int i = 0; i < columns.length; ++i) {
                                String curColumnName = columns[i].getText();
                                if (!curColumnName.equalsIgnoreCase(columnName)) continue;
                                columnIndex = i;
                            }
                            if (columnIndex < 0) {
                                if (columnName.equals("1")) {
                                    columnIndex = 0;
                                } else if (columnName.equals("2")) {
                                    columnIndex = 1;
                                } else if (columnName.equals("3")) {
                                    columnIndex = 2;
                                }
                            }
                        } else {
                            String columnValueFile = line.substring(startIndex, endIndex);
                            this.columnValueList.put(columnIndex, columnValueFile);
                        }
                        startIndex = line.indexOf(34, endIndex + 1);
                        continue;
                    }
                    startIndex = -1;
                }
            }
        }
    }

    private void setColumnWidth() {
        Point tableSize = this.table.getSize();
        int numColumn = this.table.getColumnCount();
        if (tableSize.x > 0 && numColumn > 0) {
            int width = tableSize.x / numColumn;
            for (int i = 0; i < numColumn; ++i) {
                TableColumn curColumn = this.table.getColumn(i);
                if (curColumn == null) continue;
                curColumn.setWidth(width - 2);
            }
        }
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Widget widget = event.widget;
                    if (widget == TableTextMultiPageEditor.this.table) {
                        this.selectionChanged();
                    }
                }

                private void selectionChanged() {
                }
            };
        }
        return this.selectionListener;
    }

    private void setDirty() {
        if (!this.isDirty) {
            this.doSaveTable();
        }
        this.isDirty = true;
    }

    class TableWidgetListener
    implements MouseListener,
    FocusListener,
    KeyListener,
    TraverseListener {
        private ControlEditor tableEditor;
        private TableCursor tableCursor;
        private Text tableText = null;
        private Combo tableCombo = null;
        private TableItem item = null;
        private int column = -1;
        private int finalColumn;
        private TableItem finalTableItem;
        private ArrayList<String> undoList = new ArrayList();

        public TableWidgetListener() {
            this.tableCursor = new TableCursor(TableTextMultiPageEditor.this.table, 0);
            this.tableEditor = new ControlEditor((Composite)this.tableCursor);
            this.tableEditor.grabHorizontal = true;
            this.tableEditor.grabVertical = true;
            Menu menu = new Menu((Decorations)TableTextMultiPageEditor.this.table.getShell(), 8);
            this.createPopupMenuItems(menu);
            TableTextMultiPageEditor.this.table.setMenu(menu);
            this.tableCursor.setMenu(menu);
        }

        public void dispose() {
            if (this.tableEditor != null) {
                this.tableEditor.dispose();
            }
            if (this.tableText != null) {
                this.tableText.dispose();
            }
            if (this.tableCombo != null) {
                this.tableCombo.dispose();
            }
            if (this.tableCursor != null) {
                this.tableCursor.dispose();
            }
            this.item = null;
        }

        private void createPopupMenuItems(Menu popUpMenu) {
            if (popUpMenu == null) {
                return;
            }
            popUpMenu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    Menu menu = (Menu)e.widget;
                    MenuItem[] items = menu.getItems();
                    int totalItems = items.length;
                    boolean enableInsert = !TableTextMultiPageEditor.this.readOnlyTable;
                    boolean enableDelete = !TableTextMultiPageEditor.this.readOnlyTable;
                    items[totalItems - 1].setEnabled(enableInsert);
                    items[totalItems - 2].setEnabled(enableDelete);
                }
            });
            MenuItem item = new MenuItem(popUpMenu, 8);
            item.setText("Insert Row");
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableItem curItem = TableWidgetListener.this.tableCursor.getRow();
                    int rowIndex = TableTextMultiPageEditor.this.table.indexOf(curItem);
                    TableWidgetListener.this.InsertNewRow(rowIndex, TableWidgetListener.this.tableCursor.getColumn());
                }
            });
            item = new MenuItem(popUpMenu, 8);
            item.setText("Delete Row");
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableItem curItem = TableWidgetListener.this.tableCursor.getRow();
                    int rowIndex = TableTextMultiPageEditor.this.table.indexOf(curItem);
                    TableWidgetListener.this.DeleteRow(rowIndex);
                }
            });
        }

        public void setClipboardContents(String aString) {
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            Object rtfFromWidget = clipboard.getContents((Transfer)TextTransfer.getInstance());
            Transfer[] dataTypes = new Transfer[]{TextTransfer.getInstance()};
            Object[] data = new Object[]{aString, rtfFromWidget};
            clipboard.setContents(data, dataTypes);
        }

        public String getClipboardContents() {
            String result = "";
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            Object textFromWidget = clipboard.getContents((Transfer)TextTransfer.getInstance());
            if (textFromWidget != null && textFromWidget instanceof String) {
                result = (String)textFromWidget;
            }
            return result;
        }

        private void createTextPopupMenuItems(Menu popUpMenu) {
            if (popUpMenu == null) {
                return;
            }
            popUpMenu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    Menu menu = (Menu)e.widget;
                    MenuItem[] items = menu.getItems();
                    String currentText = TableWidgetListener.this.tableText.getText();
                    String currentSelectedText = TableWidgetListener.this.tableText.getSelectionText();
                    String clipboardText = TableWidgetListener.this.getClipboardContents();
                    boolean enableCut = !TableTextMultiPageEditor.this.readOnlyTable && !currentSelectedText.isEmpty();
                    boolean enableCopy = !TableTextMultiPageEditor.this.readOnlyTable && !currentSelectedText.isEmpty();
                    boolean enablePaste = !TableTextMultiPageEditor.this.readOnlyTable && !clipboardText.isEmpty();
                    boolean enableDelete = !TableTextMultiPageEditor.this.readOnlyTable && !currentSelectedText.isEmpty();
                    boolean enableSelectAll = !TableTextMultiPageEditor.this.readOnlyTable && !currentText.isEmpty();
                    items[0].setEnabled(enableCut);
                    items[1].setEnabled(enableCopy);
                    items[2].setEnabled(enablePaste);
                    items[3].setEnabled(enableDelete);
                    items[5].setEnabled(enableSelectAll);
                }
            });
            MenuItem item = new MenuItem(popUpMenu, 8);
            item.setText("Cut");
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableWidgetListener.this.tableText.cut();
                }
            });
            item = new MenuItem(popUpMenu, 8);
            item.setText("Copy");
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableWidgetListener.this.tableText.copy();
                }
            });
            item = new MenuItem(popUpMenu, 8);
            item.setText("Paste");
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableWidgetListener.this.tableText.paste();
                }
            });
            item = new MenuItem(popUpMenu, 8);
            item.setText("Delete");
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String currentText = TableWidgetListener.this.tableText.getText();
                    String startString = "";
                    String endString = "";
                    Point selectPoint = TableWidgetListener.this.tableText.getSelection();
                    if (selectPoint.x > 0) {
                        startString = currentText.substring(0, selectPoint.x);
                    }
                    if (selectPoint.y < currentText.length()) {
                        endString = currentText.substring(selectPoint.y);
                    }
                    TableWidgetListener.this.tableText.setText(startString + endString);
                }
            });
            item = new MenuItem(popUpMenu, 2);
            item = new MenuItem(popUpMenu, 8);
            item.setText("Select All");
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableWidgetListener.this.tableText.selectAll();
                }
            });
            item = new MenuItem(popUpMenu, 2);
        }

        private void setTableCombo(String parameterFile) {
            if (this.tableCombo != null) {
                this.tableCombo.dispose();
            }
            this.tableCombo = new Combo((Composite)this.tableCursor, 4);
            TextFileReader parameters = new TextFileReader(parameterFile);
            String[] lines = new String[parameters.getTotalLines()];
            lines = parameters.getLines().toArray(lines);
            this.tableCombo.setItems(lines);
            this.tableCombo.setText(this.item.getText(this.column));
            this.finalColumn = this.column;
            this.finalTableItem = this.item;
            this.tableCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TableWidgetListener.this.finalTableItem.setText(TableWidgetListener.this.finalColumn, TableWidgetListener.this.tableCombo.getText());
                    TableTextMultiPageEditor.this.setDirty();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.tableEditor.setEditor((Control)this.tableCombo);
        }

        private void setTableText() {
            if (this.column != -1) {
                IProject project;
                IFile parameterFile;
                if (this.tableText != null) {
                    this.tableText.dispose();
                    this.undoList.clear();
                }
                if (this.tableCombo != null) {
                    this.tableCombo.dispose();
                }
                if (TableTextMultiPageEditor.this.readOnlyTable) {
                    return;
                }
                Iterator itr = TableTextMultiPageEditor.this.readOnlyColumns.iterator();
                while (itr.hasNext()) {
                    if ((Integer)itr.next() != this.column) continue;
                    return;
                }
                String columnValueFile = (String)TableTextMultiPageEditor.this.columnValueList.get(this.column);
                if (columnValueFile != null && !columnValueFile.isEmpty() && (parameterFile = (project = SDKUtil.getSDKProject()).getFile("resources" + File.separator + columnValueFile)).exists()) {
                    this.setTableCombo(parameterFile.getLocation().toOSString());
                    return;
                }
                this.tableText = new Text((Composite)this.tableCursor, 0);
                this.tableText.addFocusListener((FocusListener)this);
                this.tableText.setForeground(this.item.getForeground());
                this.tableText.setText(this.item.getText(this.column));
                Menu menu = new Menu((Decorations)this.tableText.getShell(), 8);
                this.createTextPopupMenuItems(menu);
                this.createPopupMenuItems(menu);
                this.tableText.setMenu(menu);
                this.tableEditor.setEditor((Control)this.tableText);
                this.tableText.selectAll();
                this.tableText.setFocus();
                this.tableText.forceFocus();
                this.tableCursor.setSelection(this.item, this.column);
                this.tableCursor.setVisible(true);
                this.tableCursor.setFocus();
                this.finalColumn = this.column;
                this.finalTableItem = this.item;
                this.tableText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        TableWidgetListener.this.finalTableItem.setText(TableWidgetListener.this.finalColumn, TableWidgetListener.this.tableText.getText());
                        TableTextMultiPageEditor.this.setDirty();
                    }
                });
                this.tableText.addVerifyListener(new VerifyListener(){

                    public void verifyText(VerifyEvent e) {
                        TableWidgetListener.this.undoList.add(TableWidgetListener.this.tableText.getText());
                    }
                });
                this.tableText.addTraverseListener((TraverseListener)this);
                this.tableText.addKeyListener((KeyListener)this);
            }
        }

        private void addNewTableRow() {
            if (this.item == null) {
                this.column = 0;
                this.InsertNewRow(TableTextMultiPageEditor.this.table.getItemCount(), this.column);
            }
        }

        private void InsertNewRow(int selectionIndex, int column) {
            int insertRow = selectionIndex + 1;
            if (insertRow > TableTextMultiPageEditor.this.table.getItemCount()) {
                insertRow = TableTextMultiPageEditor.this.table.getItemCount();
            }
            String[] emptyString = new String[]{"", ""};
            this.item = new TableItem(TableTextMultiPageEditor.this.table, 0, insertRow);
            this.item.setText(emptyString);
            this.tableCursor.setSelection(this.item, column);
            this.setTableText();
            TableTextMultiPageEditor.this.setDirty();
        }

        private void DeleteRow(int selectionIndex) {
            int index = selectionIndex;
            if (index > TableTextMultiPageEditor.this.table.getItemCount()) {
                return;
            }
            TableTextMultiPageEditor.this.table.remove(index);
            TableTextMultiPageEditor.this.setDirty();
        }

        private void goNextRows(int rowTogo, int columnIndex) {
            int rowIndex = TableTextMultiPageEditor.this.table.indexOf(this.item) + rowTogo;
            if (rowIndex < TableTextMultiPageEditor.this.table.getItemCount()) {
                this.tableCursor.setSelection(rowIndex, columnIndex);
                this.item = this.tableCursor.getRow();
                this.setTableText();
            } else {
                this.item = null;
                this.addNewTableRow();
            }
        }

        private void goUpRows(int rowTogo, int columnIndex) {
            int rowIndex = TableTextMultiPageEditor.this.table.indexOf(this.item) - rowTogo;
            if (rowIndex >= 0) {
                this.tableCursor.setSelection(rowIndex, columnIndex);
                this.item = this.tableCursor.getRow();
                this.setTableText();
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            Point point = new Point(e.x, e.y);
            this.item = this.tableCursor.getRow();
            if (this.item == null) {
                int oldX = point.x;
                point.x = 6;
                this.item = TableTextMultiPageEditor.this.table.getItem(point);
                point.x = oldX;
                this.addNewTableRow();
            }
            if (this.item != null) {
                this.column = this.tableCursor.getColumn();
                Rectangle rect = null;
                if (this.column == -1) {
                    for (int i = 0; i < TableTextMultiPageEditor.this.table.getColumnCount(); ++i) {
                        rect = this.item.getBounds(i);
                        if (!rect.contains(point)) continue;
                        this.column = i;
                        break;
                    }
                }
                this.setTableText();
            }
        }

        public void mouseUp(MouseEvent e) {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 0x1000001) {
                this.goUpRows(1, this.column);
            } else if (e.keyCode == 0x1000002) {
                this.goNextRows(1, this.column);
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.stateMask == 262144) {
                if (e.keyCode == 0x1000007) {
                    if (TableTextMultiPageEditor.this.table.getItemCount() > 0) {
                        this.column = 0;
                        this.tableCursor.setSelection(0, this.column);
                        this.item = this.tableCursor.getRow();
                        this.setTableText();
                    }
                } else if (e.keyCode == 0x1000008 && TableTextMultiPageEditor.this.table.getItemCount() > 0) {
                    this.column = TableTextMultiPageEditor.this.table.getColumnCount() - 1;
                    this.tableCursor.setSelection(TableTextMultiPageEditor.this.table.getItemCount() - 1, this.column);
                    this.item = this.tableCursor.getRow();
                    this.setTableText();
                }
            }
        }

        public void keyTraversed(TraverseEvent e) {
            switch (e.detail) {
                case 16: {
                    e.doit = false;
                    ++this.column;
                    if (this.column < TableTextMultiPageEditor.this.table.getColumnCount()) {
                        this.tableCursor.setSelection(this.item, this.column);
                        this.setTableText();
                        break;
                    }
                    this.column = 0;
                    this.goNextRows(1, this.column);
                    break;
                }
                case 8: {
                    e.doit = false;
                    if (this.column > 0) {
                        this.tableCursor.setSelection(this.item, --this.column);
                        this.setTableText();
                        break;
                    }
                    this.column = TableTextMultiPageEditor.this.table.getColumnCount() - 1;
                    int rowIndex = TableTextMultiPageEditor.this.table.indexOf(this.item);
                    if (--rowIndex >= 0) {
                        this.goUpRows(1, this.column);
                        break;
                    }
                    e.doit = true;
                    break;
                }
            }
        }
    }
}

