/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.model;

import com.netiq.sentinel.sdk.XMLFileReader;
import java.util.ArrayList;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;

public class PlatformQueryData {
    private static String FName = "PlatformQueryConfig.xml";
    private static Document File;
    private static XMLFileReader Reader;

    public static ArrayList<String> getSupportedQueryTypes(String platform) {
        ArrayList<String> queryDataTypes = null;
        try {
            queryDataTypes = Reader.getNodeList("//platforms/platform[@name='" + platform + "']/query-data-type/@name");
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return queryDataTypes;
    }

    public static String[] getDisplayPlatforms() {
        ArrayList<Object> platforms = new ArrayList();
        try {
            platforms = Reader.getNodeList("//platforms/platform/@name");
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return platforms.toArray(new String[0]);
    }

    public static String[] getAntPlatforms() {
        ArrayList<Object> platforms = new ArrayList();
        try {
            platforms = Reader.getNodeList("//platforms/platform/@reference-name");
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return platforms.toArray(new String[0]);
    }

    public static String getAntPlatform(String displayName) {
        String platform = displayName;
        try {
            platform = Reader.getString("//platforms/platform[@name='" + displayName + "']/@reference-name");
            if (platform == null || platform.length() == 0) {
                platform = displayName;
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return platform;
    }

    public static String getDefaultPlatform() {
        String platform = "Sentinel 7 Only";
        try {
            String value = Reader.getString("//platforms/platform[@default='true']/@name");
            if (value != null && value.length() > 0) {
                platform = value;
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return platform;
    }

    public static boolean getRddSupported(String platform, String queryDataType) {
        Boolean rddSupported = new Boolean(false);
        try {
            String value = Reader.getString("//platforms/platform[@name='" + platform + "']/query-data-type[@name='" + queryDataType + "']/@rdd-supported");
            if (value != null && value.length() > 0 && value.equalsIgnoreCase("true")) {
                rddSupported = new Boolean(value);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return rddSupported;
    }

    public static boolean getEventTypeSupported(String platform, String queryDataType) {
        Boolean eventTypeSupported = new Boolean(false);
        try {
            String value = Reader.getString("//platforms/platform[@name='" + platform + "']/query-data-type[@name='" + queryDataType + "']/@event-type-supported");
            if (value != null && value.length() > 0 && value.equalsIgnoreCase("true")) {
                eventTypeSupported = new Boolean(value);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return eventTypeSupported;
    }

    static {
        Reader = new XMLFileReader(FName);
        File = Reader.getDocment();
    }
}

