/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum PluginType {
    REPORT(0, "Report"),
    ACTION(1, "Action"),
    COLLECTOR(2, "Collector"),
    SOLUTION(3, "Solution"),
    RDD(4, "RDD");

    public static final int REPORT_VALUE = 0;
    public static final int ACTION_VALUE = 1;
    public static final int COLLECTOR_VALUE = 2;
    public static final int SOLUTION_VALUE = 3;
    public static final int RDD_VALUE = 4;
    private static final PluginType[] VALUES_ARRAY;
    public static final List<PluginType> VALUES;
    private final int value;
    private final String name;

    public static PluginType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            PluginType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static PluginType get(int value) {
        switch (value) {
            case 0: {
                return REPORT;
            }
            case 1: {
                return ACTION;
            }
            case 2: {
                return COLLECTOR;
            }
            case 3: {
                return SOLUTION;
            }
            case 4: {
                return RDD;
            }
        }
        return null;
    }

    private PluginType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getNature() {
        switch (this.value) {
            case 0: {
                return "com.netiq.sentinel.sdk.SentinelReportProjectNature";
            }
            case 1: {
                return "com.netiq.sentinel.sdk.SentinelActionProjectNature";
            }
            case 2: {
                return "com.netiq.sentinel.sdk.SentinelCollectorProjectNature";
            }
            case 3: {
                return "com.netiq.sentinel.sdk.SentinelSolutionProjectNature";
            }
            case 4: {
                return "com.netiq.sentinel.sdk.SentinelRDDProjectNature";
            }
        }
        return null;
    }

    static {
        VALUES_ARRAY = new PluginType[]{REPORT, ACTION, COLLECTOR, SOLUTION, RDD};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

