/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.model;

import com.netiq.sentinel.sdk.model.PluginImages;
import com.netiq.sentinel.sdk.model.PluginType;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IActionFilter;

public class SentinelPlugin
implements IActionFilter {
    private IFolder m_pluginFolder;
    private IFile m_buildFile;
    private PluginType m_pluginType;

    public SentinelPlugin(IFolder pluginFolder, IFile buildFile, PluginType pluginType) {
        this.m_pluginFolder = pluginFolder;
        this.m_buildFile = buildFile;
        this.m_pluginType = pluginType;
    }

    public String getPluginName() {
        return this.m_pluginFolder.getName();
    }

    public IFile getBuildFile() {
        return this.m_buildFile;
    }

    public PluginType getPluginType() {
        return this.m_pluginType;
    }

    public IFolder getFolder() {
        return this.m_pluginFolder;
    }

    public Image getImage() {
        if (this.m_pluginType.equals((Object)PluginType.ACTION)) {
            return PluginImages.getActionImage();
        }
        if (this.m_pluginType.equals((Object)PluginType.REPORT)) {
            return PluginImages.getReportImage();
        }
        if (this.m_pluginType.equals((Object)PluginType.COLLECTOR)) {
            return PluginImages.getCollectorImage();
        }
        if (this.m_pluginType.equals((Object)PluginType.SOLUTION)) {
            return PluginImages.getSolutionImage();
        }
        if (this.m_pluginType.equals((Object)PluginType.RDD)) {
            return PluginImages.getRDDImage();
        }
        return null;
    }

    public boolean testAttribute(Object target, String locName, String value) {
        if (locName.equalsIgnoreCase("plugin_type")) {
            if (PluginType.COLLECTOR.getName().equalsIgnoreCase(value) && this.m_pluginType.equals((Object)PluginType.COLLECTOR)) {
                return true;
            }
            if (PluginType.ACTION.getName().equalsIgnoreCase(value) && this.m_pluginType.equals((Object)PluginType.ACTION)) {
                return true;
            }
            if (PluginType.REPORT.getName().equalsIgnoreCase(value) && this.m_pluginType.equals((Object)PluginType.REPORT)) {
                return true;
            }
            if (PluginType.SOLUTION.getName().equalsIgnoreCase(value) && this.m_pluginType.equals((Object)PluginType.SOLUTION)) {
                return true;
            }
            if (PluginType.RDD.getName().equalsIgnoreCase(value) && this.m_pluginType.equals((Object)PluginType.RDD)) {
                return true;
            }
        } else if (locName.equalsIgnoreCase("plugin_version") && this.getFolder().getName().equalsIgnoreCase("6.1")) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBuildNumber() {
        IFile file = this.m_pluginFolder.getFile("release.properties");
        if (!file.exists()) {
            return "1";
        }
        Properties relProps = new Properties();
        try {
            file.refreshLocal(1, null);
            relProps.load(file.getContents());
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)"test", (String)e.getLocalizedMessage());
        }
        String buildNumber = null;
        if (relProps != null) {
            buildNumber = relProps.getProperty("build.number");
        }
        if (buildNumber == null || buildNumber.length() == 0) {
            return "1";
        }
        return buildNumber;
    }

    public String getVersionString() {
        return String.format("%s_%sr%s", this.m_pluginFolder.getParent().getName(), this.m_pluginFolder.getName(), this.getBuildNumber());
    }
}

