/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.prefs;

import com.netiq.sentinel.sdk.Messages;
import com.netiq.sentinel.sdk.SDKConstants;
import com.netiq.sentinel.sdk.SDKUtil;
import com.netiq.sentinel.sdk.actions.BuildType;
import com.netiq.sentinel.sdk.actions.CreateLuceneConnectionAction;
import com.netiq.sentinel.sdk.actions.IActionCompleteListener;
import com.netiq.sentinel.sdk.model.Connection;
import com.netiq.sentinel.sdk.model.PluginImages;
import com.netiq.sentinel.sdk.util.Log;
import com.netiq.sentinel.sdk.widgets.OutputProgressMonitorDialog;
import com.netiq.sentinel.sdk.wizards.NewSentinelPluginWizard;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ConnectionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener,
ISelectionChangedListener,
IActionCompleteListener {
    private IPreferenceStore store;
    private File m_connectionsDir;
    private IFile m_buildFile;
    private String m_connectionsPath;
    private String m_connectionError;
    private boolean m_connectionCompleted;
    private TableViewer tableViewer;
    private ToolItem addConnectionButton;
    private ToolItem deleteConnectionButton;
    private ToolItem testConnectionButton;
    private ToolItem editConnectionButton;
    private ToolBar toolbar;
    private ConnectionsTable m_connectionsTable;
    private ArrayList<File> m_connectionsToDelete = new ArrayList();
    private HashMap<String, Connection> m_connectionsToAdd = new HashMap();
    private HashMap<String, Properties> m_connectionsMap = new HashMap();
    private static String CONNECTION_PROP_FILE = File.separator + "config" + File.separator + "sentinelreport.properties";
    private FileFilter directoryFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() && !ConnectionsPreferencePage.this.m_connectionsToDelete.contains(file);
        }
    };

    public ConnectionsPreferencePage() {
        this.initialize();
    }

    public ConnectionsPreferencePage(String title) {
        super(title);
        this.initialize();
    }

    public ConnectionsPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
        this.initialize();
    }

    private void initialize() {
        this.store = this.getPreferenceStore();
        this.m_connectionsPath = System.getProperty(SDKConstants.USER_HOME) + File.separator + ".netiq" + File.separator + "pluginsdk" + File.separator + "connections";
        this.m_connectionsDir = new File(this.m_connectionsPath);
        this.getBuildFile();
        this.noDefaultAndApplyButton();
    }

    public void wireupContextSensitiveHelp() {
    }

    protected Control createContents(Composite parent) {
        IPreferenceStore preferenceStore = this.store;
        this.setPreferenceStore(preferenceStore);
        Composite tmp = new Composite(parent, 0);
        tmp.setLayout((Layout)new GridLayout());
        tmp.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(tmp, 0);
        GridLayout layout = new GridLayout();
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        this.createConnectionsTable(composite);
        this.fillConnectionsTable();
        this.addDescriptionLabel(composite);
        this.wireupContextSensitiveHelp();
        return parent;
    }

    public void init(IWorkbench workbench) {
    }

    private void fillConnectionsTable() {
        try {
            this.m_connectionsTable = new ConnectionsTable();
            this.m_connectionsTable.fillTable();
            this.tableViewer.setInput((Object)this.m_connectionsTable);
        }
        catch (Exception e) {
            Log.error(e);
        }
    }

    private void createConnectionsTable(Composite parent) {
        this.addToolbarAndButtons(parent);
        TableColumnLayout columnLayout = new TableColumnLayout();
        Composite tableComp = new Composite(parent, 0);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        tableComp.setLayout((Layout)columnLayout);
        Table table = new Table(tableComp, 67587);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.getTable().setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewerColumn nameColumn = new TableViewerColumn(this.tableViewer, 16384);
        columnLayout.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        nameColumn.getColumn().setText(Messages.Preference_Name);
        TableViewerColumn platformColumn = new TableViewerColumn(this.tableViewer, 16384);
        platformColumn.getColumn().setText(Messages.Preference_Platform);
        columnLayout.setColumnData((Widget)platformColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(80));
        TableViewerColumn ipColumn = new TableViewerColumn(this.tableViewer, 16384);
        ipColumn.getColumn().setText(Messages.Preference_Server);
        columnLayout.setColumnData((Widget)ipColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        this.addConnectionButton.addSelectionListener((SelectionListener)this);
        this.deleteConnectionButton.addSelectionListener((SelectionListener)this);
        this.testConnectionButton.addSelectionListener((SelectionListener)this);
        this.editConnectionButton.addSelectionListener((SelectionListener)this);
        this.tableViewer.getTable().addSelectionListener((SelectionListener)this);
        this.tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127 && ConnectionsPreferencePage.this.deleteConnectionButton.isEnabled()) {
                    ConnectionsPreferencePage.this.deleteConnections();
                }
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new ConnectionContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ConnectionLabelProvider());
    }

    private void addToolbarAndButtons(Composite parent) {
        Composite toolBarComposite = new Composite(parent, 0);
        toolBarComposite.setLayoutData((Object)new GridData(128));
        toolBarComposite.setLayout((Layout)new FillLayout(256));
        this.toolbar = new ToolBar(toolBarComposite, 0x800100);
        this.addConnectionButton = new ToolItem(this.toolbar, 0x800000);
        this.addConnectionButton.setImage(PluginImages.getAddImage());
        this.addConnectionButton.setToolTipText(Messages.Preference_AddConnection);
        this.deleteConnectionButton = new ToolItem(this.toolbar, 0x800000);
        this.deleteConnectionButton.setImage(PluginImages.getDeleteImage());
        this.deleteConnectionButton.setToolTipText(Messages.Preference_DeleteConnection);
        this.deleteConnectionButton.setEnabled(false);
        this.editConnectionButton = new ToolItem(this.toolbar, 0x800000);
        this.editConnectionButton.setImage(PluginImages.getEditImage());
        this.editConnectionButton.setToolTipText(Messages.Preference_EditConnection);
        this.editConnectionButton.setEnabled(false);
        this.testConnectionButton = new ToolItem(this.toolbar, 0x800000);
        this.testConnectionButton.setImage(PluginImages.getTestImage());
        this.testConnectionButton.setToolTipText(Messages.Preference_TestConnection);
        this.testConnectionButton.setEnabled(false);
    }

    private void addDescriptionLabel(Composite container) {
        Text l = new Text(container, 64);
        l.setEditable(false);
        l.setText(Messages.Preference_ConnectionDescription);
        GridData data = new GridData();
        data.heightHint = 100;
        data.widthHint = 375;
        l.setLayoutData((Object)data);
    }

    public void performApply() {
        super.performApply();
        this.tableViewer.setInput((Object)this.m_connectionsTable);
    }

    public boolean performOk() {
        for (File connection : this.m_connectionsToDelete) {
            if (!connection.exists() || !connection.isDirectory()) continue;
            ConnectionsPreferencePage.deleteDir(connection);
        }
        if (this.m_connectionsToAdd.size() > 0) {
            OutputProgressMonitorDialog pmd = new OutputProgressMonitorDialog(this.getShell());
            final CreateLuceneConnectionAction action = new CreateLuceneConnectionAction();
            action.setOutputStreamListener(pmd);
            action.setCompletionListener(this);
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(final IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                    try {
                        Collection connections = ConnectionsPreferencePage.this.m_connectionsToAdd.values();
                        if (connections != null && ConnectionsPreferencePage.this.getBuildFile() != null) {
                            for (final Connection connection : connections) {
                                ConnectionsPreferencePage.this.m_connectionCompleted = false;
                                ConnectionsPreferencePage.this.m_connectionError = null;
                                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        monitor.subTask(NLS.bind((String)Messages.Preference_CreatingConnection, (Object)connection.getConnectionName()));
                                        action.run(ConnectionsPreferencePage.this.m_buildFile, connection.getArguments(BuildType.CREATE_CONNECTION.getTarget()));
                                    }
                                });
                                while (!ConnectionsPreferencePage.this.m_connectionCompleted && !monitor.isCanceled()) {
                                    Thread.sleep(2000L);
                                }
                                if (!monitor.isCanceled()) continue;
                                ConnectionsPreferencePage.this.deleteCreatedConnections();
                            }
                            ConnectionsPreferencePage.this.m_connectionsToAdd.clear();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            };
            try {
                pmd.run(true, false, operation);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.fillConnectionsTable();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.addConnectionButton == e.widget) {
            NewSentinelPluginWizard wizard = new NewSentinelPluginWizard();
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.setHelpAvailable(false);
            dialog.create();
            wizard.sizeAndCenter(dialog);
            int dialogRc = dialog.open();
            if (dialogRc != 0) {
                return;
            }
            Connection connection = wizard.getConnectionPageInfo();
            if (connection != null) {
                if (connection.getConnectionToOverwrite() != null) {
                    this.m_connectionsToDelete.add(connection.getConnectionToOverwrite());
                }
                this.m_connectionsToAdd.put(connection.getConnectionName(), connection);
            }
            this.tableViewer.setInput((Object)this.m_connectionsTable);
        } else if (this.editConnectionButton == e.widget) {
            TableItem[] selections = this.tableViewer.getTable().getSelection();
            NewSentinelPluginWizard wizard = new NewSentinelPluginWizard(true, selections[0].getText());
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.setHelpAvailable(false);
            dialog.create();
            wizard.sizeAndCenter(dialog);
            int dialogRc = dialog.open();
            if (dialogRc != 0) {
                return;
            }
            Connection connection = wizard.getConnectionPageInfo();
            if (connection != null) {
                if (connection.getConnectionToOverwrite() != null) {
                    this.m_connectionsToDelete.add(connection.getConnectionToOverwrite());
                }
                this.m_connectionsToAdd.put(connection.getConnectionName(), connection);
            }
            this.tableViewer.setInput((Object)this.m_connectionsTable);
            this.deleteConnections();
        } else if (this.deleteConnectionButton == e.widget) {
            this.deleteConnections();
        } else if (this.testConnectionButton == e.widget) {
            this.testConnections();
        } else if (this.tableViewer.getTable() == e.widget) {
            TableItem[] selections = this.tableViewer.getTable().getSelection();
            this.deleteConnectionButton.setEnabled(false);
            this.testConnectionButton.setEnabled(false);
            this.editConnectionButton.setEnabled(false);
            if (selections != null && selections.length > 0) {
                this.deleteConnectionButton.setEnabled(true);
                this.editConnectionButton.setEnabled(true);
            }
            if (selections != null && selections.length == 1) {
                if (selections[0].getData() instanceof File) {
                    this.testConnectionButton.setEnabled(true);
                    this.testConnectionButton.setToolTipText(Messages.Preference_TestConnection);
                } else {
                    this.testConnectionButton.setToolTipText(Messages.Preference_TestConnectionCreate);
                }
            }
        }
    }

    private void deleteCreatedConnections() {
        Collection<Connection> connections = this.m_connectionsToAdd.values();
        File[] connectionDirs = this.m_connectionsDir.listFiles(this.directoryFilter);
        for (Connection connection : connections) {
            for (File dir : connectionDirs) {
                if (!dir.getName().equalsIgnoreCase(connection.getConnectionName())) continue;
                ConnectionsPreferencePage.deleteDir(dir);
            }
        }
    }

    private void deleteCreatedConnection(Connection connection) {
        File[] connectionDirs;
        for (File dir : connectionDirs = this.m_connectionsDir.listFiles(this.directoryFilter)) {
            if (!dir.getName().equalsIgnoreCase(connection.getConnectionName())) continue;
            ConnectionsPreferencePage.deleteDir(dir);
        }
    }

    private void deleteConnections() {
        TableItem[] selections = this.tableViewer.getTable().getSelection();
        if (selections != null && selections.length > 0) {
            for (TableItem ti : selections) {
                if (ti.getData() instanceof File) {
                    File connection = (File)ti.getData();
                    this.m_connectionsToDelete.add(connection);
                    this.m_connectionsToAdd.remove(connection.getName());
                    continue;
                }
                if (!(ti.getData() instanceof Connection)) continue;
                this.m_connectionsToAdd.remove(((Connection)ti.getData()).getConnectionName());
            }
            try {
                this.tableViewer.setInput((Object)this.m_connectionsTable);
            }
            catch (Exception je) {
                Log.error(je);
            }
        }
        this.setButtonStates();
    }

    private void testConnections() {
        TableItem[] selections = this.tableViewer.getTable().getSelection();
        if (selections != null && selections.length == 1) {
            for (TableItem ti : selections) {
                String name;
                String address;
                String platform;
                if (ti.getData() instanceof File) {
                    File dir = (File)ti.getData();
                    Properties props = SDKUtil.loadProperties(dir.getAbsolutePath() + File.separator + "config" + File.separator + "sentinelreport.properties");
                    platform = this.convertPlatformToDisplayString(props.getProperty("sentinel.sdk.targettype"));
                    address = props.getProperty("activemq.ip.server");
                    name = dir.getName();
                } else {
                    if (!(ti.getData() instanceof Connection)) continue;
                    platform = this.convertPlatformToDisplayString(((Connection)ti.getData()).getTargetPlatform());
                    address = ((Connection)ti.getData()).getServerIP();
                    name = ((Connection)ti.getData()).getConnectionName();
                }
                String targetPlatform = "_testSLM";
                if (platform != null) {
                    if (platform.equalsIgnoreCase(SDKConstants.SENTINEL_PLATFORM) || platform.equalsIgnoreCase(SDKConstants.SENTINEL7_PLATFORM)) {
                        targetPlatform = "_testSentinel";
                    } else if (platform.equalsIgnoreCase(SDKConstants.SENTINELRD_PLATFORM)) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.CreateLuceneConnectionPage_SentinelRD, (String)Messages.Preference_TestConnection_SentinelRD);
                        continue;
                    }
                }
                String sdkRoot = SDKUtil.getSDKProject().getProjectRelativePath() + ".." + File.separator;
                if (SDKUtil.isWindows()) {
                    sdkRoot = sdkRoot + File.separator;
                }
                String tmpltver = ".." + File.separator + "2011.1";
                final String fTarget = String.format("%s %s\"%s\" %s\"%s\" %s\"%s\"", targetPlatform, "-Dsdkroot=", sdkRoot, "-Dtmpltver=", tmpltver, "-Dconnectionname=", name);
                final String fPlatform = platform;
                final String fAddress = address;
                final String fName = name;
                OutputProgressMonitorDialog pmd = new OutputProgressMonitorDialog(this.getShell());
                final CreateLuceneConnectionAction action = new CreateLuceneConnectionAction();
                action.setOutputStreamListener(pmd);
                action.setCompletionListener(this);
                IRunnableWithProgress operation = new IRunnableWithProgress(){

                    public void run(final IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                        try {
                            if (ConnectionsPreferencePage.this.getBuildFile() != null) {
                                ConnectionsPreferencePage.this.m_connectionCompleted = false;
                                ConnectionsPreferencePage.this.m_connectionError = null;
                                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        monitor.subTask(NLS.bind((String)Messages.Preference_TestingConnection, (Object)fName));
                                        action.run(ConnectionsPreferencePage.this.m_buildFile, fTarget);
                                    }
                                });
                                while (!ConnectionsPreferencePage.this.m_connectionCompleted && !monitor.isCanceled()) {
                                    Thread.sleep(2000L);
                                }
                                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (ConnectionsPreferencePage.this.m_connectionError != null) {
                                            Object[] args = new String[]{fPlatform, fAddress};
                                            MessageDialog.openError((Shell)ConnectionsPreferencePage.this.getShell(), (String)Messages.CreateLuceneConnection_Title, (String)NLS.bind((String)Messages.Preference_ConnectionTestFailed, (Object[])args));
                                        } else {
                                            Object[] args = new String[]{fPlatform, fAddress};
                                            MessageDialog.openInformation((Shell)ConnectionsPreferencePage.this.getShell(), (String)Messages.CreateLuceneConnection_Title, (String)NLS.bind((String)Messages.Preference_ConnectionTestPassed, (Object[])args));
                                        }
                                    }
                                });
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                };
                try {
                    pmd.run(true, false, operation);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private IFile getBuildFile() {
        if (this.m_buildFile == null && SDKUtil.getSDKProject() != null) {
            IProject project = SDKUtil.getSDKProject();
            this.m_buildFile = project.getFile("resources" + File.separator + "connection.xml");
            if (this.m_buildFile == null || !this.m_buildFile.exists()) {
                this.setErrorMessage(Messages.CreateLuceneConnection_NoBuildFile);
            }
        }
        return this.m_buildFile;
    }

    private String convertPlatformToDisplayString(String platform) {
        if (platform == null) {
            return "";
        }
        if (platform.equalsIgnoreCase(SDKConstants.SENTINEL_PLATFORM)) {
            return Messages.CreateLuceneConnectionPage_Sentinel701;
        }
        if (platform.equalsIgnoreCase(SDKConstants.SENTINEL7_PLATFORM)) {
            return Messages.CreateLuceneConnectionPage_Sentinel7;
        }
        if (platform.equalsIgnoreCase(SDKConstants.SENTINELRD_PLATFORM)) {
            return Messages.CreateLuceneConnectionPage_SentinelRD;
        }
        return Messages.CreateLuceneConnectionPage_LogManager;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = ConnectionsPreferencePage.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public void setButtonStates() {
        if (null != this.m_connectionsTable) {
            this.deleteConnectionButton.setEnabled(false);
            this.testConnectionButton.setEnabled(false);
            this.editConnectionButton.setEnabled(false);
        } else {
            this.deleteConnectionButton.setEnabled(true);
            this.testConnectionButton.setEnabled(true);
            this.editConnectionButton.setEnabled(true);
        }
    }

    @Override
    public void completed(final String error) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!ConnectionsPreferencePage.this.tableViewer.getControl().isDisposed()) {
                    ConnectionsPreferencePage.this.tableViewer.setInput((Object)ConnectionsPreferencePage.this.m_connectionsTable);
                }
                ConnectionsPreferencePage.this.m_connectionCompleted = true;
                ConnectionsPreferencePage.this.m_connectionError = error;
            }
        });
    }

    public class ConnectionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        public String getColumnText(Object element, int columnIndex) {
            String returnString = null;
            if (element instanceof File) {
                File file = (File)element;
                Properties props = (Properties)ConnectionsPreferencePage.this.m_connectionsMap.get(file.getName());
                if (props == null) {
                    String propFile = ConnectionsPreferencePage.this.m_connectionsPath + File.separator + file.getName() + CONNECTION_PROP_FILE;
                    props = SDKUtil.loadProperties(propFile);
                    ConnectionsPreferencePage.this.m_connectionsMap.put(file.getName(), props);
                }
                if (columnIndex == 0) {
                    returnString = ((File)element).getName();
                } else {
                    if (columnIndex == 1) {
                        return ConnectionsPreferencePage.this.convertPlatformToDisplayString((String)props.get(SDKConstants.PREF_CONNECTION_TARGET));
                    }
                    if (columnIndex == 2) {
                        return (String)props.get(SDKConstants.PREF_CONNECTION_IP);
                    }
                }
                return returnString;
            }
            if (element instanceof Connection) {
                Connection connection = (Connection)element;
                if (columnIndex == 0) {
                    return connection.getConnectionName();
                }
                if (columnIndex == 1) {
                    return ConnectionsPreferencePage.this.convertPlatformToDisplayString(connection.getTargetPlatform());
                }
                if (columnIndex == 2) {
                    return connection.getServerIP();
                }
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }
    }

    class ConnectionContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            ArrayList<File> elements = new ArrayList<File>();
            if (!ConnectionsPreferencePage.this.m_connectionsTable.isEmpty()) {
                File[] existing;
                for (File file : existing = ConnectionsPreferencePage.this.m_connectionsTable.getConnections()) {
                    elements.add(file);
                }
            }
            if (ConnectionsPreferencePage.this.m_connectionsToAdd.size() > 0) {
                elements.addAll(ConnectionsPreferencePage.this.m_connectionsToAdd.values());
            }
            if (elements.size() == 0) {
                return new Object[0];
            }
            return elements.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class ConnectionsTable {
        ConnectionsTable() {
        }

        public void fillTable() {
        }

        public boolean isEmpty() {
            return ConnectionsPreferencePage.this.m_connectionsDir == null || this.getConnections().length == 0;
        }

        public File[] getConnections() {
            File[] connections = ConnectionsPreferencePage.this.m_connectionsDir.listFiles(ConnectionsPreferencePage.this.directoryFilter);
            if (connections == null) {
                connections = new File[]{};
            }
            return connections;
        }
    }
}

