/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.prefs;

import com.netiq.sentinel.sdk.Activator;
import com.netiq.sentinel.sdk.Messages;
import com.netiq.sentinel.sdk.SDKConstants;
import com.netiq.sentinel.sdk.SDKUtil;
import com.netiq.sentinel.sdk.widgets.HistoryTextField;
import com.netiq.sentinel.sdk.widgets.InfoWidget;
import java.io.File;
import java.util.Properties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class SentinelSDKPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
ModifyListener {
    private static String AUTHOR_FIELDKEY = "AuthorKey";
    private static String IREPORT_HOMEDIR_FIELDKEY = "IReportHomeDirKey";
    private static String OPENOFFICE_HOMEDIR_FIELDKEY = "OpenOfficeHomeDirKey";
    private HistoryTextField m_pluginAuthor;
    private HistoryTextField m_iReportHomeDir;
    private HistoryTextField m_openOfficeHomeDir;
    private Button m_iReportBtn;
    private Button m_openOfficeBtn;
    private Button m_hideEmptyPluginFolders;
    private StringBuffer devPropFileName = new StringBuffer();
    private StringBuffer iReportPropFileName = new StringBuffer();
    private StringBuffer ooPropFileName = new StringBuffer();
    private Properties devProps;
    private Properties iReportProps;
    private Properties openOfficeProps;
    private static String DEV_PROP_FILE = File.separator + ".netiq" + File.separator + "pluginsdk" + File.separator + "dev.properties";
    private static String IREPORT_PROP_FILE = File.separator + ".netiq" + File.separator + "pluginsdk" + File.separator + "iReport.properties";
    private static String OPENOFFICE_PROP_FILE = File.separator + ".netiq" + File.separator + "pluginsdk" + File.separator + "oo.properties";

    public SentinelSDKPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.iReportPropFileName.append(System.getProperty(SDKConstants.USER_HOME));
        this.iReportPropFileName.append(IREPORT_PROP_FILE);
        this.ooPropFileName.append(System.getProperty(SDKConstants.USER_HOME));
        this.ooPropFileName.append(OPENOFFICE_PROP_FILE);
        this.devPropFileName.append(System.getProperty(SDKConstants.USER_HOME));
        this.devPropFileName.append(DEV_PROP_FILE);
        this.iReportProps = SDKUtil.loadProperties(this.iReportPropFileName.toString());
        this.openOfficeProps = SDKUtil.loadProperties(this.ooPropFileName.toString());
        this.devProps = SDKUtil.loadProperties(this.devPropFileName.toString());
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite area = parent;
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new FormLayout());
        container.setLayoutData((Object)this.createGridData(200, 200, true, true));
        this.addIReportPreference(container);
        this.addOpenOfficePreference(container);
        this.addAuthorPreference(container);
        this.addHideEmptyFolderPreference(container);
        return area;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.getPreferenceStore().setDefault(SDKConstants.PREF_HIDE_EMPTY_PLUGIN_FOLDERS, false);
        if (this.m_hideEmptyPluginFolders != null && !this.m_hideEmptyPluginFolders.isDisposed()) {
            this.m_hideEmptyPluginFolders.setSelection(false);
        }
        super.performDefaults();
    }

    private boolean validatePage() {
        this.setErrorMessage(null);
        this.setValid(true);
        return true;
    }

    public boolean performOk() {
        super.performOk();
        if (this.validatePage()) {
            if (this.m_iReportHomeDir.getComboControl().getItemCount() < 1) {
                Activator.getDefault().getPreferenceStore().setValue(IREPORT_HOMEDIR_FIELDKEY, "");
            }
            this.m_iReportHomeDir.saveToHistory();
            Activator.getDefault().getPreferenceStore().setValue(SDKConstants.PREF_IREPORT_PATH, this.m_iReportHomeDir.getText());
            Activator.getDefault().getPreferenceStore().setDefault(SDKConstants.PREF_IREPORT_PATH, this.m_iReportHomeDir.getText());
            this.iReportProps.setProperty(SDKConstants.PREF_IREPORT_PATH, this.m_iReportHomeDir.getText());
            SDKUtil.saveProperties(this.iReportPropFileName.toString(), this.iReportProps);
            if (this.m_openOfficeHomeDir.getComboControl().getItemCount() < 1) {
                Activator.getDefault().getPreferenceStore().setValue(OPENOFFICE_HOMEDIR_FIELDKEY, "");
            }
            this.m_openOfficeHomeDir.saveToHistory();
            Activator.getDefault().getPreferenceStore().setValue(SDKConstants.PREF_OPENOFFICE_PATH, this.m_openOfficeHomeDir.getText());
            Activator.getDefault().getPreferenceStore().setDefault(SDKConstants.PREF_OPENOFFICE_PATH, this.m_openOfficeHomeDir.getText());
            this.openOfficeProps.setProperty(SDKConstants.PREF_OPENOFFICE_PATH, this.m_openOfficeHomeDir.getText());
            SDKUtil.saveProperties(this.ooPropFileName.toString(), this.openOfficeProps);
            if (this.m_pluginAuthor.getComboControl().getItemCount() < 1) {
                Activator.getDefault().getPreferenceStore().setValue(AUTHOR_FIELDKEY, "");
            }
            this.m_pluginAuthor.saveToHistory();
            Activator.getDefault().getPreferenceStore().setValue(SDKConstants.PREF_PLUGIN_AUTHOR, this.m_pluginAuthor.getText());
            this.devProps.setProperty(SDKConstants.PREF_PLUGIN_AUTHOR, this.m_pluginAuthor.getText());
            SDKUtil.saveProperties(this.devPropFileName.toString(), this.devProps, SDKUtil.DEV_PROP_COMMENT);
            Activator.getDefault().getPreferenceStore().setValue(SDKConstants.PREF_HIDE_EMPTY_PLUGIN_FOLDERS, this.m_hideEmptyPluginFolders.getSelection());
            return true;
        }
        return false;
    }

    protected void createFieldEditors() {
    }

    private void addIReportPreference(Composite container) {
        Label l = new Label(container, 0);
        l.setText(Messages.Preference_IReportHomeDir);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(50, 0);
        l.setLayoutData((Object)data);
        this.m_iReportHomeDir = new HistoryTextField(container, IREPORT_HOMEDIR_FIELDKEY);
        this.m_iReportHomeDir.addModifyListener(this);
        data = new FormData();
        data.top = new FormAttachment((Control)l, 5);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -100);
        this.m_iReportHomeDir.setLayoutData(data);
        this.m_iReportHomeDir.selectFirstInList();
        this.m_iReportBtn = new Button(container, 8);
        this.m_iReportBtn.setText(Messages.Browse);
        this.m_iReportBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                String dir = SentinelSDKPreferencePage.this.browseForDirectory(Messages.Preference_IReportHomeDirExample);
                if (dir != null && dir.length() > 0) {
                    SentinelSDKPreferencePage.this.m_iReportHomeDir.setText(dir);
                }
            }
        });
        data = new FormData();
        data.top = new FormAttachment((Control)l, 5);
        data.left = new FormAttachment((Control)this.m_iReportHomeDir, 5);
        this.m_iReportBtn.setLayoutData((Object)data);
        InfoWidget widg = new InfoWidget(container, Messages.Preference_IReportHomeDirTitle, Messages.Preference_IReportHomeDirExample);
        data = new FormData();
        data.top = new FormAttachment((Control)l, 5);
        data.left = new FormAttachment((Control)this.m_iReportBtn, 5);
        widg.setLayoutData(data);
        this.m_iReportHomeDir.getComboControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (SentinelSDKPreferencePage.this.validatePage()) {
                    SentinelSDKPreferencePage.this.setValid(true);
                } else {
                    SentinelSDKPreferencePage.this.setValid(false);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (SentinelSDKPreferencePage.this.validatePage()) {
                    SentinelSDKPreferencePage.this.setValid(true);
                } else {
                    SentinelSDKPreferencePage.this.setValid(false);
                }
            }
        });
        if (this.iReportProps.getProperty(SDKConstants.PREF_IREPORT_PATH) != null) {
            this.m_iReportHomeDir.setText(this.iReportProps.getProperty(SDKConstants.PREF_IREPORT_PATH));
        }
    }

    private void addOpenOfficePreference(Composite container) {
        Label l = new Label(container, 0);
        l.setText(Messages.Preference_OpenOfficeHomeDir);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.m_iReportHomeDir, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(50, 0);
        l.setLayoutData((Object)data);
        this.m_openOfficeHomeDir = new HistoryTextField(container, OPENOFFICE_HOMEDIR_FIELDKEY);
        this.m_openOfficeHomeDir.addModifyListener(this);
        data = new FormData();
        data.top = new FormAttachment((Control)l, 5);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -100);
        this.m_openOfficeHomeDir.setLayoutData(data);
        this.m_openOfficeHomeDir.selectFirstInList();
        this.m_openOfficeBtn = new Button(container, 8);
        this.m_openOfficeBtn.setText(Messages.Browse);
        this.m_openOfficeBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                String dir = SentinelSDKPreferencePage.this.browseForDirectory(Messages.Preference_IReportHomeDirExample);
                if (dir != null && dir.length() > 0) {
                    SentinelSDKPreferencePage.this.m_openOfficeHomeDir.setText(dir);
                }
            }
        });
        data = new FormData();
        data.top = new FormAttachment((Control)l, 5);
        data.left = new FormAttachment((Control)this.m_openOfficeHomeDir, 5);
        this.m_openOfficeBtn.setLayoutData((Object)data);
        InfoWidget widg = new InfoWidget(container, Messages.Preference_OpenOfficeHomeDirTitle, Messages.Preference_OpenOfficeHomeDirExample);
        data = new FormData();
        data.top = new FormAttachment((Control)l, 5);
        data.left = new FormAttachment((Control)this.m_openOfficeBtn, 5);
        widg.setLayoutData(data);
        this.m_openOfficeHomeDir.getComboControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (SentinelSDKPreferencePage.this.validatePage()) {
                    SentinelSDKPreferencePage.this.setValid(true);
                } else {
                    SentinelSDKPreferencePage.this.setValid(false);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (SentinelSDKPreferencePage.this.validatePage()) {
                    SentinelSDKPreferencePage.this.setValid(true);
                } else {
                    SentinelSDKPreferencePage.this.setValid(false);
                }
            }
        });
        if (this.openOfficeProps.getProperty(SDKConstants.PREF_OPENOFFICE_PATH) != null) {
            this.m_openOfficeHomeDir.setText(this.openOfficeProps.getProperty(SDKConstants.PREF_OPENOFFICE_PATH));
        }
    }

    private void addAuthorPreference(Composite container) {
        Label l = new Label(container, 0);
        l.setText(Messages.Preference_Author);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.m_openOfficeHomeDir, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(50, 0);
        l.setLayoutData((Object)data);
        this.m_pluginAuthor = new HistoryTextField(container, AUTHOR_FIELDKEY);
        this.m_pluginAuthor.addModifyListener(this);
        data = new FormData();
        data.top = new FormAttachment((Control)l, 5);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -100);
        this.m_pluginAuthor.setLayoutData(data);
        this.m_pluginAuthor.selectFirstInList();
        InfoWidget widg = new InfoWidget(container, Messages.Preference_AuthorTitle, Messages.Preference_AuthorExample);
        data = new FormData();
        data.top = new FormAttachment((Control)l, 5);
        data.left = new FormAttachment((Control)this.m_pluginAuthor, 5);
        widg.setLayoutData(data);
        this.m_pluginAuthor.getComboControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (SentinelSDKPreferencePage.this.validatePage()) {
                    SentinelSDKPreferencePage.this.setValid(true);
                } else {
                    SentinelSDKPreferencePage.this.setValid(false);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (SentinelSDKPreferencePage.this.validatePage()) {
                    SentinelSDKPreferencePage.this.setValid(true);
                } else {
                    SentinelSDKPreferencePage.this.setValid(false);
                }
            }
        });
        if (this.devProps.getProperty(SDKConstants.PREF_PLUGIN_AUTHOR) != null) {
            this.m_pluginAuthor.setText(this.devProps.getProperty(SDKConstants.PREF_PLUGIN_AUTHOR));
        }
    }

    private void addHideEmptyFolderPreference(Composite container) {
        Group group = new Group(container, 0);
        group.setText(Messages.Preference_ViewOptions);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.m_pluginAuthor, 20);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -10);
        group.setLayoutData((Object)data);
        group.setLayout((Layout)new FormLayout());
        this.m_hideEmptyPluginFolders = new Button((Composite)group, 32);
        this.m_hideEmptyPluginFolders.setText(Messages.Preference_HideEmptyPluginFolders);
        data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 10);
        this.m_hideEmptyPluginFolders.setLayoutData((Object)data);
        InfoWidget widg = new InfoWidget((Composite)group, Messages.Preference_HideEmptyPluginFolders, Messages.Preference_HideEmptyPluginFoldersInfo);
        widg.setVerboseInfo(Messages.Preference_HideEmptyPluginFoldersVerbose);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment((Control)this.m_hideEmptyPluginFolders, 5);
        widg.setLayoutData(data);
        Label buffer = new Label((Composite)group, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.m_hideEmptyPluginFolders, 5);
        data.left = new FormAttachment(0, 10);
        buffer.setLayoutData((Object)data);
        boolean hideEmptyPlugins = Activator.getDefault().getPreferenceStore().getBoolean(SDKConstants.PREF_HIDE_EMPTY_PLUGIN_FOLDERS);
        this.m_hideEmptyPluginFolders.setSelection(hideEmptyPlugins);
    }

    public void modifyText(ModifyEvent arg0) {
        if (this.m_openOfficeHomeDir != null && this.m_iReportHomeDir != null && this.m_pluginAuthor != null) {
            if (this.validatePage()) {
                this.setValid(true);
            } else {
                this.setValid(false);
            }
            if (arg0.getSource() == this.m_openOfficeHomeDir.getComboControl()) {
                this.checkOpenOfficeDirectory();
            } else if (arg0.getSource() == this.m_iReportHomeDir.getComboControl()) {
                this.checkIReportDirectory();
            }
        }
    }

    private GridData createGridData(int width, int height, boolean hFill, boolean vFill) {
        return this.createGridData(width, height, hFill ? 4 : 1, vFill ? 4 : 0x1000000, hFill, vFill);
    }

    private GridData createGridData(int width, int height, int hAlign, int vAlign, boolean hGrab, boolean vGrab) {
        GridData gd = new GridData(hAlign, vAlign, hGrab, vGrab);
        gd.widthHint = width;
        gd.heightHint = height;
        return gd;
    }

    private String browseForDirectory(String msg) {
        DirectoryDialog choosePath = new DirectoryDialog(this.getShell());
        choosePath.setMessage(msg);
        return choosePath.open();
    }

    private void checkIReportDirectory() {
        File file = null;
        boolean skipCheck = false;
        String validateText = this.m_iReportHomeDir.getText().trim();
        if (validateText != null && validateText.length() > 0) {
            if (SDKUtil.isWindows()) {
                file = new File(validateText + File.separator + "iReport.bat");
                if (!file.exists()) {
                    file = new File(validateText + File.separator + "bin" + File.separator + "ireport.exe");
                }
            } else if (SDKUtil.isLinux()) {
                file = new File(validateText + File.separator + "iReport.sh");
                if (!file.exists()) {
                    file = new File(validateText + File.separator + "bin" + File.separator + "ireport");
                }
            } else {
                skipCheck = true;
            }
        }
        if (!(skipCheck || file != null && file.exists())) {
            if (SDKUtil.isWindows()) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.SentinelSDK, (String)Messages.Preference_InvalidIReportPathWindows);
            } else {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.SentinelSDK, (String)Messages.Preference_InvalidIReportPathLinux);
            }
        }
    }

    private void checkOpenOfficeDirectory() {
        boolean skipCheck = false;
        File file = null;
        String validateText = this.m_openOfficeHomeDir.getText().trim();
        if (validateText != null && validateText.length() > 0) {
            if (SDKUtil.isWindows()) {
                file = new File(validateText + File.separator + "soffice.exe");
            } else if (SDKUtil.isLinux()) {
                file = new File(validateText + File.separator + "soffice");
            } else {
                skipCheck = true;
            }
        }
        if (!(skipCheck || file != null && file.exists())) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.SentinelSDK, (String)Messages.Preference_InvalidOpenOfficePath);
        }
    }
}

