/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.prefs;

import com.netiq.sentinel.sdk.Activator;
import com.netiq.sentinel.sdk.Messages;
import com.netiq.sentinel.sdk.SDKConstants;
import com.netiq.sentinel.sdk.SDKUtil;
import com.netiq.sentinel.sdk.widgets.HistoryTextField;
import com.netiq.sentinel.sdk.widgets.InfoWidget;
import java.io.File;
import java.util.Properties;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class SentinelSMTPPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
ModifyListener {
    private static String SMTP_SERVER_FIELDKEY = "SubmitSMTPServerKey";
    private static String SMTP_USER_FIELDKEY = "SubmitSMTPUserKey";
    private static String SMTP_FROM_FIELDKEY = "SubmitSMTPFromKey";
    private HistoryTextField m_server;
    private HistoryTextField m_user;
    private HistoryTextField m_from;
    private Text m_password;
    private StringBuffer devPropFileName = new StringBuffer();
    private Properties devProps;
    private static String DEV_PROP_FILE = File.separator + ".netiq" + File.separator + "pluginsdk" + File.separator + "dev.properties";

    public SentinelSMTPPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.devPropFileName.append(System.getProperty(SDKConstants.USER_HOME));
        this.devPropFileName.append(DEV_PROP_FILE);
        this.devProps = SDKUtil.loadProperties(this.devPropFileName.toString());
    }

    protected Control createContents(Composite parent) {
        Composite area = parent;
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new FormLayout());
        container.setLayoutData((Object)this.createGridData(200, 200, true, true));
        this.addServerPreference(container);
        this.addUserPreference(container);
        this.addPasswordPreference(container);
        this.addFromPreference(container);
        return area;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.m_user.getComboControl().removeAll();
        super.performDefaults();
    }

    private boolean validatePage() {
        this.setErrorMessage(null);
        this.setValid(true);
        return true;
    }

    public boolean performOk() {
        super.performOk();
        if (this.validatePage()) {
            if (this.m_user.getComboControl().getItemCount() < 1) {
                Activator.getDefault().getPreferenceStore().setValue(SMTP_USER_FIELDKEY, "");
            }
            this.m_user.saveToHistory();
            Activator.getDefault().getPreferenceStore().setValue(SDKConstants.PREF_SMTPUSER, this.m_user.getText());
            this.devProps.setProperty(SDKConstants.PREF_SMTPUSER, this.m_user.getText());
            if (this.m_from.getComboControl().getItemCount() < 1) {
                Activator.getDefault().getPreferenceStore().setValue(SMTP_FROM_FIELDKEY, "");
            }
            this.m_from.saveToHistory();
            Activator.getDefault().getPreferenceStore().setValue(SDKConstants.PREF_SMTPFROM, this.m_from.getText());
            this.devProps.setProperty(SDKConstants.PREF_SMTPFROM, this.m_from.getText());
            if (this.m_server.getComboControl().getItemCount() < 1) {
                Activator.getDefault().getPreferenceStore().setValue(SMTP_SERVER_FIELDKEY, "");
            }
            this.m_server.saveToHistory();
            Activator.getDefault().getPreferenceStore().setValue(SDKConstants.PREF_SMTPHOST, this.m_server.getText());
            this.devProps.setProperty(SDKConstants.PREF_SMTPHOST, this.m_server.getText());
            Activator.getDefault().getPreferenceStore().setValue(SDKConstants.PREF_SMTPPASS, this.m_password.getText());
            this.devProps.setProperty(SDKConstants.PREF_SMTPPASS, this.m_password.getText());
            SDKUtil.saveProperties(this.devPropFileName.toString(), this.devProps, SDKUtil.DEV_PROP_COMMENT);
            return true;
        }
        return false;
    }

    protected void createFieldEditors() {
    }

    private void addServerPreference(Composite container) {
        Label l = new Label(container, 0);
        l.setText(Messages.Preference_SMTPHostColon);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(50, 0);
        l.setLayoutData((Object)data);
        this.m_server = new HistoryTextField(container, SMTP_SERVER_FIELDKEY);
        this.m_server.addModifyListener(this);
        data = new FormData();
        data.top = new FormAttachment((Control)l, 5);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -100);
        this.m_server.setLayoutData(data);
        this.m_server.selectFirstInList();
        InfoWidget widg = new InfoWidget(container, Messages.Preference_SMTPHost, Messages.Preference_SMTPHostExample);
        data = new FormData();
        data.top = new FormAttachment((Control)l, 5);
        data.left = new FormAttachment((Control)this.m_server, 5);
        widg.setLayoutData(data);
        this.m_server.getComboControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (SentinelSMTPPreferencePage.this.validatePage()) {
                    SentinelSMTPPreferencePage.this.setValid(true);
                } else {
                    SentinelSMTPPreferencePage.this.setValid(false);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (SentinelSMTPPreferencePage.this.validatePage()) {
                    SentinelSMTPPreferencePage.this.setValid(true);
                } else {
                    SentinelSMTPPreferencePage.this.setValid(false);
                }
            }
        });
        if (this.devProps.getProperty(SDKConstants.PREF_SMTPHOST) != null) {
            this.m_server.setText(this.devProps.getProperty(SDKConstants.PREF_SMTPHOST));
        }
    }

    private void addUserPreference(Composite container) {
        Label l = new Label(container, 0);
        l.setText(Messages.Preference_SMTPUserColon);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.m_server, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(50, 0);
        l.setLayoutData((Object)data);
        this.m_user = new HistoryTextField(container, SMTP_USER_FIELDKEY);
        this.m_user.addModifyListener(this);
        data = new FormData();
        data.top = new FormAttachment((Control)l, 5);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -100);
        this.m_user.setLayoutData(data);
        this.m_user.selectFirstInList();
        InfoWidget widg = new InfoWidget(container, Messages.Preference_SMTPUser, Messages.Preference_SMTPUserExample);
        data = new FormData();
        data.top = new FormAttachment((Control)l, 5);
        data.left = new FormAttachment((Control)this.m_user, 5);
        widg.setLayoutData(data);
        this.m_user.getComboControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (SentinelSMTPPreferencePage.this.validatePage()) {
                    SentinelSMTPPreferencePage.this.setValid(true);
                } else {
                    SentinelSMTPPreferencePage.this.setValid(false);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (SentinelSMTPPreferencePage.this.validatePage()) {
                    SentinelSMTPPreferencePage.this.setValid(true);
                } else {
                    SentinelSMTPPreferencePage.this.setValid(false);
                }
            }
        });
        if (this.devProps.getProperty(SDKConstants.PREF_SMTPUSER) != null) {
            this.m_user.setText(this.devProps.getProperty(SDKConstants.PREF_SMTPUSER));
        }
    }

    private void addPasswordPreference(Composite container) {
        Label l = new Label(container, 0);
        l.setText(Messages.Preference_SMTPPassword);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.m_user, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(50, 0);
        l.setLayoutData((Object)data);
        this.m_password = new Text(container, 0x400800);
        this.m_password.addModifyListener((ModifyListener)this);
        data = new FormData();
        data.top = new FormAttachment((Control)l, 5);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -100);
        this.m_password.setLayoutData((Object)data);
        if (this.devProps.getProperty(SDKConstants.PREF_SMTPPASS) != null) {
            this.m_password.setText(this.devProps.getProperty(SDKConstants.PREF_SMTPPASS));
        }
    }

    private void addFromPreference(Composite container) {
        Label l = new Label(container, 0);
        l.setText(Messages.Preference_SMTPFromColon);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.m_password, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(50, 0);
        l.setLayoutData((Object)data);
        this.m_from = new HistoryTextField(container, SMTP_FROM_FIELDKEY);
        this.m_from.addModifyListener(this);
        data = new FormData();
        data.top = new FormAttachment((Control)l, 5);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -100);
        this.m_from.setLayoutData(data);
        this.m_from.selectFirstInList();
        InfoWidget widg = new InfoWidget(container, Messages.Preference_SMTPFrom, Messages.Preference_SMTPFromExample);
        data = new FormData();
        data.top = new FormAttachment((Control)l, 5);
        data.left = new FormAttachment((Control)this.m_from, 5);
        widg.setLayoutData(data);
        this.m_from.getComboControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (SentinelSMTPPreferencePage.this.validatePage()) {
                    SentinelSMTPPreferencePage.this.setValid(true);
                } else {
                    SentinelSMTPPreferencePage.this.setValid(false);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (SentinelSMTPPreferencePage.this.validatePage()) {
                    SentinelSMTPPreferencePage.this.setValid(true);
                } else {
                    SentinelSMTPPreferencePage.this.setValid(false);
                }
            }
        });
        if (this.devProps.getProperty(SDKConstants.PREF_SMTPFROM) != null) {
            this.m_from.setText(this.devProps.getProperty(SDKConstants.PREF_SMTPFROM));
        }
    }

    public void modifyText(ModifyEvent arg0) {
        if (this.m_from != null && this.m_user != null && this.m_server != null) {
            if (this.validatePage()) {
                this.setValid(true);
            } else {
                this.setValid(false);
            }
        }
    }

    private GridData createGridData(int width, int height, boolean hFill, boolean vFill) {
        return this.createGridData(width, height, hFill ? 4 : 1, vFill ? 4 : 0x1000000, hFill, vFill);
    }

    private GridData createGridData(int width, int height, int hAlign, int vAlign, boolean hGrab, boolean vGrab) {
        GridData gd = new GridData(hAlign, vAlign, hGrab, vGrab);
        gd.widthHint = width;
        gd.heightHint = height;
        return gd;
    }
}

