/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.util;

import com.netiq.sentinel.sdk.util.Log;

public final class Arg {
    private Arg() {
    }

    public static boolean checkHasString(String str) {
        if (str == null || str.length() == 0) {
            String msg = "Argument is null or empty.  This is a bug - please fix by looking at the stack in Arg.java";
            if (Log.isStackTraceOn()) {
                Thread.dumpStack();
            }
            Log.warning(msg);
            return false;
        }
        return true;
    }

    public static boolean checkNotNull(Object obj) {
        if (obj == null) {
            String msg = "Argument is null.  This is a bug - please fix by looking at the stack in Arg.java";
            if (Log.isStackTraceOn()) {
                Thread.dumpStack();
            }
            Log.warning(msg);
            return false;
        }
        return true;
    }

    public static boolean checkNotNull(Object obj1, Object obj2) {
        if (obj1 == null) {
            String msg = "Argument1 is null.";
            Log.warning(msg);
            return false;
        }
        if (obj2 == null) {
            String msg = "Argument2 is null.";
            Log.warning(msg);
            return false;
        }
        return true;
    }

    public static boolean checkNotNull(Object obj1, Object obj2, Object obj3) {
        if (obj1 == null) {
            String msg = "Argument1 is null.";
            Log.warning(msg);
            return false;
        }
        if (obj2 == null) {
            String msg = "Argument2 is null.";
            Log.warning(msg);
            return false;
        }
        if (obj3 == null) {
            String msg = "Argument3 is null.";
            Log.warning(msg);
            return false;
        }
        return true;
    }

    public static boolean checkWithinBounds(int value, int min, int max) {
        if (min == -1 && max == -1) {
            return true;
        }
        if (min == -1) {
            if (value > max) {
                String msg = "Argument value should be less than or equal to " + max + " but it was: " + value;
                Log.warning(msg);
                return false;
            }
        } else if (max == -1) {
            if (value < min) {
                String msg = "Argument value should be greater or equal to " + min + " but it was: " + value;
                Log.warning(msg);
                return false;
            }
        } else if (value < min || value > max) {
            String msg = "Argument value should be in the range of: " + min + " - " + max + " but it was: " + value;
            Log.warning(msg);
            return false;
        }
        return true;
    }
}

