/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.util;

import com.netiq.sentinel.sdk.Activator;
import com.netiq.sentinel.sdk.util.Arg;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class Log {
    private static boolean LoggingOn = true;
    private static boolean StackTraceOn;
    public static boolean InternalShowTraceInLog;

    private Log() {
    }

    public static void setLoggingOn(boolean flag) {
        LoggingOn = flag;
    }

    public static void setStackTraceOn(boolean flag) {
        StackTraceOn = flag;
    }

    public static boolean isStackTraceOn() {
        return StackTraceOn;
    }

    public static void error(String msg, Throwable thrown) {
        Activator plugin = Activator.getDefault();
        if (!Arg.checkNotNull(msg)) {
            return;
        }
        if (!LoggingOn) {
            return;
        }
        String id = null;
        id = plugin != null ? plugin.getDescriptor().getUniqueIdentifier() : Activator.getDefault().getDescriptor().getUniqueIdentifier();
        if (thrown == null) {
            Status exceptionStatus = new Status(4, id, 0, " ", null);
            thrown = new CoreException((IStatus)exceptionStatus);
        }
        Status status = new Status(4, id, 0, msg, thrown);
        if (plugin != null) {
            plugin.getLog().log((IStatus)status);
            if (InternalShowTraceInLog) {
                Log.writeToSystem(msg);
            }
        }
    }

    public static void error(Throwable thrown) {
        String msg = "Thrown Exception";
        Log.error(msg, thrown);
    }

    public static void error(String msg) {
        Log.error(msg, null);
    }

    static void msg(String msg) {
        Log.info(msg);
    }

    public static void warning(String msg, Throwable thrown) {
        Activator plugin = Activator.getDefault();
        if (!Arg.checkNotNull(msg)) {
            return;
        }
        if (!LoggingOn) {
            return;
        }
        String id = " ";
        if (plugin != null) {
            id = plugin.getDescriptor().getUniqueIdentifier();
        }
        if (thrown == null) {
            Status exceptionStatus = new Status(2, id, 0, " ", null);
            thrown = new CoreException((IStatus)exceptionStatus);
        }
        Status status = new Status(2, id, 0, msg, thrown);
        plugin.getLog().log((IStatus)status);
        if (InternalShowTraceInLog) {
            Log.writeToSystem(msg);
        }
    }

    public static void warning(String msg) {
        Log.warning(msg, null);
    }

    public static void info(String msg) {
        Activator plugin = Activator.getDefault();
        if (!Arg.checkNotNull(msg)) {
            return;
        }
        if (!LoggingOn) {
            return;
        }
        String id = " ";
        if (plugin != null) {
            id = plugin.getDescriptor().getUniqueIdentifier();
        }
        Status status = new Status(1, id, 0, msg, null);
        if (plugin != null) {
            plugin.getLog().log((IStatus)status);
            if (InternalShowTraceInLog) {
                Log.writeToSystem(msg);
            }
        }
    }

    private static void writeToSystem(Object obj) {
        System.out.println(obj.toString());
    }

    static {
        InternalShowTraceInLog = true;
    }
}

