/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.views;

import com.netiq.sentinel.sdk.Activator;
import com.netiq.sentinel.sdk.Messages;
import com.netiq.sentinel.sdk.SDKConstants;
import com.netiq.sentinel.sdk.model.PluginImages;
import com.netiq.sentinel.sdk.model.RegularFileObject;
import com.netiq.sentinel.sdk.model.RegularFolderObject;
import com.netiq.sentinel.sdk.model.SentinelPlugin;
import com.netiq.sentinel.sdk.model.SentinelProject;
import com.netiq.sentinel.sdk.views.providers.SentinelSDKContentProvider;
import com.netiq.sentinel.sdk.views.providers.SentinelSDKLabelProvider;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.CopyResourceAction;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;

public class SentinelSDKView
extends ViewPart
implements ISelectionChangedListener,
IPropertyChangeListener {
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private Action doubleClickAction;
    private IAction delFileAction;
    private IAction renameAction;
    private IAction copyAction;
    private IAction moveAction;
    private IAction newFileAction;
    private IStructuredSelection m_selection = null;
    private IResource m_selectedResource = null;
    private Text m_nameFilter = null;

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        container.setLayout((Layout)layout);
        container.setBackground(parent.getDisplay().getSystemColor(1));
        this.addFilterControls(container);
        Label shadow_sep_h = new Label(container, 266);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        shadow_sep_h.setLayoutData((Object)gridData);
        this.viewer = new TreeViewer(container, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new SentinelSDKContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SentinelSDKLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        gridData = new GridData(1808);
        this.viewer.getControl().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "SentinelSDK.viewer");
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SentinelSDKView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this.m_selection != null) {
            Object obj = this.m_selection.getFirstElement();
            if (obj instanceof RegularFolderObject || obj instanceof IFolder) {
                manager.add(this.newFileAction);
                manager.add((IContributionItem)new Separator());
                manager.add(this.renameAction);
                manager.add(this.moveAction);
                manager.add((IContributionItem)new Separator());
                manager.add(this.delFileAction);
            } else if (obj instanceof RegularFileObject || obj instanceof IFile) {
                manager.add((IContributionItem)new Separator("editGroup"));
                manager.add((IContributionItem)new Separator());
                manager.add(this.renameAction);
                manager.add(this.copyAction);
                manager.add(this.moveAction);
                manager.add((IContributionItem)new Separator());
                manager.add(this.delFileAction);
            } else if (obj instanceof SentinelPlugin) {
                manager.add(this.newFileAction);
                manager.add((IContributionItem)new Separator("buildGroup"));
                manager.add((IContributionItem)new Separator("actionGroup"));
                manager.add((IContributionItem)new Separator());
                manager.add(this.delFileAction);
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void addFilterControls(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        container.setLayoutData((Object)gridData);
        container.setBackground(parent.getDisplay().getSystemColor(1));
        container.setLayout((Layout)new FormLayout());
        Label label = new Label(container, 0);
        label.setBackground(parent.getDisplay().getSystemColor(1));
        label.setText("Find:");
        FormData data = new FormData();
        data.top = new FormAttachment(0, 6);
        data.left = new FormAttachment(0, 0);
        label.setLayoutData((Object)data);
        this.m_nameFilter = new Text(container, 2052);
        this.m_nameFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SentinelSDKContentProvider provider = (SentinelSDKContentProvider)SentinelSDKView.this.viewer.getContentProvider();
                provider.applyNameFilter(SentinelSDKView.this.m_nameFilter.getText());
            }
        });
        data = new FormData();
        data.top = new FormAttachment(0, 3);
        data.left = new FormAttachment((Control)label, 5);
        data.right = new FormAttachment(100, -40);
        this.m_nameFilter.setLayoutData((Object)data);
        Button btn = new Button(container, 0x800000);
        btn.setImage(PluginImages.getPreferencesImage());
        btn.setToolTipText(Messages.Preferences_Tooltip);
        btn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                String[] prefPages = new String[]{"com.sentinel.sdk"};
                PreferencesUtil.createPreferenceDialogOn((Shell)SentinelSDKView.this.getSite().getShell(), (String)prefPages[0], (String[])prefPages, null).open();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment((Control)this.m_nameFilter, 5);
        btn.setLayoutData((Object)data);
    }

    private void makeActions() {
        ISharedImages sharedImages = this.getSite().getWorkbenchWindow().getWorkbench().getSharedImages();
        this.delFileAction = new Action(){

            public void run() {
                ArrayList<Object> deleteResources = new ArrayList<Object>();
                if (SentinelSDKView.this.m_selectedResource != null) {
                    for (Object object : SentinelSDKView.this.m_selection.toList()) {
                        if (object instanceof RegularFolderObject) {
                            deleteResources.add(((RegularFolderObject)object).getFolder());
                            continue;
                        }
                        if (object instanceof RegularFileObject) {
                            deleteResources.add(((RegularFileObject)object).getFile());
                            continue;
                        }
                        if (object instanceof SentinelPlugin) {
                            deleteResources.add(((SentinelPlugin)object).getFolder());
                            continue;
                        }
                        if (!(object instanceof IResource)) continue;
                        deleteResources.add((IResource)object);
                    }
                }
                DeleteResourceAction tmp = new DeleteResourceAction((IShellProvider)SentinelSDKView.this.getSite().getWorkbenchWindow());
                StructuredSelection ss = new StructuredSelection(deleteResources);
                tmp.selectionChanged((IStructuredSelection)ss);
                tmp.run();
            }
        };
        this.delFileAction.setText(WorkbenchMessages.Workbench_delete);
        this.delFileAction.setToolTipText(WorkbenchMessages.Workbench_deleteToolTip);
        this.delFileAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.delFileAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.delFileAction.setEnabled(true);
        this.copyAction = new Action(){

            public void run() {
                if (SentinelSDKView.this.m_selectedResource != null) {
                    CopyResourceAction tmp = new CopyResourceAction((IShellProvider)SentinelSDKView.this.getSite().getWorkbenchWindow());
                    StructuredSelection ss = new StructuredSelection((Object)SentinelSDKView.this.m_selectedResource);
                    tmp.selectionChanged((IStructuredSelection)ss);
                    tmp.run();
                }
            }
        };
        this.copyAction.setText(WorkbenchMessages.Workbench_copy);
        this.copyAction.setToolTipText(WorkbenchMessages.Workbench_copyToolTip);
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setEnabled(true);
        this.moveAction = new Action(){

            public void run() {
                if (SentinelSDKView.this.m_selectedResource != null) {
                    MoveResourceAction tmp = new MoveResourceAction((IShellProvider)SentinelSDKView.this.getSite().getWorkbenchWindow());
                    StructuredSelection ss = new StructuredSelection((Object)SentinelSDKView.this.m_selectedResource);
                    tmp.selectionChanged((IStructuredSelection)ss);
                    tmp.run();
                }
            }
        };
        this.moveAction.setText(WorkbenchMessages.Workbench_move);
        this.moveAction.setToolTipText(WorkbenchMessages.Workbench_moveToolTip);
        this.moveAction.setEnabled(true);
        this.renameAction = new Action(){

            public void run() {
                if (SentinelSDKView.this.m_selectedResource != null) {
                    RenameResourceAction tmp = new RenameResourceAction((IShellProvider)SentinelSDKView.this.getSite().getWorkbenchWindow());
                    StructuredSelection ss = new StructuredSelection((Object)SentinelSDKView.this.m_selectedResource);
                    tmp.selectionChanged((IStructuredSelection)ss);
                    tmp.run();
                }
            }
        };
        this.renameAction.setText(WorkbenchMessages.Workbench_rename);
        this.renameAction.setToolTipText(WorkbenchMessages.Workbench_renameToolTip);
        this.renameAction.setEnabled(true);
        this.newFileAction = ActionFactory.NEW.create(this.getSite().getWorkbenchWindow());
        this.newFileAction.setText(Messages.Action_New);
        this.doubleClickAction = new Action(){

            public void run() {
                block11: {
                    ISelection selection = SentinelSDKView.this.viewer.getSelection();
                    Object obj = ((IStructuredSelection)selection).getFirstElement();
                    if (obj instanceof IFile || obj instanceof RegularFileObject) {
                        IFile file = obj instanceof IFile ? (IFile)obj : ((RegularFileObject)obj).getFile();
                        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        if (page != null) {
                            try {
                                if (desc == null) {
                                    if (file.getName().endsWith(".odt") || file.getName().endsWith(".doc") || file.getName().endsWith(".pdf") || file.getName().endsWith(".def")) {
                                        page.openEditor((IEditorInput)new FileEditorInput(file), "org.eclipse.ui.systemExternalEditor");
                                    } else {
                                        page.openEditor((IEditorInput)new FileEditorInput(file), "org.eclipse.ui.DefaultTextEditor");
                                    }
                                    break block11;
                                }
                                page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
                            }
                            catch (PartInitException e) {
                                e.printStackTrace();
                            }
                        }
                    } else if (obj instanceof IFolder || obj instanceof RegularFolderObject || obj instanceof SentinelPlugin || obj instanceof SentinelProject) {
                        if (SentinelSDKView.this.viewer.getExpandedState(obj)) {
                            SentinelSDKView.this.viewer.collapseToLevel(obj, 1);
                        } else {
                            SentinelSDKView.this.viewer.expandToLevel(obj, 1);
                        }
                    }
                }
            }
        };
        IWorkbenchWindow ww = this.getSite().getPage().getWorkbenchWindow();
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), this.delFileAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.RENAME.getId(), this.renameAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), this.copyAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.MOVE.getId(), this.moveAction);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SentinelSDKView.this.doubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void selectionChanged(SelectionChangedEvent arg0) {
        this.m_selection = null;
        this.m_selectedResource = null;
        if (this.viewer != null && this.viewer.getSelection() instanceof IStructuredSelection) {
            this.m_selection = (IStructuredSelection)this.viewer.getSelection();
            Object obj = this.m_selection.getFirstElement();
            if (obj instanceof Action) {
                ((Action)obj).run();
            } else if (obj instanceof RegularFileObject) {
                this.m_selectedResource = ((RegularFileObject)obj).getFile();
            } else if (obj instanceof RegularFolderObject) {
                this.m_selectedResource = ((RegularFolderObject)obj).getFolder();
            } else if (obj instanceof SentinelPlugin) {
                this.m_selectedResource = ((SentinelPlugin)obj).getFolder();
            }
            this.delFileAction.setEnabled(true);
            this.renameAction.setEnabled(true);
            this.copyAction.setEnabled(true);
            this.moveAction.setEnabled(true);
            this.newFileAction.setEnabled(true);
            if (this.m_selection.size() > 1) {
                this.renameAction.setEnabled(false);
                this.copyAction.setEnabled(false);
                this.moveAction.setEnabled(false);
                this.newFileAction.setEnabled(false);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        if (arg0.getProperty().equals(SDKConstants.PREF_HIDE_EMPTY_PLUGIN_FOLDERS)) {
            SentinelSDKContentProvider provider = (SentinelSDKContentProvider)this.viewer.getContentProvider();
            provider.applyEmptyFilter();
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }
}

