/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.views.providers;

import com.netiq.sentinel.sdk.XMLFileReader;
import java.util.ArrayList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NodeList;

public class ReadExcludedFiles
extends XMLFileReader {
    private boolean ignoreEmptyFolders;
    private ArrayList<String> GlobalFilesElementList;
    private ArrayList<String> GlobalExtElementList;
    private ArrayList<String> CollectorFilesElementList;
    private ArrayList<String> CollectorExtElementList;
    private ArrayList<String> ActionFilesElementList;
    private ArrayList<String> ActionExtElementList;
    private ArrayList<String> ReportFilesElementList;
    private ArrayList<String> ReportExtElementList;
    private ArrayList<String> SolutionFilesElementList;
    private ArrayList<String> SolutionExtElementList;
    private ArrayList<String> RDDFilesElementList;
    private ArrayList<String> RDDExtElementList;

    ReadExcludedFiles(String FName) {
        super(FName);
        this.setArrayValues();
    }

    private void setArrayValues() {
        try {
            this.GlobalFilesElementList = this.getExcludeList("//global/File/Name/text() | //global/Folder/Name/text()");
            this.GlobalExtElementList = this.getExcludeList("//global/FileExtension/Ext/text()");
            this.CollectorFilesElementList = this.getExcludeList("//project[@nature='com.netiq.sentinel.sdk.SentinelCollectorProjectNature']/File/Name/text() | //project[@nature='com.netiq.sentinel.sdk.SentinelCollectorProjectNature']/Folder/Name/text()");
            this.CollectorExtElementList = this.getExcludeList("//project[@nature='com.netiq.sentinel.sdk.SentinelCollectorProjectNature']/FileExtension/Ext/text()");
            this.ActionFilesElementList = this.getExcludeList("//project[@nature='com.netiq.sentinel.sdk.SentinelActionProjectNature']/File/Name/text() | //project[@nature='com.netiq.sentinel.sdk.SentinelActionProjectNature']/Folder/Name/text()");
            this.ActionExtElementList = this.getExcludeList("//project[@nature='com.netiq.sentinel.sdk.SentinelActionProjectNature']/FileExtension/Ext/text()");
            this.ReportFilesElementList = this.getExcludeList("//project[@nature='com.netiq.sentinel.sdk.SentinelReportProjectNature']/File/Name/text() | //project[@nature='com.netiq.sentinel.sdk.SentinelReportProjectNature']/Folder/Name/text()");
            this.ReportExtElementList = this.getExcludeList("//project[@nature='com.netiq.sentinel.sdk.SentinelReportProjectNature']/FileExtension/Ext/text()");
            this.SolutionFilesElementList = this.getExcludeList("//project[@nature='com.netiq.sentinel.sdk.SentinelSolutionProjectNature']/File/Name/text() | //project[@nature='com.netiq.sentinel.sdk.SentinelSolutionProjectNature']/Folder/Name/text()");
            this.SolutionExtElementList = this.getExcludeList("//project[@nature='com.netiq.sentinel.sdk.SentinelSolutionProjectNature']/FileExtension/Ext/text()");
            this.RDDFilesElementList = this.getExcludeList("//project[@nature='com.netiq.sentinel.sdk.SentinelRDDProjectNature']/File/Name/text() | //project[@nature='com.netiq.sentinel.sdk.SentinelSolutionProjectNature']/Folder/Name/text()");
            this.RDDExtElementList = this.getExcludeList("//project[@nature='com.netiq.sentinel.sdk.SentinelRDDProjectNature']/FileExtension/Ext/text()");
            this.getIgnoreEmptyFolders();
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            e.toString();
        }
    }

    private ArrayList<String> getExcludeList(String strXPath) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile(strXPath);
        Object result = expr.evaluate(this.XMLFile, XPathConstants.NODESET);
        NodeList Names = (NodeList)result;
        ArrayList<String> tempList = new ArrayList<String>(Names.getLength());
        for (int i = 0; i < Names.getLength(); ++i) {
            tempList.add(i, Names.item(i).getNodeValue());
        }
        return tempList;
    }

    private void getIgnoreEmptyFolders() throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile("//FilesToExclude/@hideEmptyFolders");
        String result = (String)expr.evaluate(this.XMLFile, XPathConstants.STRING);
        if (result.equalsIgnoreCase("true")) {
            this.setIgnoreEmptyFolders(true);
        } else {
            this.setIgnoreEmptyFolders(false);
        }
    }

    public ArrayList<String> getFilesandFolders(String strNature) {
        if (strNature.equalsIgnoreCase("Global")) {
            return this.GlobalFilesElementList;
        }
        if ("com.netiq.sentinel.sdk.SentinelActionProjectNature".equalsIgnoreCase(strNature)) {
            return this.ActionFilesElementList;
        }
        if ("com.netiq.sentinel.sdk.SentinelReportProjectNature".equalsIgnoreCase(strNature)) {
            return this.ReportFilesElementList;
        }
        if ("com.netiq.sentinel.sdk.SentinelCollectorProjectNature".equalsIgnoreCase(strNature)) {
            return this.CollectorFilesElementList;
        }
        if ("com.netiq.sentinel.sdk.SentinelSolutionProjectNature".equalsIgnoreCase(strNature)) {
            return this.SolutionFilesElementList;
        }
        if ("com.netiq.sentinel.sdk.SentinelRDDProjectNature".equalsIgnoreCase(strNature)) {
            return this.RDDFilesElementList;
        }
        return null;
    }

    public ArrayList<String> getExtensions(String strNature) {
        if (strNature.equalsIgnoreCase("Global")) {
            return this.GlobalExtElementList;
        }
        if ("com.netiq.sentinel.sdk.SentinelActionProjectNature".equalsIgnoreCase(strNature)) {
            return this.ActionExtElementList;
        }
        if ("com.netiq.sentinel.sdk.SentinelReportProjectNature".equalsIgnoreCase(strNature)) {
            return this.ReportExtElementList;
        }
        if ("com.netiq.sentinel.sdk.SentinelCollectorProjectNature".equalsIgnoreCase(strNature)) {
            return this.CollectorExtElementList;
        }
        if ("com.netiq.sentinel.sdk.SentinelSolutionProjectNature".equalsIgnoreCase(strNature)) {
            return this.SolutionExtElementList;
        }
        if ("com.netiq.sentinel.sdk.SentinelRDDProjectNature".equalsIgnoreCase(strNature)) {
            return this.RDDExtElementList;
        }
        return null;
    }

    public boolean isIgnoreEmptyFolders() {
        return this.ignoreEmptyFolders;
    }

    public void setIgnoreEmptyFolders(boolean ignoreEmptyFolders) {
        this.ignoreEmptyFolders = ignoreEmptyFolders;
    }

    public int getPluginProjectDepths(String nature) {
        int depth = -1;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            String path = "//project[@nature='" + nature + "']/@plugin-folder-depth";
            XPathExpression expr = xpath.compile(path);
            String result = (String)expr.evaluate(this.XMLFile, XPathConstants.STRING);
            depth = Integer.parseInt(result);
        }
        catch (Exception e1) {
            depth = -1;
        }
        return depth;
    }
}

