/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.views.providers;

import com.netiq.sentinel.sdk.Activator;
import com.netiq.sentinel.sdk.SDKConstants;
import com.netiq.sentinel.sdk.SDKUtil;
import com.netiq.sentinel.sdk.SentinelSDKNature;
import com.netiq.sentinel.sdk.SentinelSDKProjectNature;
import com.netiq.sentinel.sdk.actions.ImportContentProjectAction;
import com.netiq.sentinel.sdk.actions.ImportSDKProjectAction;
import com.netiq.sentinel.sdk.model.PluginType;
import com.netiq.sentinel.sdk.model.RegularFileObject;
import com.netiq.sentinel.sdk.model.RegularFolderObject;
import com.netiq.sentinel.sdk.model.SentinelPlugin;
import com.netiq.sentinel.sdk.model.SentinelProject;
import com.netiq.sentinel.sdk.sdkscriptsproperties.ScriptProperties;
import com.netiq.sentinel.sdk.views.providers.ReadExcludedFiles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.PlatformUI;

public class SentinelSDKContentProvider
implements ITreeContentProvider,
Observer,
IResourceChangeListener,
ITreeViewerListener {
    private TreeViewer viewer;
    private Action importSDKAction;
    private Action importContentAction;
    private ArrayList<Object> expandedElements;
    private ReadExcludedFiles ExcludedFiles;
    private HashMap<Object, Object> objectCache = new HashMap();
    private ViewerFilter m_emptyFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof RegularFolderObject) {
                RegularFolderObject folder = (RegularFolderObject)element;
                PluginType pluginType = folder.getPluginType();
                int pluginDepth = SentinelSDKContentProvider.this.ExcludedFiles.getPluginProjectDepths(pluginType.getNature());
                if (pluginDepth > 0) {
                    try {
                        if (SentinelSDKContentProvider.this.isEmptyFolder(folder.getFolder(), pluginType, pluginDepth)) {
                            return false;
                        }
                    }
                    catch (CoreException e) {
                        return true;
                    }
                }
            }
            return true;
        }
    };
    private String m_filterByName = null;
    private ViewerFilter m_nameFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (SentinelSDKContentProvider.this.m_filterByName == null || SentinelSDKContentProvider.this.m_filterByName.length() == 0) {
                return true;
            }
            return SentinelSDKContentProvider.this.isElementFiltered(element, null);
        }
    };

    public SentinelSDKContentProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private void openExcludedFiles() {
        this.ExcludedFiles = new ReadExcludedFiles("ExcludedFiles.xml");
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof SentinelProject) {
            return this.getChildrenOfProject((SentinelProject)parentElement);
        }
        if (parentElement instanceof SentinelPlugin) {
            return this.getChildrenOfSentinelPlugin((SentinelPlugin)parentElement);
        }
        if (parentElement instanceof RegularFolderObject) {
            return this.getChildrenOfFolder((RegularFolderObject)parentElement);
        }
        if (parentElement instanceof IFolder) {
            return this.getChildrenOfFolder((IFolder)parentElement);
        }
        ArrayList myArrayList = new ArrayList();
        return myArrayList.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof IFolder) {
            return ((IFolder)element).getParent();
        }
        if (element instanceof IFile) {
            return ((IFile)element).getParent();
        }
        if (element instanceof RegularFileObject) {
            return ((RegularFileObject)element).getFile().getParent();
        }
        if (element instanceof SentinelPlugin) {
            return ((SentinelPlugin)element).getFolder().getParent();
        }
        if (element instanceof RegularFolderObject) {
            return ((RegularFolderObject)element).getFolder().getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof SentinelProject) {
            return true;
        }
        if (element instanceof IFolder) {
            try {
                return ((IFolder)element).members().length > 0;
            }
            catch (CoreException e) {
                System.out.println("Could not get children for IFolder" + (Object)((Object)e));
                return false;
            }
        }
        if (element instanceof SentinelPlugin) {
            try {
                return ((SentinelPlugin)element).getFolder().members().length > 0;
            }
            catch (CoreException e) {
                System.out.println("Could not get children for SentinelPlugin" + (Object)((Object)e));
                return false;
            }
        }
        if (element instanceof RegularFolderObject) {
            try {
                return ((RegularFolderObject)element).getFolder().members().length > 0;
            }
            catch (CoreException e) {
                System.out.println("Could not get children for RegularFolderObject" + (Object)((Object)e));
                return false;
            }
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        Object[] projects = this.getSDKContentProjects();
        if (SDKUtil.getSDKProject() == null) {
            return new Object[]{this.importSDKAction};
        }
        if (projects.length > 0) {
            return projects;
        }
        return new Object[]{this.importContentAction};
    }

    public void dispose() {
    }

    public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
        if (this.viewer != null) {
            this.viewer.removeTreeListener((ITreeViewerListener)this);
        }
        this.viewer = (TreeViewer)newViewer;
        this.viewer.addTreeListener((ITreeViewerListener)this);
        this.importSDKAction = new ImportSDKProjectAction(this.viewer);
        this.importContentAction = new ImportContentProjectAction(this.viewer);
        this.applyEmptyFilter();
    }

    @Override
    public void update(Observable observable, Object passedObject) {
        if (!this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setRedraw(false);
            Object[] expandedElements = this.viewer.getExpandedElements();
            this.viewer.refresh();
            this.viewer.setExpandedElements(expandedElements);
            if (passedObject instanceof ArrayList) {
                for (Object object : (ArrayList)passedObject) {
                    if (object instanceof IFolder) {
                        if (!((IFolder)object).exists()) continue;
                        this.viewer.setSelection((ISelection)new StructuredSelection(object));
                        continue;
                    }
                    if (object instanceof RegularFolderObject) {
                        if (!((RegularFolderObject)object).getFolder().exists()) continue;
                        this.viewer.setSelection((ISelection)new StructuredSelection(object));
                        continue;
                    }
                    if (object instanceof IFile) {
                        if (!((IFile)object).exists()) continue;
                        this.viewer.setSelection((ISelection)new StructuredSelection(object), true);
                        continue;
                    }
                    if (!(object instanceof RegularFileObject) || !((RegularFolderObject)object).getFile().exists()) continue;
                    this.viewer.setSelection((ISelection)new StructuredSelection(object), true);
                }
            }
            this.viewer.getControl().setRedraw(true);
            this.applyEmptyFilter();
        }
    }

    public SentinelProject[] getSDKContentProjects() {
        ResourcesPlugin.getWorkspace().getNatureDescriptors();
        ArrayList<SentinelProject> foundProjects = new ArrayList<SentinelProject>();
        boolean foundSDKProject = false;
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        for (int i = 0; i < projects.length; ++i) {
            try {
                if (!projects[i].isOpen()) continue;
                IProjectNature nature = projects[i].getNature("com.netiq.sentinel.sdk.SentinelSDKProjectNature");
                if (nature instanceof SentinelSDKProjectNature) {
                    PluginType pluginType = SDKUtil.getPluginType(projects[i]);
                    SentinelProject sentinelProject = (SentinelProject)this.objectCache.get(projects[i]);
                    if (sentinelProject == null) {
                        sentinelProject = new SentinelProject(projects[i], pluginType);
                    }
                    foundProjects.add(sentinelProject);
                    continue;
                }
                IProjectNature sdkNature = projects[i].getNature("com.netiq.sentinel.sdk.SentinelSDKNature");
                if (!(sdkNature instanceof SentinelSDKNature)) continue;
                SDKUtil.setSDKProject(projects[i]);
                foundSDKProject = true;
                this.openExcludedFiles();
                continue;
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
        if (!foundSDKProject) {
            SDKUtil.setSDKProject(null);
        }
        return foundProjects.toArray(new SentinelProject[0]);
    }

    private Object[] getChildrenOfProject(SentinelProject sentinelProject) {
        PluginType pluginType = sentinelProject.getPluginType();
        if (pluginType == null) {
            return new Object[0];
        }
        ArrayList<Object> children = new ArrayList<Object>();
        try {
            for (IResource resource : sentinelProject.getProject().members()) {
                RegularFolderObject folderObject;
                SentinelPlugin newSentinelPlugin;
                IFile buildFile;
                Object folder;
                if (this.isExcludedResource(resource, "Global") || this.isExcludedResource(resource, pluginType.getName())) continue;
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    RegularFileObject fileObject = new RegularFileObject(null, file, pluginType);
                    children.add(fileObject);
                    continue;
                }
                if (resource instanceof IFolder) {
                    folder = (IFolder)resource;
                    buildFile = folder.getFile(ScriptProperties.getScriptName("build"));
                    if (buildFile != null && buildFile.exists()) {
                        newSentinelPlugin = (SentinelPlugin)this.objectCache.get(folder);
                        if (newSentinelPlugin == null) {
                            newSentinelPlugin = new SentinelPlugin((IFolder)folder, buildFile, pluginType);
                        }
                        children.add(newSentinelPlugin);
                        continue;
                    }
                    if (folder.members().length == 0 && this.ExcludedFiles.isIgnoreEmptyFolders()) continue;
                    folderObject = (RegularFolderObject)this.objectCache.get(folder);
                    if (folderObject == null) {
                        folderObject = new RegularFolderObject((IFolder)folder, buildFile, pluginType);
                    }
                    children.add(folderObject);
                    continue;
                }
                if (!(resource instanceof RegularFolderObject)) continue;
                folder = (RegularFolderObject)resource;
                buildFile = ((RegularFolderObject)folder).getFolder().getFile(ScriptProperties.getScriptName("build"));
                if (buildFile != null && buildFile.exists()) {
                    newSentinelPlugin = (SentinelPlugin)this.objectCache.get(((RegularFolderObject)folder).getFolder());
                    if (newSentinelPlugin == null) {
                        newSentinelPlugin = new SentinelPlugin(((RegularFolderObject)folder).getFolder(), buildFile, pluginType);
                    }
                    children.add(newSentinelPlugin);
                    continue;
                }
                if (((RegularFolderObject)folder).getFolder().members().length == 0 && this.ExcludedFiles.isIgnoreEmptyFolders()) continue;
                folderObject = (RegularFolderObject)this.objectCache.get(((RegularFolderObject)folder).getFolder());
                if (folderObject == null) {
                    folderObject = new RegularFolderObject(((RegularFolderObject)folder).getFolder(), buildFile, pluginType);
                }
                children.add(folderObject);
            }
            return children.toArray();
        }
        catch (CoreException e) {
            System.out.println("Could not get members of IProject:" + e.toString());
            return new Object[0];
        }
    }

    private Object[] getChildrenOfSentinelPlugin(SentinelPlugin sentinelPlugin) {
        ArrayList<Object> children = new ArrayList<Object>();
        try {
            for (IResource resource : sentinelPlugin.getFolder().members()) {
                PluginType pluginType;
                if (this.isExcludedResource(resource, "Global")) continue;
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    PluginType pluginType2 = SDKUtil.getPluginType(file.getProject());
                    if (this.isExcludedResource(resource, pluginType2.getName())) continue;
                    RegularFileObject fileObject = new RegularFileObject(null, file, pluginType2);
                    children.add(fileObject);
                    continue;
                }
                if (!(resource instanceof IFolder)) continue;
                IFolder folder = (IFolder)resource;
                IFile buildFile = folder.getFile(ScriptProperties.getScriptName("build"));
                if (buildFile != null && buildFile.exists()) {
                    pluginType = SDKUtil.getPluginType(folder.getProject());
                    if (this.isExcludedResource(resource, pluginType.getName())) continue;
                    SentinelPlugin newSentinelPlugin = (SentinelPlugin)this.objectCache.get(folder);
                    if (newSentinelPlugin == null) {
                        newSentinelPlugin = new SentinelPlugin(folder, buildFile, pluginType);
                    }
                    children.add(newSentinelPlugin);
                    continue;
                }
                pluginType = SDKUtil.getPluginType(folder.getProject());
                if (this.isExcludedResource(resource, pluginType.getName())) continue;
                RegularFolderObject folderObject = (RegularFolderObject)this.objectCache.get(folder);
                if (folderObject == null) {
                    folderObject = new RegularFolderObject(folder, buildFile, pluginType);
                }
                children.add(folderObject);
            }
        }
        catch (CoreException e) {
            System.out.println("Could not get members of IFolder:" + e.toString());
        }
        return children.toArray();
    }

    private Object[] getChildrenOfFolder(RegularFolderObject parentFolder) {
        return this.getChildrenOfFolder(parentFolder.getFolder());
    }

    private Object[] getChildrenOfFolder(IFolder parentFolder) {
        ArrayList<Object> children = new ArrayList<Object>();
        try {
            for (IResource resource : parentFolder.members()) {
                PluginType pluginType;
                if (this.isExcludedResource(resource, "Global")) continue;
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    PluginType pluginType2 = SDKUtil.getPluginType(file.getProject());
                    if (this.isExcludedResource(resource, pluginType2.getName())) continue;
                    RegularFileObject fileObject = new RegularFileObject(null, file, pluginType2);
                    children.add(fileObject);
                    continue;
                }
                if (!(resource instanceof IFolder)) continue;
                IFolder folder = (IFolder)resource;
                IFile buildFile = folder.getFile(ScriptProperties.getScriptName("build"));
                if (buildFile != null && buildFile.exists()) {
                    pluginType = SDKUtil.getPluginType(folder.getProject());
                    if (this.isExcludedResource(resource, pluginType.getName())) continue;
                    SentinelPlugin newSentinelPlugin = (SentinelPlugin)this.objectCache.get(folder);
                    if (newSentinelPlugin == null) {
                        newSentinelPlugin = new SentinelPlugin(folder, buildFile, pluginType);
                    }
                    children.add(newSentinelPlugin);
                    continue;
                }
                pluginType = SDKUtil.getPluginType(folder.getProject());
                if (this.isExcludedResource(resource, pluginType.getName())) continue;
                RegularFolderObject folderObject = (RegularFolderObject)this.objectCache.get(folder);
                if (folderObject == null) {
                    folderObject = new RegularFolderObject(folder, buildFile, pluginType);
                }
                children.add(folderObject);
            }
        }
        catch (CoreException e) {
            System.out.println("Could not get members of IFolder:" + e.toString());
        }
        return children.toArray();
    }

    private boolean isExcludedResource(IResource resource, String Nature) {
        int i;
        if (Nature.equalsIgnoreCase("Collector")) {
            Nature = "com.netiq.sentinel.sdk.SentinelCollectorProjectNature";
        } else if (Nature.equalsIgnoreCase("Action")) {
            Nature = "com.netiq.sentinel.sdk.SentinelActionProjectNature";
        } else if (Nature.equalsIgnoreCase("Report")) {
            Nature = "com.netiq.sentinel.sdk.SentinelReportProjectNature";
        } else if (Nature.equalsIgnoreCase("Solution")) {
            Nature = "com.netiq.sentinel.sdk.SentinelSolutionProjectNature";
        } else if (Nature.equalsIgnoreCase("RDD")) {
            Nature = "com.netiq.sentinel.sdk.SentinelRDDProjectNature";
        }
        ArrayList<String> FileList = this.ExcludedFiles.getFilesandFolders(Nature);
        ArrayList<String> ExtList = this.ExcludedFiles.getExtensions(Nature);
        for (i = 0; i < FileList.size(); ++i) {
            if (!resource.getName().equalsIgnoreCase(FileList.get(i))) continue;
            return true;
        }
        for (i = 0; i < ExtList.size(); ++i) {
            if (!resource.getName().endsWith(ExtList.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isElementFiltered(Object element, PluginType pluginType) {
        boolean hideEmptyFiles = Activator.getDefault().getPreferenceStore().getBoolean(SDKConstants.PREF_HIDE_EMPTY_PLUGIN_FOLDERS);
        if (element instanceof SentinelProject) {
            SentinelProject project = (SentinelProject)element;
            if (project.getProject().getName().toLowerCase().contains(this.m_filterByName)) {
                return true;
            }
            try {
                for (IResource resource : project.getProject().members()) {
                    boolean result = this.isElementFiltered(resource, project.getPluginType());
                    if (!result) continue;
                    return result;
                }
            }
            catch (CoreException e) {
                return true;
            }
        }
        if (element instanceof SentinelPlugin) {
            SentinelPlugin plugin = (SentinelPlugin)element;
            if (plugin.getFolder().getFullPath().toOSString().toLowerCase().contains(this.m_filterByName)) {
                return true;
            }
            try {
                for (IResource resource : plugin.getFolder().members()) {
                    boolean result = this.isElementFiltered(resource, plugin.getPluginType());
                    if (!result) continue;
                    return result;
                }
            }
            catch (CoreException e) {
                return true;
            }
        }
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            if (folder.getFullPath().toOSString().toLowerCase().contains(this.m_filterByName)) {
                if (hideEmptyFiles) {
                    try {
                        if (this.isEmptyFolder(folder, pluginType, this.ExcludedFiles.getPluginProjectDepths(pluginType.getNature()))) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return true;
            }
            try {
                for (IResource resource : folder.members()) {
                    boolean result = this.isElementFiltered(resource, pluginType);
                    if (!result) continue;
                    return result;
                }
            }
            catch (CoreException e) {
                return true;
            }
        }
        if (element instanceof RegularFolderObject) {
            RegularFolderObject folder = (RegularFolderObject)element;
            if (folder.getFolder().getFullPath().toOSString().toLowerCase().contains(this.m_filterByName)) {
                if (hideEmptyFiles) {
                    try {
                        if (this.isEmptyFolder(folder.getFolder(), folder.getPluginType(), this.ExcludedFiles.getPluginProjectDepths(pluginType.getNature()))) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return true;
            }
            try {
                for (IResource resource : folder.getFolder().members()) {
                    boolean result = this.isElementFiltered(resource, pluginType);
                    if (!result) continue;
                    return result;
                }
            }
            catch (CoreException e) {
                return true;
            }
        }
        if (element instanceof IFile ? ((IFile)element).getFullPath().toOSString().toLowerCase().contains(this.m_filterByName) : element instanceof RegularFileObject && ((RegularFileObject)element).getFile().getFullPath().toOSString().toLowerCase().contains(this.m_filterByName)) {
            return true;
        }
        return false;
    }

    private boolean isEmptyFolder(IFolder folder, PluginType pluginType, int pluginDepth) throws CoreException {
        int directoryDepth = 0;
        IFolder parent = folder;
        while (parent != null) {
            parent = parent.getParent();
            ++directoryDepth;
        }
        if (directoryDepth > pluginDepth) {
            return false;
        }
        if (folder.members().length == 0) {
            return true;
        }
        for (IResource resource : folder.members()) {
            if (this.isExcludedResource(resource, "Global") || this.isExcludedResource(resource, pluginType.getName())) continue;
            if (resource instanceof IFile) {
                return false;
            }
            if (!(resource instanceof IFolder) || this.isEmptyFolder((IFolder)resource, pluginType, pluginDepth)) continue;
            return false;
        }
        return true;
    }

    public void resourceChanged(IResourceChangeEvent arg0) {
        if (this.viewer != null) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    SentinelSDKContentProvider.this.expandedElements = new ArrayList();
                    if (SentinelSDKContentProvider.this.viewer.getExpandedElements().length > 0) {
                        Collections.addAll(SentinelSDKContentProvider.this.expandedElements, SentinelSDKContentProvider.this.viewer.getExpandedElements());
                    }
                    SentinelSDKContentProvider.this.viewer.refresh();
                    SentinelSDKContentProvider.this.viewer.setExpandedElements(SentinelSDKContentProvider.this.expandedElements.toArray());
                }
            });
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        Object value = event.getElement();
        if (value == null) {
            return;
        }
        IProject key = null;
        if (value instanceof SentinelProject) {
            key = ((SentinelProject)value).getProject();
        } else if (value instanceof SentinelPlugin) {
            key = ((SentinelPlugin)value).getFolder();
        } else if (value instanceof RegularFolderObject) {
            key = ((RegularFolderObject)value).getFolder();
        }
        if (key != null) {
            this.objectCache.remove(key);
        }
    }

    public void treeExpanded(TreeExpansionEvent event) {
        Object value = event.getElement();
        if (value == null) {
            return;
        }
        IProject key = null;
        if (value instanceof SentinelProject) {
            key = ((SentinelProject)value).getProject();
        } else if (value instanceof SentinelPlugin) {
            key = ((SentinelPlugin)value).getFolder();
        } else if (value instanceof RegularFolderObject) {
            key = ((RegularFolderObject)value).getFolder();
        }
        if (key != null) {
            this.objectCache.put(key, value);
        }
    }

    public void applyEmptyFilter() {
        boolean hideEmptyFiles = Activator.getDefault().getPreferenceStore().getBoolean(SDKConstants.PREF_HIDE_EMPTY_PLUGIN_FOLDERS);
        if (!hideEmptyFiles) {
            this.viewer.removeFilter(this.m_emptyFilter);
        } else {
            this.viewer.addFilter(this.m_emptyFilter);
        }
    }

    public void applyNameFilter(String filterByName) {
        this.m_filterByName = filterByName.toLowerCase();
        if (this.m_filterByName == null || this.m_filterByName.length() == 0) {
            this.viewer.removeFilter(this.m_nameFilter);
        } else {
            this.viewer.addFilter(this.m_nameFilter);
        }
    }
}

