/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.views.providers;

import com.netiq.sentinel.sdk.model.RegularFileObject;
import com.netiq.sentinel.sdk.model.RegularFolderObject;
import com.netiq.sentinel.sdk.model.SentinelPlugin;
import com.netiq.sentinel.sdk.model.SentinelProject;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class SentinelSDKLabelProvider
extends LabelProvider {
    private HashMap<String, Image> images = new HashMap();

    public String getText(Object element) {
        if (element instanceof SentinelProject) {
            SentinelProject sentinelProject = (SentinelProject)element;
            String projectName = sentinelProject.getProject().getName();
            try {
                if (sentinelProject.getProject() != null && sentinelProject.getProject().getDescription() != null && sentinelProject.getProject().getDescription().getName() != null && sentinelProject.getProject().getDescription().getName().length() > 0) {
                    projectName = sentinelProject.getProject().getDescription().getName();
                }
            }
            catch (CoreException e) {
                // empty catch block
            }
            return projectName;
        }
        if (element instanceof SentinelPlugin) {
            return ((SentinelPlugin)element).getPluginName();
        }
        if (element instanceof RegularFolderObject) {
            return ((RegularFolderObject)element).getFolder().getName();
        }
        if (element instanceof IFolder) {
            return ((IFolder)element).getName();
        }
        if (element instanceof IFile) {
            return ((IFile)element).getName();
        }
        if (element instanceof RegularFileObject) {
            return ((RegularFileObject)element).getFile().getName();
        }
        if (element instanceof Action) {
            return ((Action)element).getText();
        }
        String text = super.getText(element);
        if (text == null) {
            text = "";
        }
        return text;
    }

    public Image getImage(Object element) {
        if (element instanceof SentinelProject) {
            return ((SentinelProject)element).getImage();
        }
        if (element instanceof SentinelPlugin) {
            return ((SentinelPlugin)element).getImage();
        }
        if (element instanceof RegularFolderObject) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (element instanceof IFolder) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (element instanceof IFile) {
            String fileName = ((IFile)element).getName();
            Image image = this.images.get(fileName);
            if (image == null) {
                image = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(fileName).createImage();
                this.images.put(fileName, image);
            }
            return image;
        }
        if (element instanceof RegularFileObject) {
            String fileName = ((RegularFileObject)element).getFile().getName();
            Image image = this.images.get(fileName);
            if (image == null) {
                image = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(fileName).createImage();
                this.images.put(fileName, image);
            }
            return image;
        }
        if (element instanceof Action) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD");
        }
        Image image = null;
        return image;
    }

    public void dispose() {
        for (String sImageName : this.images.keySet()) {
            Image image = this.images.get(sImageName);
            if (image.isDisposed()) continue;
            image.dispose();
        }
        super.dispose();
    }
}

