/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.widgets;

import com.netiq.sentinel.sdk.Activator;
import com.netiq.sentinel.sdk.Messages;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class HistoryTextField
extends Composite
implements SelectionListener {
    private String m_sUniqueIdentifier;
    private Combo m_combo = new Combo((Composite)this, 0);
    private final String TOKEN = "\n";
    private final int MAX_SIZE = 6;
    private String m_sOriginalText;
    private String m_lastUsedText = "";
    private String[] m_defaultStrings;

    public HistoryTextField(Composite parent, String sUniqueIdentifier) {
        super(parent, 0);
        this.m_combo.addSelectionListener((SelectionListener)this);
        this.setLayout((Layout)new FillLayout());
        this.m_sUniqueIdentifier = sUniqueIdentifier;
        this.populateHistoryFromPreferences();
        this.validator();
    }

    public HistoryTextField(Composite parent, String[] initialStringsToAdd, String sUniqueIdentifier) {
        super(parent, 0);
        this.m_combo.addSelectionListener((SelectionListener)this);
        this.setLayout((Layout)new FillLayout());
        this.m_sUniqueIdentifier = sUniqueIdentifier;
        this.m_defaultStrings = new String[initialStringsToAdd.length];
        for (int i = 0; i < initialStringsToAdd.length; ++i) {
            this.m_defaultStrings[i] = new String(initialStringsToAdd[i]);
            this.m_combo.add(this.m_defaultStrings[i]);
        }
        this.populateHistoryFromPreferences();
        this.validator();
    }

    private void validator() {
        this.m_combo.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (HistoryTextField.this.m_combo.getText() != null) {
                    // empty if block
                }
            }
        });
    }

    private void populateHistoryFromPreferences() {
        String sList = Activator.getDefault().getPluginPreferences().getString(this.m_sUniqueIdentifier);
        if (sList == null || sList.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(sList, "\n");
        while (st.hasMoreTokens()) {
            String sVal = st.nextToken();
            if (this.m_lastUsedText.isEmpty()) {
                this.m_lastUsedText = sVal;
            }
            if (this.m_defaultStrings != null) {
                boolean duplicate = false;
                for (String str : this.m_defaultStrings) {
                    if (!sVal.equals(str)) continue;
                    duplicate = true;
                }
                if (duplicate) continue;
                this.m_combo.add(sVal);
                continue;
            }
            this.m_combo.add(sVal);
        }
        if (this.m_combo.getItemCount() > 0) {
            this.m_combo.add(Messages.HistoryTextField_ClearHistory);
        }
    }

    public void saveToHistory() {
        int iCount = this.m_combo.getItemCount();
        String sNewHistory = this.m_combo.getText();
        if (sNewHistory == null || sNewHistory.length() == 0) {
            return;
        }
        if (iCount == 0) {
            sNewHistory = this.m_sOriginalText != null && !sNewHistory.equals(this.m_sOriginalText) ? sNewHistory + "\n" + this.m_sOriginalText : sNewHistory + "\n";
        } else {
            for (int i = 0; i < iCount && i != 5; ++i) {
                if (this.m_combo.getItem(i).equals(this.m_combo.getText()) || this.m_combo.getItem(i).equals(Messages.HistoryTextField_ClearHistory)) continue;
                sNewHistory = sNewHistory + "\n" + this.m_combo.getItem(i);
            }
        }
        Activator.getDefault().getPreferenceStore().setValue(this.m_sUniqueIdentifier, sNewHistory);
    }

    public void selectFirstInList() {
        if (this.m_combo != null && this.m_combo.getItemCount() > 0) {
            this.m_combo.setText(this.m_combo.getItem(0));
        }
    }

    public String getText() {
        return this.m_combo.getText();
    }

    public void setText(String sVal) {
        if (sVal == null) {
            sVal = "";
        }
        this.m_sOriginalText = sVal;
        this.m_combo.setText(sVal);
    }

    public void addModifyListener(ModifyListener l) {
        this.m_combo.addModifyListener(l);
    }

    public void setEnabled(boolean enable) {
        this.m_combo.setEnabled(enable);
    }

    public Combo getComboControl() {
        return this.m_combo;
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.m_combo.getText().equals(Messages.HistoryTextField_ClearHistory) && this.m_combo.getItemCount() > 1) {
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.SentinelSDK, (String)Messages.HistoryTextField_PromptClear)) {
                Activator.getDefault().getPreferenceStore().setValue(this.m_sUniqueIdentifier, "");
                this.m_combo.removeAll();
                if (this.m_defaultStrings != null) {
                    for (String str : this.m_defaultStrings) {
                        this.m_combo.add(str);
                    }
                }
            } else {
                this.m_combo.select(0);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void refresh() {
        if (this.m_combo.getText() != null && this.m_combo.getText().trim().length() > 0) {
            this.m_combo.removeAll();
            this.populateHistoryFromPreferences();
            this.selectFirstInList();
        }
    }

    public void refreshPreferences() {
        if (this.m_combo != null) {
            this.m_combo.removeAll();
            this.populateHistoryFromPreferences();
        }
    }

    public void useLastUsedText() {
        this.setText(this.m_lastUsedText);
    }
}

