/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.widgets;

import com.netiq.sentinel.sdk.SDKUtil;
import com.netiq.sentinel.sdk.model.PluginImages;
import com.netiq.sentinel.sdk.widgets.HoverButton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;

public class InfoWidget
extends Composite {
    private HoverButton m_btnInfo;
    private String m_title;
    private String m_info;
    private String m_verboseInfo;
    private boolean m_format;

    public InfoWidget(Composite parent, String sTitle, String sInfo) {
        this(parent, sTitle, sInfo, true);
    }

    public InfoWidget(Composite parent, Control nextToControl, String sTitle, String sInfo) {
        this(parent, sTitle, sInfo, true);
        FormData data = new FormData();
        data.left = new FormAttachment(nextToControl, 3);
        this.setLayoutData(data);
    }

    public InfoWidget(Composite parent, Control nextToControl, FormAttachment Top, String sTitle, String sInfo) {
        this(parent, sTitle, sInfo, true);
        FormData data = new FormData();
        data.left = new FormAttachment(nextToControl, 3);
        data.top = Top;
        this.setLayoutData(data);
    }

    public InfoWidget(Composite parent, String sTitle, String sInfo, boolean bFormat) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.m_info = sInfo;
        this.m_title = sTitle;
        this.m_format = bFormat;
        this.m_verboseInfo = null;
        this.m_btnInfo = new HoverButton(this, PluginImages.getInfoImage());
        if (SDKUtil.isLinux() || SDKUtil.isMac() || !this.m_format) {
            this.m_btnInfo.getToolItem().setToolTipText(this.m_info);
        } else {
            this.m_btnInfo.getToolItem().setToolTipText(this.formatToolTipText(this.m_info));
        }
        this.m_btnInfo.getToolItem().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (InfoWidget.this.m_verboseInfo == null) {
                    MessageDialog.openInformation((Shell)InfoWidget.this.getShell(), (String)InfoWidget.this.m_title, (String)InfoWidget.this.m_info);
                } else {
                    MessageDialog.openInformation((Shell)InfoWidget.this.getShell(), (String)InfoWidget.this.m_title, (String)InfoWidget.this.m_verboseInfo);
                }
            }
        });
        this.layout();
    }

    public void setVerboseInfo(String verboseInfo) {
        this.m_verboseInfo = verboseInfo;
    }

    private String formatToolTipText(String sWarning) {
        List<String> lines = new ArrayList<String>();
        GC gc = new GC((Drawable)this);
        lines = SDKUtil.calcWrapLines(gc, lines, sWarning, 250);
        gc.dispose();
        String sReturn = new String();
        for (int i = 0; i < lines.size(); ++i) {
            sReturn = sReturn + lines.get(i) + "\n";
        }
        return sReturn;
    }

    public ToolItem getToolItem() {
        return this.m_btnInfo.getToolItem();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.m_btnInfo.getToolBar().setBackground(color);
    }

    public void setInfo(String sTitle, String sInfo) {
        this.m_title = sTitle;
        this.m_info = sInfo;
        if (SDKUtil.isLinux() || SDKUtil.isMac() || !this.m_format) {
            this.m_btnInfo.getToolItem().setToolTipText(this.m_info);
        } else {
            this.m_btnInfo.getToolItem().setToolTipText(this.formatToolTipText(this.m_info));
        }
    }
}

