/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.widgets;

import com.netiq.sentinel.sdk.Messages;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class OutputProgressMonitorDialog
extends ProgressMonitorDialog
implements IStreamListener {
    private static int LABEL_DLUS = 15;
    private static int BAR_DLUS = 9;
    private Text output;
    private boolean isClosed = false;

    public OutputProgressMonitorDialog(Shell shell) {
        super(shell);
    }

    protected Control createDialogArea(Composite parent) {
        String DEFAULT_TASKNAME = JFaceResources.getString((String)"ProgressMonitorDialog.message");
        this.setMessage(DEFAULT_TASKNAME, false);
        this.createMessageArea(parent);
        this.taskLabel = this.messageLabel;
        this.progressIndicator = new ProgressIndicator(parent);
        GridData gd = new GridData();
        gd.heightHint = this.convertVerticalDLUsToPixels(BAR_DLUS);
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.progressIndicator.setLayoutData((Object)gd);
        this.subTaskLabel = new Label(parent, 16448);
        gd = new GridData(768);
        gd.heightHint = this.convertVerticalDLUsToPixels(LABEL_DLUS);
        gd.horizontalSpan = 2;
        this.subTaskLabel.setLayoutData((Object)gd);
        this.subTaskLabel.setFont(parent.getFont());
        this.output = new Text(parent, 2626);
        this.output.setEditable(false);
        gd = new GridData(768);
        gd.heightHint = 300;
        gd.horizontalSpan = 2;
        this.output.setLayoutData((Object)gd);
        this.output.setFont(parent.getFont());
        return parent;
    }

    private void setMessage(String messageString, boolean force) {
        String string = this.message = messageString == null ? "" : messageString;
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        if (force || this.messageLabel.isVisible()) {
            this.messageLabel.setToolTipText(this.message);
            this.messageLabel.setText(OutputProgressMonitorDialog.shortenText((String)this.message, (Control)this.messageLabel));
        }
    }

    public void streamAppended(final String arg0, IStreamMonitor arg1) {
        if (this.isClosed) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                OutputProgressMonitorDialog.this.output.append(arg0);
            }
        });
    }

    public void useCloseButton(boolean state) {
        Button btn = this.getButton(1);
        btn.setEnabled(state);
        if (state) {
            btn.setText(IDialogConstants.CLOSE_LABEL);
            btn.setToolTipText(Messages.RunInBackGroundTip);
        } else {
            btn.setText(IDialogConstants.CANCEL_LABEL);
            btn.setToolTipText("");
        }
    }

    public boolean close() {
        this.isClosed = true;
        return super.close();
    }
}

