/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.wizards;

import com.netiq.sentinel.sdk.Activator;
import com.netiq.sentinel.sdk.Messages;
import com.netiq.sentinel.sdk.SDKConstants;
import com.netiq.sentinel.sdk.SDKUtil;
import java.io.File;
import java.util.Properties;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CommonPropertiesPage
extends WizardPage {
    private Text iReportPath;
    private String iReportPropFileName;
    private Properties iReportProperties;
    private Button iReportBtn;
    private Text authorName;
    private String devPropFileName;
    private Properties authorProperties;
    private Text openOfficePath;
    private String openOfficePropFileName;
    private Properties openOfficeProperties;
    private Button openOfficeBtn;
    private boolean showAuthor;
    private boolean showIReport;
    private boolean showOpenOffice;
    private static String PLUGINSDK_DIR = ".netiq/pluginsdk";
    private static String IREPORT_FILE = "iReport.properties";
    private static String OPEN_OFFICE_FILE = "oo.properties";
    private static String DEV_FILE = "dev.properties";

    public CommonPropertiesPage() {
        super(Messages.CommonPropertiesPage_PageName);
        this.setTitle(Messages.CommonPropertiesPage_Title);
        this.setDescription(Messages.CommonPropertiesPage_Description);
        this.showAuthor = true;
        this.showIReport = true;
        this.showOpenOffice = true;
    }

    public CommonPropertiesPage(boolean author, boolean iReport, boolean openOffice) {
        super(Messages.CommonPropertiesPage_PageName);
        this.setTitle(Messages.CommonPropertiesPage_Title);
        this.setDescription(Messages.CommonPropertiesPage_Description);
        this.showAuthor = author;
        this.showIReport = iReport;
        this.showOpenOffice = openOffice;
    }

    public void setShowAuthor(boolean shown) {
        this.showAuthor = shown;
    }

    public void setShowIReport(boolean shown) {
        this.showIReport = shown;
    }

    public void setShowOpenOffice(boolean shown) {
        this.showOpenOffice = shown;
    }

    public void createControl(Composite parent) {
        FormData data;
        Label label;
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData gd = new GridData(768);
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        if (this.showAuthor) {
            this.devPropFileName = String.format("%s%s%s%s%s", System.getProperty(SDKConstants.USER_HOME), File.separator, PLUGINSDK_DIR, File.separator, DEV_FILE);
            this.authorProperties = SDKUtil.loadProperties(this.devPropFileName);
            String author = this.authorProperties.getProperty(SDKConstants.PREF_PLUGIN_AUTHOR, "");
            if (author.isEmpty()) {
                label = new Label(container, 0);
                label.setText(Messages.Preference_Author);
                this.authorName = new Text(container, 2052);
                GridData grid = new GridData(768);
                this.authorName.setLayoutData((Object)grid);
                this.authorName.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        CommonPropertiesPage.this.dialogChanged();
                    }
                });
                this.authorName.setText(Activator.getDefault().getPreferenceStore().getString(SDKConstants.PREF_PLUGIN_AUTHOR));
            }
        }
        if (this.showIReport) {
            this.iReportPropFileName = String.format("%s%s%s%s%s", System.getProperty(SDKConstants.USER_HOME), File.separator, PLUGINSDK_DIR, File.separator, IREPORT_FILE);
            this.iReportProperties = SDKUtil.loadProperties(this.iReportPropFileName);
            String iReportPathName = this.iReportProperties.getProperty(SDKConstants.PREF_IREPORT_PATH, "");
            if (iReportPathName.isEmpty()) {
                label = new Label(container, 0);
                label.setText(Messages.Preference_IReportHomeDir);
                Composite reportContainer = new Composite(container, 0);
                reportContainer.setLayoutData((Object)gd);
                reportContainer.setLayout((Layout)new FormLayout());
                data = new FormData();
                data.top = new FormAttachment(0, 0);
                data.left = new FormAttachment(0, 0);
                data.right = new FormAttachment(84, 0);
                this.iReportPath = new Text(reportContainer, 2052);
                this.iReportPath.setLayoutData((Object)data);
                this.iReportPath.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        CommonPropertiesPage.this.dialogChanged();
                    }
                });
                this.iReportBtn = new Button(reportContainer, 8);
                this.iReportBtn.setText(Messages.Browse);
                this.iReportBtn.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }

                    public void widgetSelected(SelectionEvent arg0) {
                        String dir = CommonPropertiesPage.this.browseForDirectory(Messages.Preference_IReportHomeDirExample);
                        if (dir != null && dir.length() > 0) {
                            CommonPropertiesPage.this.iReportPath.setText(dir);
                        }
                    }
                });
                data = new FormData();
                data.left = new FormAttachment((Control)this.iReportPath, 5);
                data.height = 20;
                this.iReportBtn.setLayoutData((Object)data);
                this.iReportPath.setText(Activator.getDefault().getPreferenceStore().getString(SDKConstants.PREF_IREPORT_PATH));
            }
        }
        if (this.showOpenOffice) {
            this.openOfficePropFileName = String.format("%s%s%s%s%s", System.getProperty(SDKConstants.USER_HOME), File.separator, PLUGINSDK_DIR, File.separator, OPEN_OFFICE_FILE);
            this.openOfficeProperties = SDKUtil.loadProperties(this.openOfficePropFileName);
            String openOfficePathName = this.openOfficeProperties.getProperty(SDKConstants.PREF_OPENOFFICE_PATH, "");
            if (openOfficePathName.isEmpty()) {
                label = new Label(container, 0);
                label.setText(Messages.Preference_OpenOfficeHomeDir);
                Composite openOfficeContainer = new Composite(container, 0);
                openOfficeContainer.setLayoutData((Object)gd);
                openOfficeContainer.setLayout((Layout)new FormLayout());
                data = new FormData();
                data.top = new FormAttachment(0, 0);
                data.left = new FormAttachment(0, 0);
                data.right = new FormAttachment(84, 0);
                this.openOfficePath = new Text(openOfficeContainer, 2052);
                this.openOfficePath.setLayoutData((Object)data);
                this.openOfficePath.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        CommonPropertiesPage.this.dialogChanged();
                    }
                });
                this.openOfficeBtn = new Button(openOfficeContainer, 8);
                this.openOfficeBtn.setText(Messages.Browse);
                this.openOfficeBtn.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }

                    public void widgetSelected(SelectionEvent arg0) {
                        String dir = CommonPropertiesPage.this.browseForDirectory(Messages.Preference_OpenOfficeHomeDirExample);
                        if (dir != null && dir.length() > 0) {
                            CommonPropertiesPage.this.openOfficePath.setText(dir);
                        }
                    }
                });
                data = new FormData();
                data.left = new FormAttachment((Control)this.openOfficePath, 5);
                data.height = 20;
                this.openOfficeBtn.setLayoutData((Object)data);
                this.openOfficePath.setText(Activator.getDefault().getPreferenceStore().getString(SDKConstants.PREF_OPENOFFICE_PATH));
            }
        }
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
    }

    private String browseForDirectory(String msg) {
        DirectoryDialog choosePath = new DirectoryDialog(this.getShell());
        choosePath.setMessage(msg);
        return choosePath.open();
    }

    private void dialogChanged() {
        if (this.showAuthor && this.authorName != null && this.authorName.getText().length() == 0) {
            this.updateStatus(Messages.Preference_AuthorExample);
            return;
        }
        if (this.showIReport) {
            if (this.iReportPath != null && this.iReportPath.getText().length() == 0) {
                if (SDKUtil.isWindows()) {
                    this.updateStatus(Messages.Preference_InvalidIReportPathWindows);
                } else {
                    this.updateStatus(Messages.Preference_InvalidIReportPathLinux);
                }
                return;
            }
            if (this.iReportPath != null && !this.checkIReportDirectory()) {
                return;
            }
        }
        if (this.showOpenOffice) {
            if (this.openOfficePath != null && this.openOfficePath.getText().length() == 0) {
                this.updateStatus(Messages.Preference_InvalidOpenOfficePath);
                return;
            }
            if (this.openOfficePath != null && !this.checkOpenOfficeDirectory()) {
                return;
            }
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private boolean checkIReportDirectory() {
        File file = null;
        boolean skipCheck = false;
        String validateText = this.iReportPath.getText().trim();
        if (validateText != null && validateText.length() > 0) {
            if (SDKUtil.isWindows()) {
                file = new File(validateText + File.separator + "iReport.bat");
                if (!file.exists()) {
                    file = new File(validateText + File.separator + "bin" + File.separator + "ireport.exe");
                }
            } else if (SDKUtil.isLinux()) {
                file = new File(validateText + File.separator + "iReport.sh");
                if (!file.exists()) {
                    file = new File(validateText + File.separator + "bin" + File.separator + "ireport");
                }
            } else {
                skipCheck = true;
            }
        }
        if (!(skipCheck || file != null && file.exists())) {
            if (SDKUtil.isWindows()) {
                this.updateStatus(Messages.Preference_InvalidIReportPathWindows);
            } else {
                this.updateStatus(Messages.Preference_InvalidIReportPathLinux);
            }
            return false;
        }
        return true;
    }

    private boolean checkOpenOfficeDirectory() {
        File file = null;
        boolean skipCheck = false;
        String validateText = this.openOfficePath.getText().trim();
        if (validateText != null && validateText.length() > 0) {
            skipCheck = true;
        }
        if (!(skipCheck || file != null && file.exists())) {
            this.updateStatus(Messages.Preference_InvalidOpenOfficePath);
            return false;
        }
        return true;
    }

    public void savePreference() {
        if (this.showAuthor && this.authorName != null && this.authorName.getText().length() > 0) {
            Activator.getDefault().getPreferenceStore().setValue(SDKConstants.PREF_PLUGIN_AUTHOR, this.authorName.getText());
            this.authorProperties.setProperty(SDKConstants.PREF_PLUGIN_AUTHOR, this.authorName.getText());
            SDKUtil.saveProperties(this.devPropFileName.toString(), this.authorProperties, SDKUtil.DEV_PROP_COMMENT);
        }
        if (this.showIReport && this.iReportPath != null && this.iReportPath.getText().length() > 0) {
            Activator.getDefault().getPreferenceStore().setValue(SDKConstants.PREF_IREPORT_PATH, this.iReportPath.getText());
            this.iReportProperties.setProperty(SDKConstants.PREF_IREPORT_PATH, this.iReportPath.getText());
            SDKUtil.saveProperties(this.iReportPropFileName.toString(), this.iReportProperties);
        }
        if (this.showOpenOffice && this.openOfficePath != null && this.openOfficePath.getText().length() > 0) {
            Activator.getDefault().getPreferenceStore().setValue(SDKConstants.PREF_OPENOFFICE_PATH, this.openOfficePath.getText());
            this.openOfficeProperties.setProperty(SDKConstants.PREF_OPENOFFICE_PATH, this.openOfficePath.getText());
            SDKUtil.saveProperties(this.openOfficePropFileName.toString(), this.openOfficeProperties);
        }
    }
}

