/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.wizards;

import com.netiq.sentinel.sdk.Messages;
import com.netiq.sentinel.sdk.SDKConstants;
import com.netiq.sentinel.sdk.SDKUtil;
import com.netiq.sentinel.sdk.actions.BuildType;
import com.netiq.sentinel.sdk.model.Connection;
import com.netiq.sentinel.sdk.model.PluginType;
import com.netiq.sentinel.sdk.widgets.InfoWidget;
import com.netiq.sentinel.sdk.wizards.ISentinelSDKPage;
import java.io.File;
import java.util.Properties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateLuceneConnectionPage
extends WizardPage
implements ISentinelSDKPage {
    private Text m_connectionName;
    private Text m_serverIP;
    private Text m_libDir;
    private Text m_configDir;
    private Text m_authLogin;
    private Text m_userName;
    private Text m_userPwd;
    private Text m_sentinelUser;
    private Text m_sentinelPwd;
    private Text m_JDBC_Database_IP;
    private Text m_JDBC_Database_Port;
    private Text m_JDBC_Database_Name;
    private Text m_JDBC_Database_User_Name;
    private Text m_JDBC_Database_Password;
    private Label m_sentinelUserLabel;
    private Label m_sentinelUserPwdLabel;
    private Combo m_targetPlatform;
    private Button m_buttonYes;
    private Button m_buttonNo;
    Button btnShowAdvancedOptions;
    private boolean m_showDuplicateErrorMessage;
    private String m_connectionChoices = "Create New Lucene Connection";
    private File m_connectionToOverwrite = null;
    private MyFocusListener myFocusListener;
    private static String SENTINEL_LIB_DIR = "/opt/novell/sentinel/lib";
    private static String SENTINEL_CONFIG_DIR = "/etc/opt/novell/sentinel/config";
    private static String SENTINEL_AUTH_LOGIN_DIR = "/var/opt/novell/sentinel/3rdparty/jetty/webapps/ROOT/siemdownloads/auth.login";
    private static String LOG_MANAGER_LIB_DIR = "/opt/novell/sentinel_log_mgr/lib";
    private static String LOG_MANAGER_CONFIG_DIR = "/etc/opt/novell/sentinel_log_mgr/config";
    private static String LOG_MANAGER_AUTH_LOGIN_DIR = "/opt/novell/sentinel_log_mgr/3rdparty/tomcat/webapps/ROOT/novellsiemdownloads/auth.login";
    private static String SENTINELRD_LIB_DIR = "/opt/novell/sentinel_rd/lib";
    private static String SENTINELRD_CONFIG_DIR = "/opt/novell/sentinel_rd/config";
    private static String SENTINELRD_AUTH_LOGIN_DIR = "/opt/novell/sentinel_rd/3rdparty/tomcat/webapps/ROOT/novellsiemdownloads/auth.login";
    private static String CONNECTIONS_DIR = ".netiq/pluginsdk/connections";
    private static String USER_NAME = "root";
    private static String SENTINEL_USER_NAME = "admin";
    private static String JDBC_Database_Port = "5432";
    private static String JDBC_Database_Name = "SIEM";
    private static String JDBC_Database_User = "dbauser";
    private static String Communication_Port = "61616";
    private PluginType m_pluginType;
    private boolean isEdit;
    private String connectionToEdit;
    Composite container;
    private Group advOptionsGroup;
    private Label lblAdvOptionsGroup;
    private Label lblServeLib;
    private InfoWidget defaultLibIW;
    private InfoWidget configDirIW;
    private InfoWidget authLoginIW;
    private Label lblCommunicationPort;
    private Text m_communicationPort;
    private Label lbloptional;

    public CreateLuceneConnectionPage() {
        super(Messages.CreateLuceneConnection_PageName);
        this.setTitle(Messages.CreateLuceneConnection_Title);
        this.setDescription(Messages.CreateLuceneConnection_Description);
        this.m_showDuplicateErrorMessage = true;
        this.myFocusListener = new MyFocusListener();
        this.m_pluginType = PluginType.REPORT;
        this.isEdit = false;
    }

    public CreateLuceneConnectionPage(boolean Edit, String connection) {
        super(Messages.CreateLuceneConnection_PageName);
        this.setTitle(Messages.CreateLuceneConnection_Title);
        this.setDescription(Messages.CreateLuceneConnection_Description);
        this.m_showDuplicateErrorMessage = true;
        this.myFocusListener = new MyFocusListener();
        this.m_pluginType = PluginType.REPORT;
        this.isEdit = true;
        this.connectionToEdit = connection;
    }

    private InfoWidget addInfoWidget(Composite comp, Control control, FormAttachment top, String Title, String Tip) {
        return new InfoWidget(comp, control, top, Title, Tip);
    }

    public void createControl(Composite parent) {
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridData scrollCompositeGridData = new GridData(4, 4, true, true);
        scrollComposite.setLayoutData((Object)scrollCompositeGridData);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.container = new Composite((Composite)scrollComposite, 0);
        this.container.setLayout((Layout)new FormLayout());
        Label lblConnectionName = new Label(this.container, 0);
        FormData fd_lblConnectionName = new FormData();
        fd_lblConnectionName.top = new FormAttachment(0, 10);
        fd_lblConnectionName.left = new FormAttachment(0, 5);
        lblConnectionName.setLayoutData((Object)fd_lblConnectionName);
        lblConnectionName.setText(Messages.CreateLuceneConnectionPage_ConnectionName);
        this.m_connectionName = new Text(this.container, 2052);
        FormData fd_m_connectionName = new FormData();
        fd_m_connectionName.top = new FormAttachment(0, 5);
        fd_m_connectionName.left = new FormAttachment(0, 143);
        this.m_connectionName.setLayoutData((Object)fd_m_connectionName);
        this.m_connectionName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateLuceneConnectionPage.this.m_showDuplicateErrorMessage = true;
                CreateLuceneConnectionPage.this.dialogChanged();
            }
        });
        this.addInfoWidget(this.container, (Control)this.m_connectionName, fd_m_connectionName.top, Messages.CreateLuceneConnectionPage_ConnectionNameTitle, Messages.CreateLuceneConnectionPage_ConnectionNameTip);
        Label lblTargetSentinelPlatform = new Label(this.container, 0);
        FormData fd_lblTargetSentinelPlatform = new FormData();
        fd_lblTargetSentinelPlatform.top = new FormAttachment(0, 50);
        fd_lblTargetSentinelPlatform.left = new FormAttachment(0, 5);
        lblTargetSentinelPlatform.setLayoutData((Object)fd_lblTargetSentinelPlatform);
        lblTargetSentinelPlatform.setText(Messages.CreateLuceneConnectionPage_TargetPlatform);
        String[] targetTypes = new String[]{Messages.CreateLuceneConnectionPage_Sentinel701, Messages.CreateLuceneConnectionPage_Sentinel7, Messages.CreateLuceneConnectionPage_LogManager, Messages.CreateLuceneConnectionPage_SentinelRD};
        this.m_targetPlatform = new Combo(this.container, 12);
        FormData fd_m_targetPlatform = new FormData();
        fd_m_targetPlatform.right = new FormAttachment(100, -552);
        fd_m_targetPlatform.top = new FormAttachment(0, 45);
        fd_m_targetPlatform.left = new FormAttachment(0, 143);
        this.m_targetPlatform.setLayoutData((Object)fd_m_targetPlatform);
        this.m_targetPlatform.setItems(targetTypes);
        this.m_targetPlatform.addFocusListener((FocusListener)this.myFocusListener);
        this.m_targetPlatform.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CreateLuceneConnectionPage.this.m_targetPlatform.getText().equalsIgnoreCase(Messages.CreateLuceneConnectionPage_Sentinel701) || CreateLuceneConnectionPage.this.m_targetPlatform.getText().equalsIgnoreCase(Messages.CreateLuceneConnectionPage_Sentinel7)) {
                    CreateLuceneConnectionPage.this.m_configDir.setText(SENTINEL_CONFIG_DIR);
                    CreateLuceneConnectionPage.this.m_libDir.setText(SENTINEL_LIB_DIR);
                    CreateLuceneConnectionPage.this.m_authLogin.setText(SENTINEL_AUTH_LOGIN_DIR);
                    CreateLuceneConnectionPage.this.setSentinelControlsVisible(true);
                    CreateLuceneConnectionPage.this.m_buttonYes.setSelection(false);
                    CreateLuceneConnectionPage.this.m_buttonNo.setSelection(true);
                } else if (CreateLuceneConnectionPage.this.m_targetPlatform.getText().equalsIgnoreCase(Messages.CreateLuceneConnectionPage_SentinelRD)) {
                    CreateLuceneConnectionPage.this.m_configDir.setText(SENTINELRD_CONFIG_DIR);
                    CreateLuceneConnectionPage.this.m_libDir.setText(SENTINELRD_LIB_DIR);
                    CreateLuceneConnectionPage.this.m_authLogin.setText(SENTINELRD_AUTH_LOGIN_DIR);
                    CreateLuceneConnectionPage.this.setSentinelControlsVisible(false);
                    CreateLuceneConnectionPage.this.m_buttonYes.setSelection(false);
                    CreateLuceneConnectionPage.this.m_buttonNo.setSelection(true);
                } else {
                    CreateLuceneConnectionPage.this.m_configDir.setText(LOG_MANAGER_CONFIG_DIR);
                    CreateLuceneConnectionPage.this.m_libDir.setText(LOG_MANAGER_LIB_DIR);
                    CreateLuceneConnectionPage.this.m_authLogin.setText(LOG_MANAGER_AUTH_LOGIN_DIR);
                    CreateLuceneConnectionPage.this.setSentinelControlsVisible(false);
                    CreateLuceneConnectionPage.this.m_buttonYes.setSelection(false);
                    CreateLuceneConnectionPage.this.m_buttonNo.setSelection(true);
                }
                CreateLuceneConnectionPage.this.dialogChanged();
            }
        });
        Label lblTargetServerIP = new Label(this.container, 0);
        FormData fd_lblTargetServerIP = new FormData();
        fd_lblTargetServerIP.top = new FormAttachment(0, 90);
        fd_lblTargetServerIP.left = new FormAttachment(0, 5);
        lblTargetServerIP.setLayoutData((Object)fd_lblTargetServerIP);
        lblTargetServerIP.setText(Messages.CreateLuceneConnectionPage_ServerIp);
        this.m_serverIP = new Text(this.container, 2052);
        FormData fd_m_serverIP = new FormData();
        fd_m_serverIP.right = new FormAttachment(100, -552);
        fd_m_serverIP.top = new FormAttachment(0, 86);
        fd_m_serverIP.left = new FormAttachment(0, 144);
        this.m_serverIP.setLayoutData((Object)fd_m_serverIP);
        this.m_serverIP.addFocusListener((FocusListener)new MyFocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                String databaseIP = CreateLuceneConnectionPage.this.m_JDBC_Database_IP.getText();
                if (databaseIP.isEmpty()) {
                    CreateLuceneConnectionPage.this.m_JDBC_Database_IP.setText(CreateLuceneConnectionPage.this.m_serverIP.getText());
                }
            }
        });
        this.m_serverIP.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateLuceneConnectionPage.this.dialogChanged();
            }
        });
        Label lblDatabaseName = new Label(this.container, 0);
        FormData fd_lblDatabaseName = new FormData();
        fd_lblDatabaseName.top = new FormAttachment(0, 130);
        fd_lblDatabaseName.left = new FormAttachment(0, 5);
        lblDatabaseName.setLayoutData((Object)fd_lblDatabaseName);
        lblDatabaseName.setText(Messages.CreateLuceneConnectionPage_JDBC_Database_Name);
        this.m_JDBC_Database_Name = new Text(this.container, 2052);
        FormData fd_m_JDBC_Database_Name = new FormData();
        fd_m_JDBC_Database_Name.right = new FormAttachment(100, -552);
        fd_m_JDBC_Database_Name.top = new FormAttachment(0, 126);
        fd_m_JDBC_Database_Name.left = new FormAttachment(0, 144);
        this.m_JDBC_Database_Name.setLayoutData((Object)fd_m_JDBC_Database_Name);
        this.m_JDBC_Database_Name.addFocusListener((FocusListener)this.myFocusListener);
        this.m_JDBC_Database_Name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateLuceneConnectionPage.this.dialogChanged();
            }
        });
        Label lblDatabaseIP = new Label(this.container, 0);
        FormData fd_lblDatabaseIP = new FormData();
        fd_lblDatabaseIP.right = new FormAttachment(100, -417);
        fd_lblDatabaseIP.top = new FormAttachment(0, 126);
        fd_lblDatabaseIP.left = new FormAttachment(100, -531);
        lblDatabaseIP.setLayoutData((Object)fd_lblDatabaseIP);
        lblDatabaseIP.setText(Messages.CreateLuceneConnectionPage_JDBC_Database_IP);
        this.m_JDBC_Database_IP = new Text(this.container, 2052);
        FormData fd_m_JDBC_Database_IP = new FormData();
        fd_m_JDBC_Database_IP.right = new FormAttachment(100, -276);
        fd_m_JDBC_Database_IP.top = new FormAttachment(0, 122);
        fd_m_JDBC_Database_IP.left = new FormAttachment(100, -412);
        this.m_JDBC_Database_IP.setLayoutData((Object)fd_m_JDBC_Database_IP);
        Label lblDatabasePort = new Label(this.container, 0);
        FormData fd_lblDatabasePort = new FormData();
        fd_lblDatabasePort.right = new FormAttachment(100, -187);
        fd_lblDatabasePort.top = new FormAttachment(0, 126);
        fd_lblDatabasePort.left = new FormAttachment(100, -265);
        lblDatabasePort.setLayoutData((Object)fd_lblDatabasePort);
        lblDatabasePort.setText(Messages.CreateLuceneConnectionPage_JDBC_Database_Port);
        this.m_JDBC_Database_Port = new Text(this.container, 2052);
        fd_m_connectionName.right = new FormAttachment(100, -89);
        FormData fd_m_JDBC_Database_Port = new FormData();
        fd_m_JDBC_Database_Port.right = new FormAttachment(100, -89);
        fd_m_JDBC_Database_Port.top = new FormAttachment(0, 122);
        fd_m_JDBC_Database_Port.left = new FormAttachment(100, -181);
        this.m_JDBC_Database_Port.setLayoutData((Object)fd_m_JDBC_Database_Port);
        this.m_JDBC_Database_Port.addFocusListener((FocusListener)this.myFocusListener);
        this.m_JDBC_Database_Port.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateLuceneConnectionPage.this.dialogChanged();
            }
        });
        this.addInfoWidget(this.container, (Control)this.m_JDBC_Database_Port, fd_m_JDBC_Database_Port.top, Messages.CreateLuceneConnectionPage_JDBC_Database_Title, Messages.CreateLuceneConnectionPage_JDBC_Database_Tip);
        Label lblDatabaseUserName = new Label(this.container, 0);
        FormData fd_lblDatabaseUserName = new FormData();
        fd_lblDatabaseUserName.top = new FormAttachment(0, 170);
        fd_lblDatabaseUserName.left = new FormAttachment(0, 5);
        lblDatabaseUserName.setLayoutData((Object)fd_lblDatabaseUserName);
        lblDatabaseUserName.setText(Messages.CreateLuceneConnectionPage_JDBC_Database_User);
        this.m_JDBC_Database_User_Name = new Text(this.container, 2052);
        FormData fd_m_JDBC_Database_User_Name = new FormData();
        fd_m_JDBC_Database_User_Name.right = new FormAttachment(100, -552);
        fd_m_JDBC_Database_User_Name.top = new FormAttachment(0, 166);
        fd_m_JDBC_Database_User_Name.left = new FormAttachment(0, 144);
        this.m_JDBC_Database_User_Name.setLayoutData((Object)fd_m_JDBC_Database_User_Name);
        this.m_JDBC_Database_User_Name.addFocusListener((FocusListener)this.myFocusListener);
        this.m_JDBC_Database_User_Name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateLuceneConnectionPage.this.dialogChanged();
            }
        });
        Label lblDatabasePassword = new Label(this.container, 0);
        FormData fd_lblDatabasePassword = new FormData();
        fd_lblDatabasePassword.right = new FormAttachment(100, -417);
        fd_lblDatabasePassword.top = new FormAttachment(0, 166);
        fd_lblDatabasePassword.left = new FormAttachment(100, -531);
        lblDatabasePassword.setLayoutData((Object)fd_lblDatabasePassword);
        lblDatabasePassword.setText(Messages.CreateLuceneConnectionPage_JDBC_Database_Password);
        this.m_JDBC_Database_Password = new Text(this.container, 0x400804);
        FormData fd_m_JDBC_Database_Password = new FormData();
        fd_m_JDBC_Database_Password.right = new FormAttachment(100, -276);
        fd_m_JDBC_Database_Password.top = new FormAttachment(0, 162);
        fd_m_JDBC_Database_Password.left = new FormAttachment(100, -412);
        this.m_JDBC_Database_Password.setLayoutData((Object)fd_m_JDBC_Database_Password);
        this.m_JDBC_Database_Password.addFocusListener((FocusListener)this.myFocusListener);
        this.m_JDBC_Database_Password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateLuceneConnectionPage.this.dialogChanged();
            }
        });
        this.lbloptional = new Label(this.container, 0);
        FormData fd_lbloptional = new FormData();
        fd_lbloptional.right = new FormAttachment(100, -216);
        fd_lbloptional.top = new FormAttachment((Control)lblDatabasePassword, 0, 128);
        fd_lbloptional.left = new FormAttachment(100, -270);
        this.lbloptional.setLayoutData((Object)fd_lbloptional);
        this.lbloptional.setText(Messages.CreateLuceneConnectionPage_lbloptional_text);
        this.addInfoWidget(this.container, (Control)this.lbloptional, fd_m_JDBC_Database_Password.top, Messages.CreateLuceneConnectionPage_JDBC_Database_User_Title, Messages.CreateLuceneConnectionPage_JDBC_Database_User_Tip);
        Label lblServerUserName = new Label(this.container, 0);
        FormData fd_lblServerUserName = new FormData();
        fd_lblServerUserName.right = new FormAttachment(0, 111);
        fd_lblServerUserName.top = new FormAttachment(0, 210);
        fd_lblServerUserName.left = new FormAttachment(0, 5);
        lblServerUserName.setLayoutData((Object)fd_lblServerUserName);
        lblServerUserName.setText(Messages.CreateLuceneConnectionPage_Username);
        this.m_userName = new Text(this.container, 2052);
        FormData fd_m_userName = new FormData();
        fd_m_userName.right = new FormAttachment(100, -552);
        fd_m_userName.top = new FormAttachment(0, 206);
        fd_m_userName.left = new FormAttachment(0, 144);
        this.m_userName.setLayoutData((Object)fd_m_userName);
        this.m_userName.addFocusListener((FocusListener)this.myFocusListener);
        this.m_userName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateLuceneConnectionPage.this.dialogChanged();
            }
        });
        Label lblServerPassword = new Label(this.container, 0);
        FormData fd_lblServerPassword = new FormData();
        fd_lblServerPassword.right = new FormAttachment(100, -417);
        fd_lblServerPassword.top = new FormAttachment(0, 206);
        fd_lblServerPassword.left = new FormAttachment(100, -531);
        lblServerPassword.setLayoutData((Object)fd_lblServerPassword);
        lblServerPassword.setText(Messages.CreateLuceneConnectionpage_UserPwd);
        this.m_userPwd = new Text(this.container, 0x400804);
        FormData fd_m_userPwd = new FormData();
        fd_m_userPwd.right = new FormAttachment(100, -276);
        fd_m_userPwd.top = new FormAttachment(0, 202);
        fd_m_userPwd.left = new FormAttachment(100, -412);
        this.m_userPwd.setLayoutData((Object)fd_m_userPwd);
        this.m_userPwd.addFocusListener((FocusListener)this.myFocusListener);
        this.m_userPwd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateLuceneConnectionPage.this.dialogChanged();
            }
        });
        this.addInfoWidget(this.container, (Control)this.m_userPwd, fd_m_userPwd.top, Messages.CreateLuceneConnectionPage_UsernameTitle, Messages.CreateLuceneConnectionPage_UsernameTip);
        this.m_sentinelUserLabel = new Label(this.container, 0);
        FormData fd_m_sentinelUserLabel = new FormData();
        fd_m_sentinelUserLabel.right = new FormAttachment(0, 143);
        fd_m_sentinelUserLabel.top = new FormAttachment(0, 250);
        fd_m_sentinelUserLabel.left = new FormAttachment(0, 5);
        this.m_sentinelUserLabel.setLayoutData((Object)fd_m_sentinelUserLabel);
        this.m_sentinelUserLabel.setText(Messages.CreateLuceneConnectionPage_SentinelUser);
        this.m_sentinelUser = new Text(this.container, 2052);
        FormData fd_m_sentinelUser = new FormData();
        fd_m_sentinelUser.right = new FormAttachment(100, -552);
        fd_m_sentinelUser.top = new FormAttachment(0, 246);
        fd_m_sentinelUser.left = new FormAttachment(0, 143);
        this.m_sentinelUser.setLayoutData((Object)fd_m_sentinelUser);
        this.m_sentinelUser.addFocusListener((FocusListener)this.myFocusListener);
        this.m_sentinelUser.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateLuceneConnectionPage.this.dialogChanged();
            }
        });
        this.m_sentinelUserPwdLabel = new Label(this.container, 0);
        FormData fd_m_sentinelUserPwdLabel = new FormData();
        fd_m_sentinelUserPwdLabel.right = new FormAttachment(100, -416);
        fd_m_sentinelUserPwdLabel.top = new FormAttachment(0, 246);
        fd_m_sentinelUserPwdLabel.left = new FormAttachment(100, -531);
        this.m_sentinelUserPwdLabel.setLayoutData((Object)fd_m_sentinelUserPwdLabel);
        this.m_sentinelUserPwdLabel.setText(Messages.CreateLuceneConnectionPage_SentinelPwd);
        this.m_sentinelPwd = new Text(this.container, 0x400804);
        FormData fd_m_sentinelPwd = new FormData();
        fd_m_sentinelPwd.right = new FormAttachment(100, -276);
        fd_m_sentinelPwd.top = new FormAttachment(0, 241);
        fd_m_sentinelPwd.left = new FormAttachment(100, -412);
        this.m_sentinelPwd.setLayoutData((Object)fd_m_sentinelPwd);
        this.m_sentinelPwd.addFocusListener((FocusListener)this.myFocusListener);
        this.m_sentinelPwd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateLuceneConnectionPage.this.dialogChanged();
            }
        });
        this.addInfoWidget(this.container, (Control)this.m_sentinelPwd, fd_m_sentinelPwd.top, Messages.CreateLuceneConnectionPage_SentinelUserTitle, Messages.CreateLuceneConnectionPage_SentinelUserTip);
        this.btnShowAdvancedOptions = new Button(this.container, 32);
        FormData fd_btnShowAdvancedOptions = new FormData();
        fd_btnShowAdvancedOptions.right = new FormAttachment(0, 163);
        fd_btnShowAdvancedOptions.top = new FormAttachment(0, 286);
        fd_btnShowAdvancedOptions.left = new FormAttachment(0, 12);
        this.btnShowAdvancedOptions.setLayoutData((Object)fd_btnShowAdvancedOptions);
        this.btnShowAdvancedOptions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateLuceneConnectionPage.this.btnShowAdvancedOptions.getSelection()) {
                    CreateLuceneConnectionPage.this.enableAdvancedOptions(true);
                } else {
                    CreateLuceneConnectionPage.this.enableAdvancedOptions(false);
                }
            }
        });
        this.btnShowAdvancedOptions.setText(Messages.CreateLuceneConnectionPage_btnShowAdvancedOptions_text);
        this.advOptionsGroup = new Group(this.container, 0);
        FormData fd_advOptionsGroup = new FormData();
        fd_advOptionsGroup.right = new FormAttachment((Control)this.m_connectionName, 0, 131072);
        fd_advOptionsGroup.bottom = new FormAttachment(0, 579);
        fd_advOptionsGroup.top = new FormAttachment(0, 308);
        fd_advOptionsGroup.left = new FormAttachment(0, 12);
        this.advOptionsGroup.setLayoutData((Object)fd_advOptionsGroup);
        this.advOptionsGroup.setText("");
        this.advOptionsGroup.setLayout((Layout)new FormLayout());
        this.lblAdvOptionsGroup = new Label((Composite)this.advOptionsGroup, 0);
        FormData fd_lblAdvOptionsGroup = new FormData();
        fd_lblAdvOptionsGroup.right = new FormAttachment(0, 190);
        fd_lblAdvOptionsGroup.top = new FormAttachment(0, 14);
        fd_lblAdvOptionsGroup.left = new FormAttachment(0, 10);
        this.lblAdvOptionsGroup.setLayoutData((Object)fd_lblAdvOptionsGroup);
        this.lblAdvOptionsGroup.setText(Messages.CreateLuceneConnectionPage_UpdateJar);
        this.m_buttonYes = new Button((Composite)this.advOptionsGroup, 16);
        FormData fd_m_buttonYes = new FormData();
        fd_m_buttonYes.bottom = new FormAttachment(0, 55);
        fd_m_buttonYes.top = new FormAttachment(0, 35);
        fd_m_buttonYes.left = new FormAttachment(0, 13);
        this.m_buttonYes.setLayoutData((Object)fd_m_buttonYes);
        this.m_buttonYes.setText(Messages.NewSentinelActionPluginPage_Yes);
        this.m_buttonYes.addFocusListener((FocusListener)this.myFocusListener);
        this.m_buttonYes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateLuceneConnectionPage.this.dialogChanged();
            }
        });
        this.m_buttonNo = new Button((Composite)this.advOptionsGroup, 16);
        FormData fd_m_buttonNo = new FormData();
        fd_m_buttonNo.bottom = new FormAttachment(0, 55);
        fd_m_buttonNo.right = new FormAttachment(0, 98);
        fd_m_buttonNo.top = new FormAttachment(0, 35);
        fd_m_buttonNo.left = new FormAttachment(0, 58);
        this.m_buttonNo.setLayoutData((Object)fd_m_buttonNo);
        this.m_buttonNo.setText(Messages.NewSentinelActionPluginPage_No);
        this.m_buttonNo.addFocusListener((FocusListener)this.myFocusListener);
        this.m_buttonNo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateLuceneConnectionPage.this.dialogChanged();
            }
        });
        this.lblServeLib = new Label((Composite)this.advOptionsGroup, 0);
        FormData fd_lblServeLib = new FormData();
        fd_lblServeLib.top = new FormAttachment(0, 69);
        fd_lblServeLib.left = new FormAttachment(0, 4);
        this.lblServeLib.setLayoutData((Object)fd_lblServeLib);
        this.lblServeLib.setText(Messages.CreateLuceneConnectionPage_ServerLib);
        this.m_libDir = new Text((Composite)this.advOptionsGroup, 2052);
        FormData fd_m_libDir = new FormData();
        fd_m_libDir.right = new FormAttachment(100, -85);
        fd_m_libDir.top = new FormAttachment(0, 90);
        fd_m_libDir.left = new FormAttachment(0, 11);
        this.m_libDir.setLayoutData((Object)fd_m_libDir);
        this.m_libDir.addFocusListener((FocusListener)this.myFocusListener);
        this.m_libDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateLuceneConnectionPage.this.dialogChanged();
            }
        });
        Button useDefaultLibDir = new Button((Composite)this.advOptionsGroup, 8);
        FormData fd_useDefaultLibDir = new FormData();
        fd_useDefaultLibDir.right = new FormAttachment(100, -29);
        fd_useDefaultLibDir.top = new FormAttachment(0, 86);
        fd_useDefaultLibDir.left = new FormAttachment(100, -79);
        useDefaultLibDir.setLayoutData((Object)fd_useDefaultLibDir);
        useDefaultLibDir.setText(Messages.Default);
        useDefaultLibDir.addFocusListener((FocusListener)this.myFocusListener);
        useDefaultLibDir.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                if (CreateLuceneConnectionPage.this.m_targetPlatform.getText().equalsIgnoreCase(Messages.CreateLuceneConnectionPage_Sentinel701) || CreateLuceneConnectionPage.this.m_targetPlatform.getText().equalsIgnoreCase(Messages.CreateLuceneConnectionPage_Sentinel7)) {
                    CreateLuceneConnectionPage.this.m_libDir.setText(SENTINEL_LIB_DIR);
                } else if (CreateLuceneConnectionPage.this.m_targetPlatform.getText().equalsIgnoreCase(Messages.CreateLuceneConnectionPage_SentinelRD)) {
                    CreateLuceneConnectionPage.this.m_libDir.setText(SENTINELRD_LIB_DIR);
                } else {
                    CreateLuceneConnectionPage.this.m_libDir.setText(LOG_MANAGER_LIB_DIR);
                }
            }
        });
        this.defaultLibIW = this.addInfoWidget((Composite)this.advOptionsGroup, (Control)useDefaultLibDir, fd_useDefaultLibDir.top, Messages.CreateLuceneConnectionPage_ServerLibTitle, Messages.CreateLuceneConnectionPage_ServerLibTip);
        Label lblServerConfig = new Label((Composite)this.advOptionsGroup, 0);
        FormData fd_lblServerConfig = new FormData();
        fd_lblServerConfig.right = new FormAttachment(0, 207);
        fd_lblServerConfig.top = new FormAttachment(0, 132);
        fd_lblServerConfig.left = new FormAttachment(0, 4);
        lblServerConfig.setLayoutData((Object)fd_lblServerConfig);
        lblServerConfig.setText(Messages.CreateLuceneConnectionPage_ServerConfig);
        this.m_configDir = new Text((Composite)this.advOptionsGroup, 2052);
        FormData fd_m_configDir = new FormData();
        fd_m_configDir.right = new FormAttachment(100, -85);
        fd_m_configDir.top = new FormAttachment(0, 153);
        fd_m_configDir.left = new FormAttachment(0, 11);
        this.m_configDir.setLayoutData((Object)fd_m_configDir);
        this.m_configDir.addFocusListener((FocusListener)this.myFocusListener);
        this.m_configDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateLuceneConnectionPage.this.dialogChanged();
            }
        });
        Button useDefaultConfigDir = new Button((Composite)this.advOptionsGroup, 8);
        FormData fd_useDefaultConfigDir = new FormData();
        fd_useDefaultConfigDir.right = new FormAttachment(100, -26);
        fd_useDefaultConfigDir.top = new FormAttachment(0, 151);
        fd_useDefaultConfigDir.left = new FormAttachment(100, -79);
        useDefaultConfigDir.setLayoutData((Object)fd_useDefaultConfigDir);
        useDefaultConfigDir.setText(Messages.Default);
        useDefaultConfigDir.addFocusListener((FocusListener)this.myFocusListener);
        useDefaultConfigDir.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                if (CreateLuceneConnectionPage.this.m_targetPlatform.getText().equalsIgnoreCase(Messages.CreateLuceneConnectionPage_Sentinel701) || CreateLuceneConnectionPage.this.m_targetPlatform.getText().equalsIgnoreCase(Messages.CreateLuceneConnectionPage_Sentinel7)) {
                    CreateLuceneConnectionPage.this.m_configDir.setText(SENTINEL_CONFIG_DIR);
                } else if (CreateLuceneConnectionPage.this.m_targetPlatform.getText().equalsIgnoreCase(Messages.CreateLuceneConnectionPage_SentinelRD)) {
                    CreateLuceneConnectionPage.this.m_configDir.setText(SENTINELRD_CONFIG_DIR);
                } else {
                    CreateLuceneConnectionPage.this.m_configDir.setText(LOG_MANAGER_CONFIG_DIR);
                }
            }
        });
        this.configDirIW = this.addInfoWidget((Composite)this.advOptionsGroup, (Control)useDefaultConfigDir, fd_useDefaultConfigDir.top, Messages.CreateLuceneConnectionPage_ServerConfigTitle, Messages.CreateLuceneConnectionPage_ServerConfigTip);
        Label lblAuthorLogin = new Label((Composite)this.advOptionsGroup, 0);
        FormData fd_lblAuthorLogin = new FormData();
        fd_lblAuthorLogin.top = new FormAttachment(0, 195);
        fd_lblAuthorLogin.left = new FormAttachment(0, 4);
        lblAuthorLogin.setLayoutData((Object)fd_lblAuthorLogin);
        lblAuthorLogin.setText(Messages.CreateLuceneConnectionPage_AuthorLogin);
        this.m_authLogin = new Text((Composite)this.advOptionsGroup, 2052);
        this.m_authLogin.setText("");
        FormData fd_m_authLogin = new FormData();
        fd_m_authLogin.right = new FormAttachment(100, -85);
        fd_m_authLogin.top = new FormAttachment(0, 216);
        fd_m_authLogin.left = new FormAttachment(0, 11);
        this.m_authLogin.setLayoutData((Object)fd_m_authLogin);
        this.m_authLogin.addFocusListener((FocusListener)this.myFocusListener);
        this.m_authLogin.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateLuceneConnectionPage.this.dialogChanged();
            }
        });
        Button useDefaultAuthLogin = new Button((Composite)this.advOptionsGroup, 8);
        FormData fd_useDefaultAuthLogin = new FormData();
        fd_useDefaultAuthLogin.right = new FormAttachment(100, -26);
        fd_useDefaultAuthLogin.top = new FormAttachment(0, 214);
        fd_useDefaultAuthLogin.left = new FormAttachment(100, -79);
        useDefaultAuthLogin.setLayoutData((Object)fd_useDefaultAuthLogin);
        useDefaultAuthLogin.setText(Messages.Default);
        this.authLoginIW = this.addInfoWidget((Composite)this.advOptionsGroup, (Control)useDefaultAuthLogin, fd_useDefaultAuthLogin.top, Messages.CreateLuceneConnectionPage_ServerAuthLoginTitle, Messages.CreateLuceneConnectionPage_ServerAuthLoginTip);
        this.lblCommunicationPort = new Label(this.container, 0);
        FormData fd_lblCommunicationPort = new FormData();
        fd_lblCommunicationPort.right = new FormAttachment(100, -417);
        fd_lblCommunicationPort.top = new FormAttachment(0, 90);
        fd_lblCommunicationPort.left = new FormAttachment(100, -531);
        this.lblCommunicationPort.setLayoutData((Object)fd_lblCommunicationPort);
        this.lblCommunicationPort.setText(Messages.CreateLuceneConnectionPage_lblCommuncationPort_text);
        this.m_communicationPort = new Text(this.container, 2048);
        FormData fd_m_communicationPort = new FormData();
        fd_m_communicationPort.right = new FormAttachment(100, -276);
        fd_m_communicationPort.top = new FormAttachment(0, 84);
        fd_m_communicationPort.left = new FormAttachment(100, -412);
        this.m_communicationPort.setLayoutData((Object)fd_m_communicationPort);
        this.m_communicationPort.setText(Communication_Port);
        useDefaultAuthLogin.addFocusListener((FocusListener)this.myFocusListener);
        useDefaultAuthLogin.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                if (CreateLuceneConnectionPage.this.m_targetPlatform.getText().equalsIgnoreCase(Messages.CreateLuceneConnectionPage_Sentinel701) || CreateLuceneConnectionPage.this.m_targetPlatform.getText().equalsIgnoreCase(Messages.CreateLuceneConnectionPage_Sentinel7)) {
                    CreateLuceneConnectionPage.this.m_authLogin.setText(SENTINEL_AUTH_LOGIN_DIR);
                } else if (CreateLuceneConnectionPage.this.m_targetPlatform.getText().equalsIgnoreCase(Messages.CreateLuceneConnectionPage_Sentinel701)) {
                    CreateLuceneConnectionPage.this.m_authLogin.setText(SENTINELRD_AUTH_LOGIN_DIR);
                } else {
                    CreateLuceneConnectionPage.this.m_authLogin.setText(LOG_MANAGER_AUTH_LOGIN_DIR);
                }
            }
        });
        this.setErrorMessage(null);
        this.setPageComplete(false);
        this.initialize();
        scrollComposite.setContent((Control)this.container);
        this.setControl((Control)scrollComposite);
    }

    private void enableAdvancedOptions(boolean Enable) {
        for (Control C : this.advOptionsGroup.getChildren()) {
            if (C.equals((Object)this.authLoginIW) || C.equals((Object)this.configDirIW) || C.equals((Object)this.defaultLibIW)) continue;
            C.setEnabled(Enable);
        }
    }

    private void initialize() {
        this.m_targetPlatform.setText(Messages.CreateLuceneConnectionPage_Sentinel701);
        this.m_configDir.setText(SENTINEL_CONFIG_DIR);
        this.m_libDir.setText(SENTINEL_LIB_DIR);
        this.m_userName.setText(USER_NAME);
        this.m_sentinelUser.setText(SENTINEL_USER_NAME);
        this.m_buttonNo.setSelection(true);
        if (this.m_pluginType == PluginType.SOLUTION || this.m_pluginType == PluginType.COLLECTOR) {
            this.m_targetPlatform.setEnabled(false);
        }
        this.m_JDBC_Database_Name.setText(JDBC_Database_Name);
        this.m_JDBC_Database_Port.setText(JDBC_Database_Port);
        this.m_JDBC_Database_User_Name.setText(JDBC_Database_User);
        this.m_communicationPort.setText(Communication_Port);
        this.enableAdvancedOptions(false);
        if (this.isEdit) {
            this.fillValues();
        }
    }

    private void fillValues() {
        String connectionHome = System.getProperty(SDKConstants.USER_HOME) + File.separator + CONNECTIONS_DIR + File.separator + this.connectionToEdit;
        Properties props = SDKUtil.loadProperties(connectionHome + File.separator + "config" + File.separator + "sentinelreport.properties");
        this.m_connectionName.setText(this.connectionToEdit);
        this.m_targetPlatform.setText(props.getProperty("sentinel.sdk.targettype"));
        this.m_serverIP.setText(props.getProperty("activemq.ip.server"));
        this.m_communicationPort.setText(props.getProperty("activemq.port.userapps"));
        this.m_libDir.setText(props.getProperty("sentinel.sdk.serverlibdir"));
        this.m_configDir.setText(props.getProperty("sentinel.sdk.serverconfigdir"));
        this.m_authLogin.setText(props.getProperty("sentinel.sdk.serverauthfile"));
        this.m_userName.setText(props.getProperty("sentinel.sdk.serverusername"));
        this.m_sentinelUser.setText(props.getProperty("novell.sentinel.reports.initiatinguser"));
        this.m_JDBC_Database_Name.setText(props.getProperty("sentinel.sdk.databasename"));
        this.m_JDBC_Database_IP.setText(props.getProperty("sentinel.sdk.databaseip"));
        this.m_JDBC_Database_Port.setText(props.getProperty("sentinel.sdk.databaseport"));
        this.m_JDBC_Database_User_Name.setText(props.getProperty("sentinel.sdk.databaseusername"));
        if (props.getProperty("sentinel.sdk.getupdatedjars").equalsIgnoreCase("no")) {
            this.m_buttonYes.setSelection(false);
            this.m_buttonNo.setSelection(true);
        } else {
            this.m_buttonYes.setSelection(true);
            this.m_buttonNo.setSelection(false);
        }
    }

    private void dialogChanged() {
        if (this.m_connectionName.getText().length() == 0) {
            this.updateStatus(Messages.CreateLuceneConnectionPage_ConnectionError);
            return;
        }
        if (this.m_serverIP.getText().length() == 0) {
            this.updateStatus(Messages.CreateLuceneConnectionPage_ServerIPError);
            return;
        }
        if (this.m_communicationPort.getText().length() == 0) {
            this.m_communicationPort.setText(Communication_Port);
            return;
        }
        if (this.m_configDir.getText().length() == 0) {
            this.updateStatus(Messages.CreateLuceneConnectionPage_ConfigDirError);
            return;
        }
        if (this.m_userName.getText().length() == 0) {
            this.updateStatus(Messages.CreateLuceneConnectionPage_UserNameError);
            return;
        }
        if (this.m_userPwd.getText().length() == 0) {
            this.updateStatus(Messages.CreateLuceneConnectionPage_UserPwdError);
            return;
        }
        if (this.m_JDBC_Database_Name.getText().length() == 0) {
            this.updateStatus(Messages.CreateLuceneConnectionPage_JDBCBatabaseNameError);
            return;
        }
        if (this.m_JDBC_Database_IP.getText().length() == 0) {
            this.updateStatus(Messages.CreateLuceneConnectionPage_JDBCBatabaseIPError);
            return;
        }
        if (this.m_JDBC_Database_Port.getText().length() == 0) {
            this.updateStatus(Messages.CreateLuceneConnectionPage_JDBCBatabasePortError);
            return;
        }
        if (this.m_JDBC_Database_User_Name.getText().length() == 0) {
            this.updateStatus(Messages.CreateLuceneConnectionPage_JDBCBatabaseUserNameError);
            return;
        }
        if (this.m_targetPlatform.getText().equalsIgnoreCase(Messages.CreateLuceneConnectionPage_Sentinel701) || this.m_targetPlatform.getText().equalsIgnoreCase(Messages.CreateLuceneConnectionPage_Sentinel7)) {
            if (this.m_sentinelUser.getText().length() == 0) {
                this.updateStatus(Messages.CreateLuceneConnectionPage_SentinelUserError);
                return;
            }
            if (this.m_sentinelPwd.getText().length() == 0) {
                this.updateStatus(Messages.CreateLuceneConnectionPage_SentinelPwdError);
                return;
            }
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void setSentinelControlsVisible(boolean state) {
        this.m_sentinelUser.setVisible(state);
        this.m_sentinelUserLabel.setVisible(state);
        this.m_sentinelPwd.setVisible(state);
        this.m_sentinelUserPwdLabel.setVisible(state);
    }

    private boolean isDuplicateConnectionName() {
        if (this.m_connectionName.getText().length() == 0) {
            return false;
        }
        String connectionHome = System.getProperty(SDKConstants.USER_HOME) + File.separator + CONNECTIONS_DIR + File.separator + this.m_connectionName.getText();
        File dir = new File(connectionHome);
        if (dir.isDirectory() && this.m_showDuplicateErrorMessage) {
            boolean result = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.CreateLuceneConnection_Title, (String)NLS.bind((String)Messages.CreateLuceneConnectionPage_OverwriteConnection, (Object)connectionHome));
            if (!result) {
                this.m_connectionName.setFocus();
                this.m_connectionToOverwrite = null;
                return true;
            }
            this.m_connectionToOverwrite = dir;
            this.m_showDuplicateErrorMessage = false;
        }
        return false;
    }

    @Override
    public String getArguments() {
        Connection connection = this.getConnectionInfo();
        if (this.m_pluginType == PluginType.SOLUTION) {
            return connection.getArguments(BuildType.EDIT_SOLUTION_PACK.getTarget());
        }
        if (this.m_pluginType == PluginType.COLLECTOR) {
            return connection.getArguments(BuildType.EDIT_COLLECTOR_PACK.getTarget());
        }
        return connection.getArguments(BuildType.EDIT_REPORT.getTarget());
    }

    public Connection getConnectionInfo() {
        String platform = SDKConstants.SENTINEL_PLATFORM;
        if (this.m_targetPlatform.getText().equalsIgnoreCase(Messages.CreateLuceneConnectionPage_LogManager)) {
            platform = SDKConstants.LOG_MANAGER_PLATFORM;
        } else if (this.m_targetPlatform.getText().equalsIgnoreCase(Messages.CreateLuceneConnectionPage_Sentinel7)) {
            platform = SDKConstants.SENTINEL7_PLATFORM;
        } else if (this.m_targetPlatform.getText().equalsIgnoreCase(Messages.CreateLuceneConnectionPage_SentinelRD)) {
            platform = SDKConstants.SENTINELRD_PLATFORM;
        }
        Connection connection = new Connection();
        connection.setConnectionChoices(this.m_connectionChoices);
        connection.setConnectionName(this.m_connectionName.getText());
        connection.setTargetPlatform(platform);
        connection.setServerIP(this.m_serverIP.getText());
        connection.setCommunicationPort(this.m_communicationPort.getText());
        connection.setTargetLibDir(this.m_libDir.getText());
        connection.setTargetConfigDir(this.m_configDir.getText());
        connection.setServerAuthFile(this.m_authLogin.getText());
        connection.setUpateJars(this.m_buttonYes.getSelection());
        connection.setTargetUserName(this.m_userName.getText());
        connection.setTargetPassword(this.m_userPwd.getText());
        connection.setSentinelUser(this.m_sentinelUser.getText());
        connection.setSentinelPassword(this.m_sentinelPwd.getText());
        connection.setJDBCDatabase(this.m_JDBC_Database_Name.getText());
        connection.setJDBCDatabaseIP(this.m_JDBC_Database_IP.getText());
        connection.setJDBCDatabasePort(this.m_JDBC_Database_Port.getText());
        connection.setJDBCDatabaseUser(this.m_JDBC_Database_User_Name.getText());
        connection.setJDBCDatabasePassword(this.m_JDBC_Database_Password.getText());
        connection.setConnectionToOverwrite(this.m_connectionToOverwrite);
        return connection;
    }

    @Override
    public boolean onPerformFinish() {
        return !this.isEdit || !this.isDuplicateConnectionName();
    }

    @Override
    public Point getPreferredSize() {
        return new Point(850, 800);
    }

    public void setPluginType(PluginType pluginType) {
        this.m_pluginType = pluginType;
    }

    class MyFocusListener
    implements FocusListener {
        private boolean inUsed = false;

        MyFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            if (!this.inUsed) {
                this.inUsed = true;
                if (!CreateLuceneConnectionPage.this.isEdit) {
                    CreateLuceneConnectionPage.this.isDuplicateConnectionName();
                }
                this.inUsed = false;
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

