/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.wizards;

import com.netiq.sentinel.sdk.Activator;
import com.netiq.sentinel.sdk.Messages;
import com.netiq.sentinel.sdk.SDKConstants;
import com.netiq.sentinel.sdk.SDKUtil;
import com.netiq.sentinel.sdk.actions.BuildType;
import com.netiq.sentinel.sdk.model.PluginType;
import com.netiq.sentinel.sdk.wizards.ISentinelSDKPage;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EditReportPluginPage
extends WizardPage
implements ISentinelSDKPage {
    private Combo sentinelConnection;
    private Text iReportPath;
    private String iReportPropFileName;
    private Properties iReportProperties;
    private Button iReportBtn;
    private Text authorName;
    private String devPropFileName;
    private Properties authorProperties;
    private Text editNote;
    private static String PLUGINSDK_DIR = ".netiq" + File.separator + "pluginsdk";
    private static String CONNECTIONS_DIR = ".netiq" + File.separator + "pluginsdk" + File.separator + "connections";
    private static String IREPORT_FILE = "iReport.properties";
    private static String DEV_FILE = "dev.properties";
    private static String CONNECTION_NAME = "iReport.preview.connection";
    private static String CONNECTION_NONE = Messages.Common_None;
    private static String CONNECTION_NEW = Messages.Common_Create_Connection;
    private PluginType m_pluginType;

    public EditReportPluginPage() {
        super(Messages.EditReportPluginPage_PageName);
        this.setTitle(Messages.EditReportPluginPage_Title);
        this.setDescription(Messages.EditReportPluginPage_Description);
        this.m_pluginType = PluginType.REPORT;
    }

    public void createControl(Composite parent) {
        Label label;
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridData scrollCompositeGridData = new GridData(1808);
        scrollComposite.setLayoutData((Object)scrollCompositeGridData);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        Composite container = new Composite((Composite)scrollComposite, 0);
        GridLayout layout = new GridLayout();
        GridData gd = new GridData(768);
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        this.devPropFileName = String.format("%s%s%s%s%s", System.getProperty(SDKConstants.USER_HOME), File.separator, PLUGINSDK_DIR, File.separator, DEV_FILE);
        this.authorProperties = SDKUtil.loadProperties(this.devPropFileName);
        String author = this.authorProperties.getProperty(SDKConstants.PREF_PLUGIN_AUTHOR, "");
        if (author.isEmpty()) {
            Label label2 = new Label(container, 0);
            label2.setText(Messages.Preference_Author);
            this.authorName = new Text(container, 2052);
            GridData grid = new GridData(768);
            this.authorName.setLayoutData((Object)grid);
            this.authorName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    EditReportPluginPage.this.dialogChanged();
                }
            });
            this.authorName.setText(Activator.getDefault().getPreferenceStore().getString(SDKConstants.PREF_PLUGIN_AUTHOR));
        }
        this.iReportPropFileName = String.format("%s%s%s%s%s", System.getProperty(SDKConstants.USER_HOME), File.separator, PLUGINSDK_DIR, File.separator, IREPORT_FILE);
        this.iReportProperties = SDKUtil.loadProperties(this.iReportPropFileName);
        String iReportPathName = this.iReportProperties.getProperty(SDKConstants.PREF_IREPORT_PATH, "");
        if (iReportPathName.isEmpty() && this.m_pluginType == PluginType.REPORT) {
            this.setDescription(Messages.EditReportPluginPage_Description1);
            label = new Label(container, 0);
            label.setText(Messages.Preference_IReportHomeDir);
            Composite reportContainer = new Composite(container, 0);
            reportContainer.setLayoutData((Object)gd);
            reportContainer.setLayout((Layout)new FormLayout());
            FormData data = new FormData();
            data.top = new FormAttachment(0, 0);
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(84, 0);
            this.iReportPath = new Text(reportContainer, 2052);
            this.iReportPath.setLayoutData((Object)gd);
            this.iReportPath.setLayoutData((Object)data);
            this.iReportPath.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    EditReportPluginPage.this.dialogChanged();
                }
            });
            this.iReportBtn = new Button(reportContainer, 8);
            GridData gdBtn = new GridData();
            this.iReportBtn.setLayoutData((Object)gdBtn);
            this.iReportBtn.setText(Messages.Browse);
            this.iReportBtn.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }

                public void widgetSelected(SelectionEvent arg0) {
                    String dir = EditReportPluginPage.this.browseForDirectory(Messages.Preference_IReportHomeDirExample);
                    if (dir != null && dir.length() > 0) {
                        EditReportPluginPage.this.iReportPath.setText(dir);
                    }
                }
            });
            data = new FormData();
            data.left = new FormAttachment((Control)this.iReportPath, 5);
            data.height = 20;
            this.iReportBtn.setLayoutData((Object)data);
            this.iReportPath.setText(Activator.getDefault().getPreferenceStore().getString(SDKConstants.PREF_IREPORT_PATH));
        }
        label = new Label(container, 0);
        label.setText(Messages.EditReportPluginPage_SelectConnection);
        this.sentinelConnection = new Combo(container, 8);
        this.sentinelConnection.add(CONNECTION_NEW);
        this.sentinelConnection.add(CONNECTION_NONE);
        String connectionHome = String.format("%s%s%s", System.getProperty(SDKConstants.USER_HOME), File.separator, CONNECTIONS_DIR);
        File dir = new File(connectionHome);
        if (dir.isDirectory()) {
            for (File curFile : dir.listFiles()) {
                Properties props = SDKUtil.loadProperties(curFile + File.separator + "config" + File.separator + "sentinelreport.properties");
                if (!curFile.isDirectory()) continue;
                if (props.getProperty("sentinel.sdk.connection.status").equalsIgnoreCase("1")) {
                    this.sentinelConnection.add(curFile.getName());
                    continue;
                }
                this.sentinelConnection.add(Messages.EditReportPluginPage_FailedConnection + curFile.getName());
            }
        }
        this.sentinelConnection.setLayoutData((Object)gd);
        this.sentinelConnection.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditReportPluginPage.this.dialogChanged();
            }
        });
        new Label(container, 0);
        this.editNote = new Text(container, 66);
        this.editNote.setEditable(false);
        GridData gd1 = new GridData();
        gd1.widthHint = 600;
        gd1.grabExcessVerticalSpace = false;
        gd1.grabExcessHorizontalSpace = false;
        this.editNote.setLayoutData((Object)gd1);
        if (this.m_pluginType == PluginType.SOLUTION) {
            this.editNote.setText(Messages.EditSolutionPluginPage_Note);
        } else if (this.m_pluginType == PluginType.COLLECTOR) {
            this.editNote.setText(Messages.EditCollectorPluginPage_Note);
        } else if (this.m_pluginType == PluginType.REPORT) {
            this.editNote.setText(Messages.EditReportPluginPage_Note);
        } else {
            this.editNote.setVisible(false);
        }
        this.initialize();
        if (this.m_pluginType == PluginType.REPORT && iReportPathName.isEmpty()) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
        scrollComposite.setContent((Control)container);
        this.setControl((Control)scrollComposite);
        Point p = container.computeSize(-1, -1);
        p.y += 20;
        scrollComposite.setMinSize(p);
    }

    private void initialize() {
        String pluginSDKDir = String.format("%s%s%s%s%s", System.getProperty(SDKConstants.USER_HOME), File.separator, PLUGINSDK_DIR, File.separator, IREPORT_FILE);
        Properties iReportProperties = SDKUtil.loadProperties(pluginSDKDir);
        String defaultConnection = iReportProperties.getProperty(CONNECTION_NAME, CONNECTION_NONE);
        if (defaultConnection.isEmpty()) {
            this.sentinelConnection.select(1);
        } else {
            this.sentinelConnection.setText(defaultConnection);
        }
        this.getWizard().getContainer().getShell().setMinimumSize(this.getPreferredSize());
    }

    private String browseForDirectory(String msg) {
        DirectoryDialog choosePath = new DirectoryDialog(this.getShell());
        choosePath.setMessage(msg);
        return choosePath.open();
    }

    private void dialogChanged() {
        if (this.authorName != null && this.authorName.getText().length() == 0) {
            this.updateStatus(Messages.Preference_AuthorExample);
            return;
        }
        if (this.iReportPath != null && this.iReportPath.getText().length() == 0) {
            if (SDKUtil.isWindows()) {
                this.updateStatus(Messages.Preference_InvalidIReportPathWindows);
            } else {
                this.updateStatus(Messages.Preference_InvalidIReportPathLinux);
            }
            return;
        }
        if (this.iReportPath != null && !this.checkIReportDirectory()) {
            return;
        }
        if (this.getConnectionName().contains(Messages.EditReportPluginPage_FailedConnection)) {
            this.updateStatus(Messages.EditReportPluginPage_InvalidConnectionMessage);
        } else {
            this.updateStatus(null);
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private boolean checkIReportDirectory() {
        File file = null;
        boolean skipCheck = false;
        String validateText = this.iReportPath.getText().trim();
        if (validateText != null && validateText.length() > 0) {
            if (SDKUtil.isWindows()) {
                file = new File(validateText + File.separator + "iReport.bat");
                if (!file.exists() && !(file = new File(validateText + File.separator + "bin" + File.separator + "ireport.exe")).exists()) {
                    file = new File(validateText + File.separator + "bin" + File.separator + "ireport.bat");
                }
            } else if (SDKUtil.isLinux()) {
                file = new File(validateText + File.separator + "iReport.sh");
                if (!(file.exists() || (file = new File(validateText + File.separator + "iReport")).exists() || (file = new File(validateText + File.separator + "bin" + File.separator + "ireport.sh")).exists())) {
                    file = new File(validateText + File.separator + "bin" + File.separator + "ireport");
                }
            } else {
                skipCheck = true;
            }
        }
        if (!(skipCheck || file != null && file.exists())) {
            if (SDKUtil.isWindows()) {
                this.updateStatus(Messages.Preference_InvalidIReportPathWindows);
            } else {
                this.updateStatus(Messages.Preference_InvalidIReportPathLinux);
            }
            return false;
        }
        return true;
    }

    public void savePreference() {
        if (this.authorName != null && this.authorName.getText().length() > 0) {
            Activator.getDefault().getPreferenceStore().setValue(SDKConstants.PREF_PLUGIN_AUTHOR, this.authorName.getText());
            this.authorProperties.setProperty(SDKConstants.PREF_PLUGIN_AUTHOR, this.authorName.getText());
            SDKUtil.saveProperties(this.devPropFileName.toString(), this.authorProperties, SDKUtil.DEV_PROP_COMMENT);
        }
        if (this.iReportPath != null && this.iReportPath.getText().length() > 0) {
            Activator.getDefault().getPreferenceStore().setValue(SDKConstants.PREF_IREPORT_PATH, this.iReportPath.getText());
            this.iReportProperties.setProperty(SDKConstants.PREF_IREPORT_PATH, this.iReportPath.getText());
            SDKUtil.saveProperties(this.iReportPropFileName.toString(), this.iReportProperties);
        }
    }

    public String getConnectionName() {
        return this.sentinelConnection.getText();
    }

    @Override
    public String getArguments() {
        String connectionname = this.sentinelConnection.getText();
        String target = BuildType.EDIT_REPORT.getTarget();
        if (this.m_pluginType == PluginType.SOLUTION) {
            target = BuildType.EDIT_SOLUTION_PACK.getTarget();
        } else if (this.m_pluginType == PluginType.COLLECTOR) {
            target = BuildType.EDIT_COLLECTOR_PACK.getTarget();
        }
        Map<String, String> parameters = BuildType.CREATE_CONNECTION.getParameters();
        return String.format("%s %s\"%s\" %s\"%s\" %s\"%s\" %s", target, "-D" + parameters.get("connectionchoices") + "=", connectionname, "-D" + parameters.get("selectedconnection") + "=", connectionname, "-D" + parameters.get("connectionname") + "=", connectionname, "-D" + parameters.get("showprompt") + "=true");
    }

    @Override
    public boolean onPerformFinish() {
        return true;
    }

    @Override
    public Point getPreferredSize() {
        return new Point(860, this.getWizard().getContainer().getShell().getSize().y);
    }

    public void setPluginType(PluginType pluginType) {
        this.m_pluginType = pluginType;
        if (this.m_pluginType == PluginType.SOLUTION) {
            this.setTitle(Messages.EditSolutionPluginPage_Title);
            this.setDescription(Messages.EditSolutionPluginPage_Description);
        } else if (this.m_pluginType == PluginType.COLLECTOR) {
            this.setTitle(Messages.EditCollectorPluginPage_Title);
            this.setDescription(Messages.EditCollectorPluginPage_Description);
        }
    }
}

