/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.wizards;

import com.netiq.sentinel.sdk.Messages;
import com.netiq.sentinel.sdk.SDKUtil;
import com.netiq.sentinel.sdk.XMLFileReader;
import com.netiq.sentinel.sdk.sdkscriptsproperties.ScriptProperties;
import com.netiq.sentinel.sdk.util.Log;
import com.netiq.sentinel.sdk.widgets.InfoWidget;
import com.netiq.sentinel.sdk.wizards.ISentinelSDKPage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewSentinelActionPluginPage
extends WizardPage
implements ISentinelSDKPage {
    private Text sentinelPluginName;
    private Button buttonYes;
    private Button buttonNo;
    private Combo sentinelPluginType;
    private Map<String, String> typeMap;
    private String defaultType;

    public NewSentinelActionPluginPage() {
        super(Messages.NewSentinelActionPluginPage_PageName);
        this.setTitle(Messages.NewSentinelActionPluginPage_Title);
        this.setDescription(Messages.NewSentinelActionPluginPage_Description);
    }

    public void createControl(Composite parent) {
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridData scrollCompositeGridData = new GridData(1808);
        scrollComposite.setLayoutData((Object)scrollCompositeGridData);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        Composite container = new Composite((Composite)scrollComposite, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        Label label = new Label(container, 0);
        label.setText(Messages.NewSentinelActionPluginPage_Action_Name);
        GridData gd = new GridData(768);
        Composite newContainer = new Composite(container, 0);
        newContainer.setLayoutData((Object)gd);
        newContainer.setLayout((Layout)new FormLayout());
        this.sentinelPluginName = new Text(newContainer, 2052);
        this.sentinelPluginName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSentinelActionPluginPage.this.dialogChanged();
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, -30);
        this.sentinelPluginName.setLayoutData((Object)data);
        new InfoWidget(newContainer, (Control)this.sentinelPluginName, Messages.NewSentinelActionPluginPage_ActionName, Messages.NewSentinelActionPluginPage_Action_NameInformation);
        label = new Label(container, 0);
        label.setText(Messages.NewSentinelActionPluginPage_Action_NameExample);
        this.addBuffer(container);
        label = new Label(container, 0);
        label.setText(Messages.NewSentinelActionPluginPage_Action_Type);
        GridData gdBoth = new GridData(1808);
        newContainer = new Composite(container, 0);
        newContainer.setLayoutData((Object)gdBoth);
        newContainer.setLayout((Layout)new FormLayout());
        this.sentinelPluginType = new Combo(newContainer, 8);
        this.sentinelPluginType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSentinelActionPluginPage.this.dialogChanged();
            }
        });
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, -30);
        this.sentinelPluginType.setLayoutData((Object)data);
        this.loadTypes();
        InfoWidget info = new InfoWidget(newContainer, (Control)this.sentinelPluginType, Messages.NewSentinelActionPluginPage_ActionType, Messages.NewSentinelActionPluginPage_Action_TypeInformation);
        info.setVerboseInfo(Messages.NewSentinelActionPluginPage_Action_TypeInformationVerbose);
        label = new Label(container, 0);
        label.setText(Messages.NewSentinelActionPluginPage_Batch_Mode);
        newContainer = new Composite(container, 0);
        GridData gdVert = new GridData(1040);
        newContainer.setLayoutData((Object)gdVert);
        newContainer.setLayout((Layout)new FormLayout());
        this.buttonYes = new Button(newContainer, 16);
        this.buttonYes.setText(Messages.NewSentinelActionPluginPage_Yes);
        this.buttonYes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSentinelActionPluginPage.this.dialogChanged();
            }
        });
        data = new FormData();
        data.top = new FormAttachment(0, 3);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(20, 0);
        this.buttonYes.setLayoutData((Object)data);
        this.buttonNo = new Button(newContainer, 16);
        this.buttonNo.setText(Messages.NewSentinelActionPluginPage_No);
        this.buttonNo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSentinelActionPluginPage.this.dialogChanged();
            }
        });
        data = new FormData();
        data.top = new FormAttachment(0, 3);
        data.left = new FormAttachment((Control)this.buttonYes, 3);
        this.buttonNo.setLayoutData((Object)data);
        new InfoWidget(newContainer, (Control)this.buttonNo, Messages.NewSentinelActionPluginPage_BatchMode, Messages.NewSentinelActionPluginPage_Batch_ModeInformation);
        this.initialize();
        this.setErrorMessage(null);
        this.setPageComplete(false);
        scrollComposite.setContent((Control)container);
        this.setControl((Control)scrollComposite);
        Point p = container.computeSize(-1, -1);
        p.y += 20;
        scrollComposite.setMinSize(p);
    }

    private void initialize() {
        this.buttonNo.setSelection(true);
        this.sentinelPluginType.setText(this.defaultType);
    }

    private void dialogChanged() {
        if (this.getSentinelPluginName().length() == 0) {
            this.updateStatus(Messages.NewSentinelActionPluginPage_Action_Name_Empty);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getSentinelPluginName() {
        return this.sentinelPluginName.getText();
    }

    public String getSentinelBatchMode() {
        return this.buttonYes.getSelection() ? "y" : "n";
    }

    public String getSentinelPluginType() {
        String type = this.typeMap.get(this.sentinelPluginType.getText());
        return type;
    }

    private void loadTypes() {
        this.typeMap = new HashMap<String, String>();
        XMLFileReader xmlReader = new XMLFileReader("build", "RequiredObjects.xml");
        try {
            ArrayList<String> displayList = xmlReader.getNodeList("//Objects/Display/text()");
            ArrayList<String> valueList = xmlReader.getNodeList("//Objects/Value/text()");
            for (int i = 0; i < displayList.size(); ++i) {
                String tag = valueList.get(i);
                this.typeMap.put(displayList.get(i), tag);
                if (!tag.equalsIgnoreCase("NONE")) continue;
                this.defaultType = displayList.get(i);
            }
            Object[] categoryItems = this.typeMap.keySet().toArray(new String[this.typeMap.size()]);
            Arrays.sort(categoryItems);
            this.sentinelPluginType.setItems((String[])categoryItems);
        }
        catch (XPathExpressionException e) {
            Log.error(e);
        }
    }

    @Override
    public String getArguments() {
        String Target = ScriptProperties.getTarget("buildnew", "newaction");
        Map<String, String> Parameters = ScriptProperties.getParameters("buildnew", "newaction");
        return String.format("\"" + Target + "\" -D" + Parameters.get("plugin") + "=\"%s\" -D" + Parameters.get("usebatch") + "=\"%s\" -D" + Parameters.get("requiredobjects") + "=\"%s\"", this.getSentinelPluginName(), this.getSentinelBatchMode(), this.getSentinelPluginType());
    }

    @Override
    public boolean onPerformFinish() {
        IPath sdkPath = SDKUtil.getSDKProject().getLocation();
        sdkPath = sdkPath.uptoSegment(sdkPath.segmentCount() - 2);
        String pathName = sdkPath.toOSString();
        pathName = pathName + File.separator + "content" + File.separator + "dev" + File.separator + "actions";
        File newActionDirectory = new File(pathName = pathName + File.separator + this.getSentinelPluginName());
        if (newActionDirectory.exists()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewSentinelActionPluginPage_Title, (String)NLS.bind((String)Messages.Plugin_Already_Exist, (Object)this.getSentinelPluginName()));
            this.sentinelPluginName.setFocus();
            return false;
        }
        return true;
    }

    @Override
    public Point getPreferredSize() {
        return new Point(800, this.getWizard().getContainer().getShell().getSize().y);
    }

    private void addBuffer(Composite parent) {
        GridData spaceData = new GridData();
        spaceData.grabExcessVerticalSpace = false;
        spaceData.horizontalSpan = 2;
        spaceData.heightHint = 7;
        Label label = new Label(parent, 0);
        label.setText("");
        label.setLayoutData((Object)spaceData);
    }
}

