/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.wizards;

import com.netiq.sentinel.sdk.Activator;
import com.netiq.sentinel.sdk.Messages;
import com.netiq.sentinel.sdk.SDKConstants;
import com.netiq.sentinel.sdk.SDKUtil;
import com.netiq.sentinel.sdk.XMLFileReader;
import com.netiq.sentinel.sdk.sdkscriptsproperties.ScriptProperties;
import com.netiq.sentinel.sdk.util.Log;
import com.netiq.sentinel.sdk.widgets.HistoryTextField;
import com.netiq.sentinel.sdk.widgets.InfoWidget;
import com.netiq.sentinel.sdk.wizards.ISentinelSDKPage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewSentinelCollectorPluginPage
extends WizardPage
implements ISentinelSDKPage {
    private HistoryTextField vendor;
    private Text product;
    private Combo pcat;
    private Map<String, String> categoryMap;
    private String defaultOS;
    private static String NEW_SENTINEL_COLLECTOR_PLUGIN_KEY = "NewSentinelCollectorPluginPageKey";

    public NewSentinelCollectorPluginPage() {
        super(Messages.NewSentinelCollectorPluginPage_PageName);
        this.setTitle(Messages.NewSentinelCollectorPluginPage_Title);
        this.setDescription(Messages.NewSentinelCollectorPluginPage_Description);
    }

    public void createControl(Composite parent) {
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridData scrollCompositeGridData = new GridData(1808);
        scrollComposite.setLayoutData((Object)scrollCompositeGridData);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        Composite container = new Composite((Composite)scrollComposite, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        Label label = new Label(container, 0);
        label.setText(Messages.NewSentinelCollectorPluginPage_Vendor_Name);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.vendor = new HistoryTextField(container, this.loadVendoes(), NEW_SENTINEL_COLLECTOR_PLUGIN_KEY);
        gd = new GridData(768);
        this.vendor.setLayoutData(gd);
        this.vendor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSentinelCollectorPluginPage.this.dialogChanged();
            }
        });
        new InfoWidget(container, Messages.NewSentinelCollectorPluginPage_VendorName, Messages.NewSentinelCollectorPluginPage_Vendor_NameInformation);
        label = new Label(container, 0);
        label.setText(Messages.NewSentinelCollectorPluginPage_Vendor_NameExample);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.addBuffer(container);
        label = new Label(container, 0);
        label.setText(Messages.NewSentinelCollectorPluginPage_Product_Name);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.product = new Text(container, 2052);
        gd = new GridData(768);
        this.product.setLayoutData((Object)gd);
        this.product.setLayoutData((Object)gd);
        this.product.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSentinelCollectorPluginPage.this.dialogChanged();
            }
        });
        new InfoWidget(container, Messages.NewSentinelCollectorPluginPage_ProductName, Messages.NewSentinelCollectorPluginPage_Product_NameInformation);
        label = new Label(container, 0);
        label.setText(Messages.NewSentinelCollectorPluginPage_Product_NameExample);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.addBuffer(container);
        label = new Label(container, 0);
        label.setText(Messages.NewSentinelCollectorPluginPage_Category);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.pcat = new Combo(container, 8);
        this.pcat.setLayoutData((Object)gd);
        this.pcat.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSentinelCollectorPluginPage.this.dialogChanged();
            }
        });
        this.loadCategories();
        this.initialize();
        this.setErrorMessage(null);
        this.setPageComplete(false);
        scrollComposite.setContent((Control)container);
        this.setControl((Control)scrollComposite);
        Point p = container.computeSize(-1, -1);
        p.y += 20;
        scrollComposite.setMinSize(p);
    }

    private void initialize() {
        this.pcat.setText(this.defaultOS);
        this.vendor.useLastUsedText();
        String venderName = this.vendor.getText();
        if (venderName.length() < 1) {
            venderName = Activator.getDefault().getPreferenceStore().getString(SDKConstants.PREF_PLUGIN_AUTHOR);
            if (venderName.length() > 0) {
                this.vendor.setText(venderName);
                this.product.setFocus();
            } else {
                this.vendor.setFocus();
            }
        }
    }

    private void dialogChanged() {
        if (this.vendor.getText().length() == 0) {
            this.updateStatus(Messages.NewSentinelCollectorPluginPage_Vendor_Error);
            return;
        }
        if (this.product.getText().length() == 0) {
            this.updateStatus(Messages.NewSentinelCollectorPluginPage_Product_Error);
            return;
        }
        if (this.pcat.getText().length() == 0) {
            this.updateStatus(Messages.NewSentinelCollectorPluginPage_Category_Error);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private String[] loadVendoes() {
        IPath sdkPath = SDKUtil.getSDKProject().getLocation();
        sdkPath = sdkPath.uptoSegment(sdkPath.segmentCount() - 2);
        String pathName = sdkPath.toOSString();
        pathName = pathName + File.separator + "content" + File.separator + "dev" + File.separator + "collectors";
        File collectorsDirectory = new File(pathName);
        ArrayList<String> tempList = new ArrayList<String>();
        if (collectorsDirectory.isDirectory()) {
            for (File curFile : collectorsDirectory.listFiles()) {
                String curFolderName;
                if (!curFile.isDirectory() || curFile.isHidden() || (curFolderName = curFile.getName()).equalsIgnoreCase("AA-common") || curFolderName.equalsIgnoreCase(".svn")) continue;
                tempList.add(curFile.getName());
            }
        }
        return tempList.toArray(new String[tempList.size()]);
    }

    private void loadCategories() {
        this.categoryMap = new HashMap<String, String>();
        XMLFileReader xmlReader = new XMLFileReader("build", "ObserverCategory.xml");
        try {
            ArrayList<String> categoryNameList = xmlReader.getNodeList("//Category/Name/text()");
            ArrayList<String> categoryTagList = xmlReader.getNodeList("//Category/Tag/text()");
            for (int i = 0; i < categoryNameList.size(); ++i) {
                String tag = categoryTagList.get(i);
                this.categoryMap.put(categoryNameList.get(i), tag);
                if (!tag.equalsIgnoreCase("OS")) continue;
                this.defaultOS = categoryNameList.get(i);
            }
            Object[] categoryItems = this.categoryMap.keySet().toArray(new String[this.categoryMap.size()]);
            Arrays.sort(categoryItems);
            this.pcat.setItems((String[])categoryItems);
        }
        catch (XPathExpressionException e) {
            Log.error(e);
        }
    }

    @Override
    public String getArguments() {
        String Target = ScriptProperties.getTarget("buildnew", "newcollector");
        Map<String, String> Parameters = ScriptProperties.getParameters("buildnew", "newcollector");
        String category = this.categoryMap.get(this.pcat.getText());
        return String.format("\"" + Target + "\" -D" + Parameters.get("vendor") + "=\"%s\" -D" + Parameters.get("product") + "=\"%s\" -D" + Parameters.get("pcat") + "=\"%s\" -D" + Parameters.get("type") + "=\"%s\"", this.vendor.getText(), this.product.getText(), category, "NA");
    }

    @Override
    public boolean onPerformFinish() {
        IPath sdkPath = SDKUtil.getSDKProject().getLocation();
        sdkPath = sdkPath.uptoSegment(sdkPath.segmentCount() - 2);
        String pathName = sdkPath.toOSString();
        pathName = pathName + File.separator + "content" + File.separator + "dev" + File.separator + "collectors";
        File newActionDirectory = new File(pathName = pathName + File.separator + this.vendor.getText() + File.separator + this.product.getText());
        if (newActionDirectory.exists()) {
            String newName = this.vendor.getText() + File.separator + this.product.getText();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewSentinelCollectorPluginPage_Title, (String)NLS.bind((String)Messages.Plugin_Already_Exist, (Object)newName));
            this.product.setFocus();
            return false;
        }
        this.vendor.saveToHistory();
        return true;
    }

    @Override
    public Point getPreferredSize() {
        return new Point(860, this.getWizard().getContainer().getShell().getSize().y);
    }

    private void addBuffer(Composite parent) {
        GridData spaceData = new GridData();
        spaceData.grabExcessVerticalSpace = false;
        spaceData.horizontalSpan = 2;
        spaceData.heightHint = 7;
        Label label = new Label(parent, 0);
        label.setText("");
        label.setLayoutData((Object)spaceData);
    }
}

