/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.wizards;

import com.netiq.sentinel.sdk.Messages;
import com.netiq.sentinel.sdk.model.Connection;
import com.netiq.sentinel.sdk.model.PluginType;
import com.netiq.sentinel.sdk.model.SentinelPlugin;
import com.netiq.sentinel.sdk.model.SentinelProject;
import com.netiq.sentinel.sdk.wizards.CreateLuceneConnectionPage;
import com.netiq.sentinel.sdk.wizards.EditReportPluginPage;
import com.netiq.sentinel.sdk.wizards.ISentinelSDKPage;
import com.netiq.sentinel.sdk.wizards.NewSentinelActionPluginPage;
import com.netiq.sentinel.sdk.wizards.NewSentinelCollectorPluginPage;
import com.netiq.sentinel.sdk.wizards.NewSentinelRDDPluginPage;
import com.netiq.sentinel.sdk.wizards.NewSentinelReportPluginPage;
import com.netiq.sentinel.sdk.wizards.NewSentinelSolutionPluginPage;
import com.netiq.sentinel.sdk.wizards.SubmitForCertificationPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewSentinelPluginWizard
extends Wizard
implements INewWizard {
    private WizardPage m_page1;
    private WizardPage m_page2;
    private String arguments;
    private Connection connection;
    private ISelection m_selection;
    private PluginType plugType;
    private boolean isEdit;
    private String connectionToEdit;
    private IWizardPage m_currentPage;
    private boolean m_submitForCert;
    private static String CONNECTION_NEW = Messages.Common_Create_Connection;

    public NewSentinelPluginWizard() {
        this.setNeedsProgressMonitor(true);
        this.m_selection = null;
        this.m_submitForCert = false;
        this.isEdit = false;
    }

    public NewSentinelPluginWizard(boolean edit, String connection) {
        this.setNeedsProgressMonitor(true);
        this.m_selection = null;
        this.m_submitForCert = false;
        this.isEdit = edit;
        this.connectionToEdit = connection;
    }

    public NewSentinelPluginWizard(ISelection selection) {
        this.setNeedsProgressMonitor(true);
        this.m_selection = selection;
        this.m_submitForCert = false;
    }

    public NewSentinelPluginWizard(ISelection selection, boolean submitForCert) {
        this.setNeedsProgressMonitor(true);
        this.m_selection = selection;
        this.m_submitForCert = submitForCert;
    }

    public void addPages() {
        if (this.m_submitForCert) {
            this.m_page1 = new SubmitForCertificationPage();
            this.addPage((IWizardPage)this.m_page1);
        } else if (this.m_selection == null) {
            this.plugType = PluginType.REPORT;
            this.m_page1 = this.isEdit ? new CreateLuceneConnectionPage(true, this.connectionToEdit) : new CreateLuceneConnectionPage();
            this.addPage((IWizardPage)this.m_page1);
        } else if (((IStructuredSelection)this.m_selection).getFirstElement() instanceof SentinelProject) {
            SentinelProject sentinelObject = (SentinelProject)((IStructuredSelection)this.m_selection).getFirstElement();
            this.plugType = sentinelObject.getPluginType();
            if (this.plugType == PluginType.ACTION) {
                this.m_page1 = new NewSentinelActionPluginPage();
                this.addPage((IWizardPage)this.m_page1);
            } else if (this.plugType == PluginType.COLLECTOR) {
                this.m_page1 = new NewSentinelCollectorPluginPage();
                this.addPage((IWizardPage)this.m_page1);
            } else if (this.plugType == PluginType.REPORT) {
                this.m_page1 = new NewSentinelReportPluginPage();
                this.addPage((IWizardPage)this.m_page1);
            } else if (this.plugType == PluginType.RDD) {
                this.m_page1 = new NewSentinelRDDPluginPage();
                this.addPage((IWizardPage)this.m_page1);
            } else if (this.plugType == PluginType.SOLUTION) {
                this.m_page1 = new NewSentinelSolutionPluginPage();
                this.addPage((IWizardPage)this.m_page1);
            }
        } else if (((IStructuredSelection)this.m_selection).getFirstElement() instanceof SentinelPlugin) {
            SentinelPlugin sentinelPlugin = (SentinelPlugin)((IStructuredSelection)this.m_selection).getFirstElement();
            this.plugType = sentinelPlugin.getPluginType();
            if (sentinelPlugin.getPluginType().equals((Object)PluginType.REPORT) || sentinelPlugin.getPluginType().equals((Object)PluginType.SOLUTION) || sentinelPlugin.getPluginType().equals((Object)PluginType.COLLECTOR)) {
                this.m_page1 = new EditReportPluginPage();
                EditReportPluginPage page1 = (EditReportPluginPage)this.m_page1;
                page1.setPluginType(this.plugType);
                this.addPage((IWizardPage)this.m_page1);
                this.m_page2 = new CreateLuceneConnectionPage();
                CreateLuceneConnectionPage page2 = (CreateLuceneConnectionPage)this.m_page2;
                page2.setPluginType(this.plugType);
                this.addPage((IWizardPage)this.m_page2);
            }
        }
    }

    public boolean performFinish() {
        ISentinelSDKPage page1 = (ISentinelSDKPage)this.m_page1;
        if (!page1.onPerformFinish()) {
            return false;
        }
        this.arguments = page1.getArguments();
        if (this.plugType == PluginType.REPORT || this.plugType == PluginType.SOLUTION || this.plugType == PluginType.COLLECTOR) {
            if (this.m_page1 instanceof EditReportPluginPage) {
                EditReportPluginPage editReportPage = (EditReportPluginPage)this.m_page1;
                editReportPage.savePreference();
                if (editReportPage.getConnectionName().equalsIgnoreCase(CONNECTION_NEW) && this.m_page2 != null) {
                    CreateLuceneConnectionPage connectionPage = (CreateLuceneConnectionPage)this.m_page2;
                    this.arguments = connectionPage.getArguments();
                    this.connection = connectionPage.getConnectionInfo();
                }
            } else if (this.m_page1 instanceof CreateLuceneConnectionPage) {
                CreateLuceneConnectionPage connectionPage = (CreateLuceneConnectionPage)this.m_page1;
                this.connection = connectionPage.getConnectionInfo();
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public String getArguments() {
        return this.arguments;
    }

    public Connection getConnectionPageInfo() {
        return this.connection;
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        this.m_currentPage = currentPage;
        if (currentPage instanceof EditReportPluginPage && ((EditReportPluginPage)currentPage).getConnectionName().equalsIgnoreCase(CONNECTION_NEW)) {
            return this.m_page2;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage currentPage) {
        if (currentPage instanceof CreateLuceneConnectionPage) {
            return this.m_page1;
        }
        return null;
    }

    public boolean canFinish() {
        if (this.m_currentPage != null) {
            if (this.m_currentPage instanceof EditReportPluginPage && ((EditReportPluginPage)this.m_currentPage).getConnectionName().equalsIgnoreCase(CONNECTION_NEW)) {
                return false;
            }
            if (this.m_currentPage instanceof CreateLuceneConnectionPage && !((CreateLuceneConnectionPage)this.m_currentPage).isPageComplete()) {
                return false;
            }
            return this.m_currentPage.isPageComplete();
        }
        for (IWizardPage page : this.getPages()) {
            EditReportPluginPage currentPage;
            if (!page.isPageComplete()) {
                return false;
            }
            if (!(page instanceof EditReportPluginPage) || (currentPage = (EditReportPluginPage)page).getConnectionName().equalsIgnoreCase(CONNECTION_NEW)) continue;
            return page.isPageComplete();
        }
        return true;
    }

    public Point getPreferredSize() {
        ISentinelSDKPage page1 = (ISentinelSDKPage)this.m_page1;
        if (page1 != null) {
            if (page1 instanceof EditReportPluginPage && this.m_page2 != null) {
                return ((ISentinelSDKPage)this.m_page2).getPreferredSize();
            }
            return page1.getPreferredSize();
        }
        return null;
    }

    public void sizeAndCenter(WizardDialog dialog) {
        Point size = this.getPreferredSize();
        if (dialog.getShell() == null || size == null) {
            return;
        }
        dialog.getShell().setSize(this.getPreferredSize());
        dialog.getShell().setMinimumSize(700, 450);
        Monitor primary = dialog.getShell().getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = dialog.getShell().getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        dialog.getShell().setLocation(x, y);
    }
}

