/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.wizards;

import com.netiq.sentinel.sdk.Messages;
import com.netiq.sentinel.sdk.SDKUtil;
import com.netiq.sentinel.sdk.sdkscriptsproperties.ScriptProperties;
import com.netiq.sentinel.sdk.widgets.HistoryTextField;
import com.netiq.sentinel.sdk.widgets.InfoWidget;
import com.netiq.sentinel.sdk.wizards.ISentinelSDKPage;
import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewSentinelRDDPluginPage
extends WizardPage
implements ISentinelSDKPage {
    private Text sentinelPluginName;
    private Text internalPluginName;
    private HistoryTextField namespace;
    private static String RDD_NAMESPACE_FIELDKEY = "RDDNamespaceKey";
    private Composite container;

    public NewSentinelRDDPluginPage() {
        super(Messages.NewSentinelRDDPluginPage_PageName);
        this.setTitle(Messages.NewSentinelRDDPluginPage_Title);
        this.setDescription(Messages.NewSentinelRDDPluginPage_Description);
    }

    public void createControl(Composite parent) {
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridData scrollCompositeGridData = new GridData(1808);
        scrollComposite.setLayoutData((Object)scrollCompositeGridData);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.container = new Composite((Composite)scrollComposite, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 2;
        Label label = new Label(this.container, 0);
        label.setText(Messages.NewSentinelRDDPluginPage_RDD_Name);
        GridData gdSpan = new GridData(768);
        gdSpan.horizontalSpan = 2;
        label.setLayoutData((Object)gdSpan);
        this.sentinelPluginName = new Text(this.container, 2052);
        GridData gd = new GridData(768);
        this.sentinelPluginName.setLayoutData((Object)gd);
        this.sentinelPluginName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSentinelRDDPluginPage.this.dialogChanged();
            }
        });
        new InfoWidget(this.container, Messages.NewSentinelRDDPluginPage_RDD_NameTitle, Messages.NewSentinelRDDPluginPage_RDD_NameTip);
        label = new Label(this.container, 0);
        label.setText(Messages.NewSentinelRDDPluginPage_RDD_NameExample);
        label.setLayoutData((Object)gdSpan);
        this.addBuffer(this.container);
        label = new Label(this.container, 0);
        label.setText(Messages.NewSentinelRDDPluginPage_Internal_Name);
        label.setLayoutData((Object)gdSpan);
        this.internalPluginName = new Text(this.container, 2052);
        gd = new GridData(768);
        this.internalPluginName.setLayoutData((Object)gd);
        this.internalPluginName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSentinelRDDPluginPage.this.dialogChanged();
            }
        });
        new InfoWidget(this.container, Messages.NewSentinelRDDPluginPage_Internal_NameTitle, Messages.NewSentinelRDDPluginPage_Internal_NameTip);
        label = new Label(this.container, 0);
        label.setText(Messages.NewSentinelRDDPluginPage_Internal_NameExample);
        label.setLayoutData((Object)gdSpan);
        this.addBuffer(this.container);
        label = new Label(this.container, 0);
        label.setText(Messages.NewSentinelRDDPluginPage_Namespace);
        label.setLayoutData((Object)gdSpan);
        this.namespace = new HistoryTextField(this.container, RDD_NAMESPACE_FIELDKEY);
        gd = new GridData(768);
        this.namespace.setLayoutData(gd);
        this.namespace.selectFirstInList();
        this.namespace.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSentinelRDDPluginPage.this.dialogChanged();
            }
        });
        this.namespace.getComboControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                NewSentinelRDDPluginPage.this.dialogChanged();
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        new InfoWidget(this.container, Messages.NewSentinelRDDPluginPage_NamespaceTitle, Messages.NewSentinelRDDPluginPage_NamespaceTip);
        label = new Label(this.container, 0);
        label.setText(Messages.NewSentinelRDDPluginPage_NamespaceExample);
        label.setLayoutData((Object)gdSpan);
        this.initialize();
        this.setErrorMessage(null);
        this.setPageComplete(false);
        scrollComposite.setContent((Control)this.container);
        this.setControl((Control)scrollComposite);
        Point p = this.container.computeSize(-1, -1);
        p.y += 20;
        scrollComposite.setMinSize(p);
    }

    private void initialize() {
        this.getWizard().getContainer().getShell().setMinimumSize(this.getPreferredSize());
    }

    private void dialogChanged() {
        if (this.getSentinelPluginName().length() == 0) {
            this.updateStatus(Messages.NewSentinelRDDPluginPage_Name_Empty);
            return;
        }
        if (this.getSentinelInternalName().length() == 0) {
            this.updateStatus(Messages.NewSentinelRDDPluginPage_InternalName_Empty);
            return;
        }
        if (this.getNamespace().length() == 0) {
            this.updateStatus(Messages.NewSentinelRDDPluginPage_Namespace_Empty);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getSentinelPluginName() {
        return this.sentinelPluginName.getText();
    }

    public String getSentinelInternalName() {
        return this.internalPluginName.getText();
    }

    public String getNamespace() {
        return this.namespace.getText();
    }

    @Override
    public String getArguments() {
        String Target = ScriptProperties.getTarget("buildnew", "newrdd");
        Map<String, String> Parameters = ScriptProperties.getParameters("buildnew", "newrdd");
        return String.format("\"" + Target + "\" -D" + Parameters.get("plugin") + "=\"%s\" -D" + Parameters.get("internalname") + "=\"%s\" -D" + Parameters.get("namespace") + "=\"%s\"", this.getSentinelPluginName(), this.getSentinelInternalName(), this.getNamespace());
    }

    @Override
    public boolean onPerformFinish() {
        IPath sdkPath = SDKUtil.getSDKProject().getLocation();
        sdkPath = sdkPath.uptoSegment(sdkPath.segmentCount() - 2);
        String pathName = sdkPath.toOSString();
        pathName = pathName + File.separator + "content" + File.separator + "dev" + File.separator + "rdds";
        File newActionDirectory = new File(pathName = pathName + File.separator + this.getSentinelPluginName());
        if (newActionDirectory.exists()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewSentinelRDDPluginPage_Title, (String)NLS.bind((String)Messages.Plugin_Already_Exist, (Object)this.getSentinelPluginName()));
            this.sentinelPluginName.setFocus();
            return false;
        }
        this.namespace.saveToHistory();
        return true;
    }

    @Override
    public Point getPreferredSize() {
        return new Point(960, this.getWizard().getContainer().getShell().getSize().y + 20);
    }

    private void addBuffer(Composite parent) {
        GridData spaceData = new GridData();
        spaceData.grabExcessVerticalSpace = false;
        spaceData.horizontalSpan = 2;
        spaceData.heightHint = 7;
        Label label = new Label(parent, 0);
        label.setText("");
        label.setLayoutData((Object)spaceData);
    }
}

