/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.wizards;

import com.netiq.sentinel.sdk.Messages;
import com.netiq.sentinel.sdk.SDKUtil;
import com.netiq.sentinel.sdk.model.PlatformQueryData;
import com.netiq.sentinel.sdk.sdkscriptsproperties.ScriptProperties;
import com.netiq.sentinel.sdk.util.Log;
import com.netiq.sentinel.sdk.widgets.HistoryTextField;
import com.netiq.sentinel.sdk.widgets.InfoWidget;
import com.netiq.sentinel.sdk.wizards.ISentinelSDKPage;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewSentinelReportPluginPage
extends WizardPage
implements ISentinelSDKPage {
    private Text reportname;
    private HistoryTextField category;
    private Text tags;
    private Combo platforms;
    private Combo dataQueried;
    private Combo rdddir;
    private Combo eventReportType;
    private InfoWidget queryInfoWidget;
    private InfoWidget rddInfoWidget;
    private Map<String, String> platformsMap;
    private Label lblRDD;
    private static String NEW_SENTINEL_REPORT_PLUGIN_KEY = "NewSentinelReportPluginPageKey";

    public NewSentinelReportPluginPage() {
        super(Messages.NewSentinelReportPluginPage_PageName);
        this.setTitle(Messages.NewSentinelReportPluginPage_Title);
        this.setDescription(Messages.NewSentinelReportPluginPage_Description);
        this.platformsMap = new LinkedHashMap<String, String>();
        String[] platformsList = Messages.NewSentinelReportPluginPage_PlatformsList.split(";");
        int totlatCount = platformsList.length;
        for (int i = 0; i < totlatCount; ++i) {
            this.platformsMap.put(platformsList[i], PlatformQueryData.getAntPlatform(platformsList[i]));
        }
    }

    public void createControl(Composite parent) {
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridData scrollCompositeGridData = new GridData(1808);
        scrollComposite.setLayoutData((Object)scrollCompositeGridData);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        Composite container = new Composite((Composite)scrollComposite, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        Label label = new Label(container, 0);
        label.setText(Messages.NewSentinelReportPluginPage_Report_Name);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.reportname = new Text(container, 2052);
        gd = new GridData(768);
        this.reportname.setLayoutData((Object)gd);
        this.reportname.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSentinelReportPluginPage.this.dialogChanged();
            }
        });
        new InfoWidget(container, Messages.NewSentinelReportPluginPage_ReportName, Messages.NewSentinelReportPluginPage_Report_NameInformation);
        label = new Label(container, 0);
        label.setText(Messages.NewSentinelReportPluginPage_Report_NameExample);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.addBuffer(container);
        label = new Label(container, 0);
        label.setText(Messages.NewSentinelReportPluginPage_Report_Category);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.category = new HistoryTextField(container, this.loadCategoies(), NEW_SENTINEL_REPORT_PLUGIN_KEY);
        gd = new GridData(768);
        this.category.setLayoutData(gd);
        this.category.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSentinelReportPluginPage.this.dialogChanged();
            }
        });
        new InfoWidget(container, Messages.NewSentinelReportPluginPage_Report_CategoryName, Messages.NewSentinelReportPluginPage_Report_CategoryInformation);
        label = new Label(container, 0);
        label.setText(Messages.NewSentinelReportPluginPage_Report_CategoryExample);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.addBuffer(container);
        label = new Label(container, 0);
        label.setText(Messages.NewSentinelReportPluginPage_Report_Tag);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.tags = new Text(container, 2052);
        gd = new GridData(768);
        this.tags.setLayoutData((Object)gd);
        this.tags.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSentinelReportPluginPage.this.dialogChanged();
            }
        });
        new InfoWidget(container, Messages.NewSentinelReportPluginPage_Report_TagName, Messages.NewSentinelReportPluginPage_Report_TagInformation);
        label = new Label(container, 0);
        label.setText(Messages.NewSentinelReportPluginPage_Report_TagExample);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.addBuffer(container);
        label = new Label(container, 0);
        label.setText(Messages.NewSentinelReportPluginPage_Report_Platform);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        String[] platformsItems = this.platformsMap.keySet().toArray(new String[this.platformsMap.size()]);
        this.platforms = new Combo(container, 12);
        this.platforms.setItems(platformsItems);
        gd = new GridData(768);
        this.platforms.setLayoutData((Object)gd);
        this.platforms.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSentinelReportPluginPage.this.updateDataQueried();
                NewSentinelReportPluginPage.this.dialogChanged();
            }
        });
        this.platforms.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSentinelReportPluginPage.this.dialogChanged();
            }
        });
        this.addBuffer(container);
        label = new Label(container, 0);
        label.setText(Messages.NewSentinelReportPluginPage_Data_Query);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.dataQueried = new Combo(container, 12);
        gd = new GridData(768);
        this.dataQueried.setLayoutData((Object)gd);
        this.dataQueried.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSentinelReportPluginPage.this.dialogChanged();
            }
        });
        this.dataQueried.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSentinelReportPluginPage.this.enableOrDisableRDD();
            }
        });
        this.queryInfoWidget = new InfoWidget(container, Messages.NewSentinelReportPluginPage_Data_QueryName, Messages.NewSentinelReportPluginPage_Data_QueryInformation);
        this.queryInfoWidget.setVerboseInfo(Messages.NewSentinelReportPluginPage_Data_QueryInformationVerbose);
        this.addBuffer(container);
        label = new Label(container, 0);
        label.setText(Messages.NewSentinelReportPluginPage_Report_Type);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        String[] eventReportTypeItems = new String[]{"Top N Dashboard", "Detailed"};
        this.eventReportType = new Combo(container, 8);
        this.eventReportType.setItems(eventReportTypeItems);
        gd = new GridData(768);
        this.eventReportType.setLayoutData((Object)gd);
        this.eventReportType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSentinelReportPluginPage.this.dialogChanged();
            }
        });
        this.addBuffer(container);
        this.lblRDD = new Label(container, 0);
        this.lblRDD.setText(Messages.NewSentinelReportPluginPage_RDDOptional);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.lblRDD.setLayoutData((Object)gd);
        this.rdddir = new Combo(container, 4);
        IPath sdkPath = SDKUtil.getSDKProject().getLocation();
        IPath devPath = sdkPath.uptoSegment(sdkPath.segmentCount() - 2);
        String pathName = devPath.toOSString();
        pathName = pathName + File.separator + "content" + File.separator + "dev" + File.separator + "rdds";
        if (devPath.isValidPath(pathName)) {
            IPath rddsPath = devPath.append("content" + File.separator + "dev" + File.separator + "rdds");
            File rddsFile = rddsPath.toFile();
            try {
                if (rddsFile.isDirectory()) {
                    for (File curFile : rddsFile.listFiles()) {
                        String curFolderName;
                        if (!curFile.isDirectory() || curFile.isHidden() || (curFolderName = curFile.getName()).equalsIgnoreCase("AA-common") || curFolderName.equalsIgnoreCase(".svn")) continue;
                        this.rdddir.add(curFile.getName());
                    }
                }
            }
            catch (Exception e1) {
                Log.error(e1);
            }
        }
        gd = new GridData(768);
        this.rdddir.setLayoutData((Object)gd);
        this.rdddir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSentinelReportPluginPage.this.dialogChanged();
            }
        });
        this.rddInfoWidget = new InfoWidget(container, Messages.NewSentinelReportPluginPage_RDDName, Messages.NewSentinelReportPluginPage_RDDInformation);
        this.initialize();
        this.setErrorMessage(null);
        this.setPageComplete(false);
        scrollComposite.setContent((Control)container);
        this.setControl((Control)scrollComposite);
        Point p = container.computeSize(-1, -1);
        p.y += 20;
        scrollComposite.setMinSize(p);
    }

    private void initialize() {
        this.category.useLastUsedText();
        this.platforms.setText(PlatformQueryData.getDefaultPlatform());
        this.updateDataQueried();
        this.eventReportType.setText("Top N Dashboard");
        this.enableOrDisableRDD();
    }

    private void dialogChanged() {
        if (this.reportname.getText().length() == 0) {
            this.updateStatus(Messages.NewSentinelReportPluginPage_Report_Name_Error);
            return;
        }
        if (this.category.getText().length() == 0) {
            this.updateStatus(Messages.NewSentinelReportPluginPage_Report_Category_Error);
            return;
        }
        if (this.platforms.getText().length() == 0) {
            this.updateStatus(Messages.NewSentinelReportPluginPage_Report_Platform_Error);
            return;
        }
        if (this.dataQueried.getText().length() == 0) {
            if (this.platforms.getText().equals("IDM")) {
                this.updateStatus(Messages.NewSentinelReportPluginPage_Report_Query_Error);
            } else {
                this.updateStatus(Messages.NewSentinelReportPluginPage_Report_Query_Error_Ex);
            }
            return;
        }
        if (this.rdddir.isEnabled() && this.rdddir.getText().length() == 0) {
            this.updateStatus(Messages.NewSentinelReportPluginPage_Report_RDD_Error);
            this.setMessage(Messages.NewSentinelReportPluginPage_Report_RDD_Error, 1);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private String[] loadCategoies() {
        IPath sdkPath = SDKUtil.getSDKProject().getLocation();
        sdkPath = sdkPath.uptoSegment(sdkPath.segmentCount() - 2);
        String pathName = sdkPath.toOSString();
        pathName = pathName + File.separator + "content" + File.separator + "dev" + File.separator + "reports";
        File collectorsDirectory = new File(pathName);
        ArrayList<String> tempList = new ArrayList<String>();
        if (collectorsDirectory.isDirectory()) {
            for (File curFile : collectorsDirectory.listFiles()) {
                String curFolderName;
                if (!curFile.isDirectory() || curFile.isHidden() || (curFolderName = curFile.getName()).equalsIgnoreCase("AA-common") || curFolderName.equalsIgnoreCase(".svn")) continue;
                tempList.add(curFile.getName());
            }
        }
        return tempList.toArray(new String[tempList.size()]);
    }

    @Override
    public String getArguments() {
        String Target = ScriptProperties.getTarget("buildnew", "newreport");
        Map<String, String> Parameters = ScriptProperties.getParameters("buildnew", "newreport");
        String rddDirValue = this.rdddir.getText();
        if (rddDirValue.isEmpty()) {
            rddDirValue = " ";
        }
        String platform = this.platformsMap.get(this.platforms.getText());
        return String.format("\"" + Target + "\" %s\"%s\" %s\"%s\" %s\"%s\" %s\"%s\" %s\"%s\" %s\"%s\" %s\"%s\"", "-D" + Parameters.get("reportname") + "=", this.reportname.getText(), "-D" + Parameters.get("category") + "=", this.category.getText(), "-D" + Parameters.get("tags") + "=", this.tags.getText().length() == 0 ? " " : this.tags.getText(), "-D" + Parameters.get("platforms") + "=", platform, "-D" + Parameters.get("dataQueried") + "=", this.dataQueried.getText(), "-D" + Parameters.get("eventReportType") + "=", this.eventReportType.getText(), "-D" + Parameters.get("rdddir") + "=", rddDirValue);
    }

    @Override
    public boolean onPerformFinish() {
        IPath sdkPath = SDKUtil.getSDKProject().getLocation();
        sdkPath = sdkPath.uptoSegment(sdkPath.segmentCount() - 2);
        String pathName = sdkPath.toOSString();
        pathName = pathName + File.separator + "content" + File.separator + "dev" + File.separator + "reports";
        File newActionDirectory = new File(pathName = pathName + File.separator + this.category.getText() + File.separator + this.reportname.getText());
        if (newActionDirectory.exists()) {
            String newName = this.category.getText() + File.separator + this.reportname.getText();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewSentinelReportPluginPage_Title, (String)NLS.bind((String)Messages.Plugin_Already_Exist, (Object)newName));
            this.reportname.setFocus();
            return false;
        }
        this.category.saveToHistory();
        return true;
    }

    @Override
    public Point getPreferredSize() {
        return new Point(800, this.getWizard().getContainer().getShell().getSize().y);
    }

    private void addBuffer(Composite parent) {
        GridData spaceData = new GridData();
        spaceData.grabExcessVerticalSpace = false;
        spaceData.horizontalSpan = 2;
        spaceData.heightHint = 7;
        Label label = new Label(parent, 0);
        label.setText("");
        label.setLayoutData((Object)spaceData);
    }

    private void updateDataQueried() {
        this.dataQueried.removeAll();
        this.rdddir.setEnabled(false);
        this.rddInfoWidget.setEnabled(false);
        this.eventReportType.setEnabled(false);
        ArrayList<String> queryDataTypes = PlatformQueryData.getSupportedQueryTypes(this.platforms.getText());
        if (queryDataTypes.size() > 0) {
            this.dataQueried.setItems(queryDataTypes.toArray(new String[0]));
            this.dataQueried.setText(queryDataTypes.get(0));
            if (queryDataTypes.size() <= 1) {
                this.dataQueried.setEnabled(false);
                this.queryInfoWidget.setEnabled(false);
            } else {
                this.dataQueried.setEnabled(true);
                this.queryInfoWidget.setEnabled(true);
            }
        }
        this.enableOrDisableRDD();
    }

    private void enableOrDisableRDD() {
        boolean rddEnabled = PlatformQueryData.getRddSupported(this.platforms.getText(), this.dataQueried.getText());
        if (rddEnabled) {
            this.lblRDD.setText(Messages.NewSentinelReportPLuginPage_RDDRequired);
        } else {
            this.lblRDD.setText(Messages.NewSentinelReportPluginPage_RDDOptional);
        }
        this.rdddir.setEnabled(rddEnabled);
        this.rddInfoWidget.setEnabled(rddEnabled);
        this.dialogChanged();
        boolean eventTypeEnabled = PlatformQueryData.getEventTypeSupported(this.platforms.getText(), this.dataQueried.getText());
        this.eventReportType.setEnabled(eventTypeEnabled);
    }
}

