/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.sentinel.sdk.wizards;

import com.netiq.sentinel.sdk.Messages;
import com.netiq.sentinel.sdk.SDKUtil;
import com.netiq.sentinel.sdk.sdkscriptsproperties.ScriptProperties;
import com.netiq.sentinel.sdk.widgets.InfoWidget;
import com.netiq.sentinel.sdk.wizards.ISentinelSDKPage;
import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewSentinelSolutionPluginPage
extends WizardPage
implements ISentinelSDKPage {
    private Text sentinelPluginName;

    public NewSentinelSolutionPluginPage() {
        super(Messages.NewSentinelSolutionPluginPage_PageName);
        this.setTitle(Messages.NewSentinelSolutionPluginPage_Title);
        this.setDescription(Messages.NewSentinelSolutionPluginPage_Description);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        Label label = new Label(container, 0);
        label.setText(Messages.NewSentinelSolutionPluginPage_Name);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.sentinelPluginName = new Text(container, 2052);
        gd = new GridData(768);
        this.sentinelPluginName.setLayoutData((Object)gd);
        this.sentinelPluginName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSentinelSolutionPluginPage.this.dialogChanged();
            }
        });
        new InfoWidget(container, Messages.NewSentinelSolutionPluginPage_NameTitle, Messages.NewSentinelSolutionPluginPage_NameTip);
        label = new Label(container, 0);
        label.setText(Messages.NewSentinelSolutionPluginPage_NameExample);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.initialize();
        this.setErrorMessage(null);
        this.setPageComplete(false);
        this.setControl((Control)container);
    }

    private void initialize() {
    }

    private void dialogChanged() {
        if (this.getSentinelPluginName().length() == 0) {
            this.updateStatus(Messages.NewSentinelSolutionPluginPage_Name_Empty);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getSentinelPluginName() {
        return this.sentinelPluginName.getText();
    }

    @Override
    public String getArguments() {
        String Target = ScriptProperties.getTarget("buildnew", "newsolution");
        Map<String, String> Parameters = ScriptProperties.getParameters("buildnew", "newsolution");
        return String.format("\"" + Target + "\" -D" + Parameters.get("plugin") + "=\"%s\"", this.getSentinelPluginName());
    }

    @Override
    public boolean onPerformFinish() {
        IPath sdkPath = SDKUtil.getSDKProject().getLocation();
        sdkPath = sdkPath.uptoSegment(sdkPath.segmentCount() - 2);
        String pathName = sdkPath.toOSString();
        pathName = pathName + File.separator + "content" + File.separator + "dev" + File.separator + "solutions";
        File newActionDirectory = new File(pathName = pathName + File.separator + this.getSentinelPluginName());
        if (newActionDirectory.exists()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewSentinelSolutionPluginPage_Title, (String)NLS.bind((String)Messages.Plugin_Already_Exist, (Object)this.getSentinelPluginName()));
            this.sentinelPluginName.setFocus();
            return false;
        }
        return true;
    }

    @Override
    public Point getPreferredSize() {
        return new Point(800, this.getWizard().getContainer().getShell().getSize().y);
    }
}

