/*
 * Copyright (c) 1998, 1999 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

package examples.rmisocfac;

import java.io.*;

      
class XorInputStream extends FilterInputStream {
  
   /*
    * The byte being used to "decrypt" each byte of data.
    * Default is 10101010. 
    */
    private byte pattern = (byte)(170 & 0xFF);
  
    /*
     * Constructor for class XorInputStream
     */
    public XorInputStream(InputStream in, byte pattern) {
        super(in);
	if (pattern != 0)
            this.pattern = pattern;
    }
  
    /*
     * Reads in a byte and xor's the byte with the pattern.
     * Returns the byte.
     */
    public int read() throws IOException {
        int b = in.read();
        //If not end of file or an error, truncate b to one byte
	if (b != -1)
	  b = (b ^ pattern) & 0xFF;
                     
	return b;
    }
  
    /*
     * Reads up to len bytes
     */
    public int read(byte b[], int off, int len) throws IOException {
        int numBytes = in.read(b, off, len);

	if (numBytes <= 0)
	    return numBytes;

        int i = 0;
        for(; i < numBytes; i++) {
	    b[off + i] = (byte)((b[off + i] ^ pattern) & 0xFF);
        }
	return i;
    }
}
