/*************************************************************************

  Copyright (c) 1999 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
   CHNGSERV.C
**************************************************************************

  This is sample code that logs the user out of one server and into another

  Usage:  CHNGSERV <serverName> <userName> <password>

                  
  NOTE:   The code is not suitable for building a NLM. The API 
          NWCCGetPrimConnRef() is not supported on the Netware OS.
          
*************************************************************************/



#include <stdio.h>
#include <string.h>

#include <nwcalls.h>
#include <nwndscon.h>
#include <nwclxcon.h>

void main (int argc, char *argv[])
{
   NWCCODE        ccode;
   nuint32        connRef;
   NWCONN_HANDLE  oldConn, 
                  newConn;
   char           defaultServer[NW_MAX_SERVER_NAME_LEN+1],
                  serverName[NW_MAX_SERVER_NAME_LEN+1];



   /* Check the command-line arguments */
   if (4 != argc)
   {
      printf ("Usage:  %s <serverName> <userName> <password>\n", argv[0]);
      return;
   }


   /* Library initialization */
   ccode = NWCallsInit (NULL,NULL);
   if (ccode)
   {
      printf("NWCallsInit failed with error code=0x%04x\n", ccode);
      return;
   }
   ccode = NWCLXInit(NULL, NULL);
   if (ccode)
   {
      printf("NWCLXInit failed with error code=0x%04x\n", ccode);
      return;
   }

   /* Get the connection reference and a handle for default server */
   ccode = NWCCGetPrimConnRef (&connRef);
   if (ccode)
   {
      printf("NWCCGetPrimConnRef failed with error code=0x%04x\n", ccode);
      return;
   }
   ccode = NWCCOpenConnByRef(connRef, NWCC_OPEN_UNLICENSED, 0, &oldConn);
   if (ccode)
   {
      printf("NWCCOpenConnByRef failed with error code=0x%04x\n", ccode);
      return;
   }


   /* Get the name of the current default server and report it */
   ccode = NWCCGetConnRefInfo(
                              connRef,
                              NWCC_INFO_SERVER_NAME,
                              NW_MAX_SERVER_NAME_LEN,
                              defaultServer);
   if (ccode)
   {
      printf("NWCCGetConnRefInfo failed with error code=0x%04x\n", ccode);
      NWCCCloseConn(oldConn);
      return;
   }
   printf ("Default server is %s\n", defaultServer);


   /* Attach to the new server given using command-line arguments */
   strcpy (serverName, argv[1]);
   strupr (serverName);
   ccode = NWAttachToFileServer (serverName, 0, &newConn);
   if ((ccode) && (ALREADY_ATTACHED != ccode))
   {
      printf ("NWAttachToFileServer failed with error code=0x%04x\n", ccode);
      return;
   }

   /* Logout from the current default server and close all conn handles */
   ccode = NWLogoutFromFileServer (oldConn);
   if (ccode)
   {
      printf("NWLogoutFromFileServer failed with error code=0x%04x\n", ccode);
      return;
   }
   ccode = NWCCSysCloseConnRef(connRef);
   if (ccode)
   {
      printf("NWCCSysCloseConnRef failed with error code=0x%04x\n", ccode);
      return;
   }


   /* Login to the new server and set it to the default */
   ccode = NWLoginToFileServer (newConn, 
                                argv[2],   /* userName */
                                OT_USER, 
                                argv[3]);  /* password */
   if (ccode)
   {
      printf ("NWLoginToFileServer failed with error code=0x%04x\n", ccode);
      return;
   }
   ccode = NWCCSetPrimConn (newConn);
   if (ccode)
   {
      printf ("NWCCSetPrimConn failed with error code=0x%04x\n", ccode);
      return;
   }


   /* Finally, retrieve and report the new default server */
   ccode = NWCCGetPrimConnRef (&connRef);
   if (ccode)
   {
      printf("NWCCGetPrimConnRef failed with error code=0x%04x\n", ccode);
      return;
   }
   ccode = NWCCGetConnRefInfo(
                              connRef,
                              NWCC_INFO_SERVER_NAME,
                              NW_MAX_SERVER_NAME_LEN,
                              defaultServer);
   if (ccode)
   {
      printf("NWCCGetConnRefInfo failed with error code=0x%04x\n", ccode);
   }
   else
   {
      printf ("%s is your default server\n", defaultServer);
   }
}
