/*************************************************************************

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose.  */

/**************************************************************************
  OPENCONN.C
***************************************************************************

  OPENCONN.C demonstrates NWCCOpenConnByName and NWCCCloseConn.  This
  example requires a valid server name to be entered at the command 
  line.

  USAGE:  OPENCONN <Server Name>

*************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <nwcalls.h>
#include <nwclxcon.h>

int main(int argc, char *argv[])
{
   NWCCODE        ccode;      
   NWCONN_HANDLE  connHandle; 

   if(argc < 2)
   {
      printf("\nUSAGE:  OPENCONN <Server Name>\n");
      exit(1);
   }

   /* Initialize libraries */

   ccode = NWCallsInit(NULL, NULL); 
   if(ccode)
   {
      printf("\nNWCallsInit returned %04X", ccode);
      exit(1);
   }

   ccode = NWCLXInit(NULL, NULL);
   if(ccode)
   {
      printf("\nNWCLXInit returned %04X", ccode);
     exit(1);
   }

   /* Open the connection.  NWCCOpenConnByName resolves the given 
      name to a network address and creates a service connection to 
      that address.  */
     
   ccode = NWCCOpenConnByName(
             /* Handle to resolve name */  0, 
             /* Server name            */  strupr(argv[1]),
             /* Server name format     */  NWCC_NAME_FORMAT_BIND, 
             /* Connection open state  */  NWCC_OPEN_LICENSED, 
             /* Transport Type         */  NWCC_TRAN_TYPE_WILD,
             /* Connection Handle      */  &connHandle);
   if(ccode)
   {
      printf("\nNWCCOpenConnByName returned %04X", ccode);
     exit(1);
   }
   else
      printf("\nConnection handle %X opened to server: %s", 
             connHandle, strupr(argv[1]));

   /* Close the connection when finished */
   ccode = NWCCCloseConn(connHandle);
   if(ccode)
   {
      printf("\nNWCCCloseConn returned %04X", ccode);
      exit(1);
   }
   else
      printf("\nConnection handle closed");

   return(0);
}

    
    
    
    