/*************************************************************************

  Copyright (c) 1995, 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
   SETDRIVE.C
***************************************************************************


  SETDRIVE.C demonstrates how to map a drive to a NetWare server using 
  NWSetDriveBase().

  USAGE:  SETDRIVE <drive number> <server name> <path>

          drive number:   1=A, 2=B, etc.
          server name :   name of the server
          path        :   path to map, including volume name.

  Exmpl:  SETDRIVE 10 MYSERVER SYS:\DIRECTORY\SUBDIR

          (maps drive J to MYSERVER\SYS:\DIRECTORY\SUBDIR)

*************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <nwclxcon.h>
#include <nwcalls.h>
#include <nwnet.h>
#include <nwlocale.h>

int main(int argc, char *argv[])
{
   NWCONN_HANDLE       connHandle;
   NWCCODE             ccode;
   LCONV               lconvInfo;
   NWDSContextHandle   dContext;
   nbool8              bbDoLogout = N_FALSE;
   nstr8               strUserName[NW_MAX_USER_NAME_LEN];
   nstr8               strUserPassword[50];
   nstr8               strServerName[NW_MAX_SERVER_NAME_LEN];
   nstr8               strDriveNumber[3];
   nstr8               strPath[50];
   nstr8               strContext[MAX_DN_CHARS + 1];

   if(argc != 4)
   {
      printf ("\nUsage:   SETDRIVE <drivenumber> <server> <directory>\n");
      printf ("   drivenumber : A=1, B=2, etc...\n");
      printf ("   server      : name of server \n");
      printf ("   directory   : path of directory, including volume\n");
      printf ("\nExample: SETDRIVE 10 myserver sys:\\users\\mydir\\mysubdir\n");
      exit(1);
   }

   strcpy(strDriveNumber, strupr(argv[1]));
   strcpy(strServerName, strupr(argv[2]));
   strcpy(strPath, strupr(argv[3]));

   /* Initialize libraries */
   ccode = NWCallsInit(NULL,NULL);
   if(ccode)
   {
      printf("\nNWCallsInit returned %04X", ccode);
      exit(1);
   }

   NWLlocaleconv(&lconvInfo);

   ccode = NWInitUnicodeTables(lconvInfo.country_id, lconvInfo.code_page);
   if(ccode)
   {
      printf("NWInitUnicodeTables() returned: %04X\n", ccode);
      exit(1);
   }

   /* Create a context and authenticate to NDS if necessary */
   ccode = NWDSCreateContextHandle(&dContext);
   if(ccode)
   {
      printf("NWDSCreateContextHandle returned: %04lX\n", ccode);
      goto _FreeUnicodeTables;
   }

   ccode = NWDSGetContext(dContext, DCK_NAME_CONTEXT, strContext);
   if(ccode)
   {
      printf("\nNWDSGetContext returned %04X", ccode);
      exit(1);
   }
   printf("\nstrContext:  %s", strContext);

   /*  Must authenticate if not already authenticated to NDS */
   if(!NWIsDSAuthenticated())
   {
      printf("\nMust authenticate to NDS");
      printf("\nEnter User Name: ");
      gets(strUserName);
      printf("Enter User Password: ");
      gets(strUserPassword);

      ccode = NWDSLogin(dContext, 0, strUserName, strUserPassword, 0);
      if(ccode)
      {
         printf("\nNWDSLogin returned %X", ccode);
         goto _FreeContext;
      }
      else
         bbDoLogout = N_TRUE;
   }

   /* Open a connection to the specified server */
   
   printf("\nstrServerName: %s", strServerName);
   ccode = NWCCOpenConnByName(
           /*  start Conn Handle */ 0,  
           /*  name              */ strServerName,
           /*  name format       */ NWCC_NAME_FORMAT_BIND,
           /*  open state        */ NWCC_OPEN_UNLICENSED,
           /*  tran type         */ NWCC_TRAN_TYPE_IPX,
           /*  Connection Handle */ &connHandle);
   if(ccode)
   {
      printf( "\nNWCCOpenConnByName returned %04x", ccode );
      goto _Logout;
   }

   ccode = NWSetDriveBase(
             /* drive number     */  (nuint16)atoi(strDriveNumber), 
             /* handle to server */   connHandle, 
             /* directory handle */   0, 
             /* directory path   */   strPath, 
             /* reserved         */   0);
   if(ccode)
   {
      printf("\nNWSetDriveBase returned %04X\n", ccode);
      goto _FreeConnection;
   }

   /* Successful termintation */
   return(0);

   /* Unsuccessful termination */
_FreeConnection:
   NWCCCloseConn(connHandle);

_Logout:
   if (bbDoLogout == N_TRUE)
      NWDSLogout(dContext);

_FreeContext:
   NWDSFreeContext(dContext);

_FreeUnicodeTables:
   NWFreeUnicodeTables();

   return(1);
}
