/*************************************************************************

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
  ESUNIB.C
***************************************************************************

  After conversion, byteOut contains the converted byte string "abc[2620]".
  The default nomap handler converts the unmappable unicode character
  to the 6-byte string starting and ending in square brackets.

**************************************************************************/

#include <nunicode.h>
#include <stdio.h>
#include <assert.h>
#include <string.h>

void main(void)
{
   nint    icode;
   nuint   actualLen;
   unicode uniIn[5] = { 'a', 'b', 'c', 0x2620, 0};
   nuint8  byteOut[80];

   NWUSStandardUnicodeInit();     /* Error checking not shown */

   icode = NWUSUnicodeToByte( byteOut, 80, uniIn, &actualLen );

   if (icode)
      printf("NWUSUnicodeToByte returned error: %04X\n", icode);
   else
      assert(strcmp(byteOut,"abc[2620]")==0 && actualLen == 9);

   NWUSStandardUnicodeRelease();
} 


