/*************************************************************************

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
  ESUNIUBP.C
***************************************************************************

  After conversion, byteOut contains the unterminated converted byte
  string "\a\b\c\d".  The unicode backslash, yen sign, won sign, and
  Novell-defined path separator character are all converted to
  backslash (0x5C).

**************************************************************************/

#include <nunicode.h>
#include <stdio.h>
#include <assert.h>
#include <string.h>

#define BACKSLASH 0x005C
#define YEN       0x00A5
#define WON       0x20A9
#define PATHSEP   0xF8F7

void main(void)
{
   nint icode;
   nuint actualLen;
   unicode uniIn[9] =
       { BACKSLASH, 'a', YEN, 'b', WON, 'c', PATHSEP, 'd', 0 };
   nuint8 byteOut[12] = {'x','x','x','x','x','x','x','x','x','x','x',0};

   NWUSStandardUnicodeInit();     /* Error checking not shown */


   icode = NWUSUnicodeToUntermBytePath( byteOut, 12, uniIn , &actualLen);

   if (icode)
      printf("NWUSUnicodeToUntermBytePath returned error: %04X\n", icode);
   else
      assert( strcmp(byteOut,"\\a\\b\\c\\dxxx") == 0 && actualLen == 8);

   NWUSStandardUnicodeRelease();
} 

